/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.tileentity;

import com.google.common.collect.Sets;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.datastructure.SingleCache;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipe;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeInput;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeRegistry;
import org.cyclops.cyclopscore.recipe.custom.component.DurationRecipeProperties;
import org.cyclops.cyclopscore.recipe.custom.component.IngredientAndFluidStackRecipeComponent;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;
import org.cyclops.cyclopscore.tileentity.TankInventoryTileEntity;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.block.BlockDryingBasin;

public class TileDryingBasin
extends TankInventoryTileEntity
implements CyclopsTileEntity.ITickingTile {
    private static final int WOOD_IGNITION_TEMPERATURE = 573;
    private final CyclopsTileEntity.ITickingTile tickingTileComponent = new CyclopsTileEntity.TickingTileComponent((CyclopsTileEntity)this);
    @NBTPersist
    private Float randomRotation = Float.valueOf(0.0f);
    @NBTPersist
    private int progress = 0;
    @NBTPersist
    private int fire = 0;
    private SingleCache<Pair<ItemStack, FluidStack>, IRecipe<IngredientAndFluidStackRecipeComponent, IngredientAndFluidStackRecipeComponent, DurationRecipeProperties>> recipeCache;

    public TileDryingBasin() {
        super(1, "dryingBasingInventory", 1, 1000, "dryingBasingTank");
        this.addSlotsToSide(EnumFacing.UP, Sets.newHashSet((Object[])new Integer[]{0}));
        this.addSlotsToSide(EnumFacing.DOWN, Sets.newHashSet((Object[])new Integer[]{0}));
        this.addSlotsToSide(EnumFacing.NORTH, Sets.newHashSet((Object[])new Integer[]{0}));
        this.addSlotsToSide(EnumFacing.SOUTH, Sets.newHashSet((Object[])new Integer[]{0}));
        this.addSlotsToSide(EnumFacing.WEST, Sets.newHashSet((Object[])new Integer[]{0}));
        this.addSlotsToSide(EnumFacing.EAST, Sets.newHashSet((Object[])new Integer[]{0}));
        this.recipeCache = new SingleCache((SingleCache.ICacheUpdater)new SingleCache.ICacheUpdater<Pair<ItemStack, FluidStack>, IRecipe<IngredientAndFluidStackRecipeComponent, IngredientAndFluidStackRecipeComponent, DurationRecipeProperties>>(){

            public IRecipe<IngredientAndFluidStackRecipeComponent, IngredientAndFluidStackRecipeComponent, DurationRecipeProperties> getNewValue(Pair<ItemStack, FluidStack> key) {
                IngredientAndFluidStackRecipeComponent recipeInput = new IngredientAndFluidStackRecipeComponent((ItemStack)key.getLeft(), (FluidStack)key.getRight());
                IRecipe maxRecipe = null;
                for (IRecipe recipe : TileDryingBasin.this.getRegistry().findRecipesByInput((IRecipeInput)recipeInput)) {
                    if (key.getRight() == null) {
                        return recipe;
                    }
                    if (((FluidStack)key.getRight()).amount < ((IngredientAndFluidStackRecipeComponent)recipe.getInput()).getFluidStack().amount || maxRecipe != null && ((IngredientAndFluidStackRecipeComponent)recipe.getInput()).getFluidStack().amount <= ((IngredientAndFluidStackRecipeComponent)maxRecipe.getInput()).getFluidStack().amount) continue;
                    maxRecipe = recipe;
                }
                return maxRecipe;
            }

            public boolean isKeyEqual(Pair<ItemStack, FluidStack> cacheKey, Pair<ItemStack, FluidStack> newKey) {
                return cacheKey == null || newKey == null || ItemStack.func_77989_b((ItemStack)((ItemStack)cacheKey.getLeft()), (ItemStack)((ItemStack)newKey.getLeft())) && FluidStack.areFluidStackTagsEqual((FluidStack)((FluidStack)cacheKey.getRight()), (FluidStack)((FluidStack)newKey.getRight())) && FluidHelpers.getAmount((FluidStack)((FluidStack)cacheKey.getRight())) == FluidHelpers.getAmount((FluidStack)((FluidStack)newKey.getRight()));
            }
        });
    }

    protected IRecipeRegistry<BlockDryingBasin, IngredientAndFluidStackRecipeComponent, IngredientAndFluidStackRecipeComponent, DurationRecipeProperties> getRegistry() {
        return BlockDryingBasin.getInstance().getRecipeRegistry();
    }

    public IRecipe<IngredientAndFluidStackRecipeComponent, IngredientAndFluidStackRecipeComponent, DurationRecipeProperties> getCurrentRecipe() {
        return (IRecipe)this.recipeCache.get((Object)Pair.of((Object)this.func_70301_a(0).func_77946_l(), (Object)FluidHelpers.copy((FluidStack)this.getTank().getFluid())));
    }

    protected void updateTileEntity() {
        super.updateTileEntity();
        if (!this.field_145850_b.field_72995_K) {
            if (!this.getTank().isEmpty() && this.getTank().getFluid().getFluid().getTemperature(this.getTank().getFluid()) >= 573) {
                if (++this.fire >= 100) {
                    this.func_145831_w().func_175656_a(this.func_174877_v(), Blocks.field_150480_ab.func_176223_P());
                } else if (this.func_145831_w().func_175623_d(this.func_174877_v().func_177972_a(EnumFacing.UP)) && this.field_145850_b.field_73012_v.nextInt(10) == 0) {
                    this.func_145831_w().func_175656_a(this.func_174877_v().func_177972_a(EnumFacing.UP), Blocks.field_150480_ab.func_176223_P());
                }
            } else if (this.getCurrentRecipe() != null) {
                IRecipe<IngredientAndFluidStackRecipeComponent, IngredientAndFluidStackRecipeComponent, DurationRecipeProperties> recipe = this.getCurrentRecipe();
                if (this.progress >= ((DurationRecipeProperties)recipe.getProperties()).getDuration()) {
                    ItemStack output = ((IngredientAndFluidStackRecipeComponent)recipe.getOutput()).getFirstItemStack();
                    if (!output.func_190926_b()) {
                        output = output.func_77946_l();
                        this.func_70299_a(0, output);
                        int amount = FluidHelpers.getAmount((FluidStack)((IngredientAndFluidStackRecipeComponent)recipe.getInput()).getFluidStack());
                        this.drain(amount, true);
                        if (((IngredientAndFluidStackRecipeComponent)recipe.getOutput()).getFluidStack() != null && this.fill(((IngredientAndFluidStackRecipeComponent)recipe.getOutput()).getFluidStack(), true) == 0) {
                            IntegratedDynamics.clog(Level.ERROR, "Encountered an invalid recipe: " + recipe.getNamedId());
                        }
                    }
                    this.progress = 0;
                } else {
                    ++this.progress;
                    this.sendUpdate();
                }
                this.fire = 0;
            } else if (this.progress > 0 || this.fire > 0) {
                this.progress = 0;
                this.fire = 0;
                this.sendUpdate();
            }
        } else if (this.progress > 0 && this.field_145850_b.field_73012_v.nextInt(5) == 0) {
            Block block;
            if (!this.getTank().isEmpty() && (block = this.getTank().getFluid().getFluid().getBlock()) != null) {
                int blockStateId = Block.func_176210_f((IBlockState)block.func_176223_P());
                this.func_145831_w().func_175688_a(EnumParticleTypes.BLOCK_DUST, (double)this.func_174877_v().func_177958_n() + Math.random() * 0.8 + 0.1, (double)this.func_174877_v().func_177956_o() + Math.random() * 0.1 + 0.9, (double)this.func_174877_v().func_177952_p() + Math.random() * 0.8 + 0.1, 0.0, 0.1, 0.0, new int[]{blockStateId});
            }
            if (!this.func_70301_a(0).func_190926_b()) {
                int itemId = Item.func_150891_b((Item)this.func_70301_a(0).func_77973_b());
                this.func_145831_w().func_175688_a(EnumParticleTypes.ITEM_CRACK, (double)this.func_174877_v().func_177958_n() + Math.random() * 0.8 + 0.1, (double)this.func_174877_v().func_177956_o() + Math.random() * 0.1 + 0.9, (double)this.func_174877_v().func_177952_p() + Math.random() * 0.8 + 0.1, 0.0, 0.1, 0.0, new int[]{itemId});
            }
        }
    }

    public boolean func_180462_a(int slot, ItemStack itemStack, EnumFacing side) {
        return this.func_70301_a(0).func_190926_b();
    }

    public void func_70299_a(int slotId, ItemStack itemstack) {
        super.func_70299_a(slotId, itemstack);
        this.randomRotation = Float.valueOf(this.field_145850_b.field_73012_v.nextFloat() * 360.0f);
        this.sendUpdate();
    }

    public float getRandomRotation() {
        return this.randomRotation.floatValue();
    }

    public void func_73660_a() {
        this.tickingTileComponent.func_73660_a();
    }
}

