/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.persist.world;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.cyclopscore.persist.world.WorldStorage;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.core.network.Network;

public class NetworkWorldStorage
extends WorldStorage {
    private static NetworkWorldStorage INSTANCE = null;
    @NBTPersist
    private Set<INetwork> networks = Sets.newHashSet();

    private NetworkWorldStorage(ModBase mod) {
        super(mod);
    }

    public static NetworkWorldStorage getInstance(ModBase mod) {
        if (INSTANCE == null) {
            INSTANCE = new NetworkWorldStorage(mod);
        }
        return INSTANCE;
    }

    public void readGeneratedFieldsFromNBT(NBTTagCompound tag) {
        if (tag.func_150297_b("networks", MinecraftHelpers.NBTTag_Types.NBTTagCompound.ordinal()) && "org.cyclops.integrateddynamics.core.network.PartNetwork".equals(tag.func_74775_l("networks").func_74779_i("elementType"))) {
            NBTTagCompound collectionTag = tag.func_74775_l("networks");
            this.networks = Sets.newHashSet();
            NBTTagList list = collectionTag.func_150295_c("collection", MinecraftHelpers.NBTTag_Types.NBTTagCompound.ordinal());
            if (list.func_74745_c() > 0) {
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    NBTTagCompound entryTag = list.func_150305_b(i);
                    Network network = new Network();
                    network.fromNBT(entryTag.func_74775_l("element"));
                    this.networks.add(network);
                }
            }
        } else {
            super.readGeneratedFieldsFromNBT(tag);
        }
    }

    public void reset() {
        this.networks.clear();
    }

    protected String getDataId() {
        return "Networks";
    }

    public synchronized void addNewNetwork(INetwork network) {
        this.networks.add(network);
    }

    public synchronized void removeInvalidatedNetwork(INetwork network) {
        this.networks.remove(network);
    }

    public synchronized Set<INetwork> getNetworks() {
        return Collections.unmodifiableSet(Sets.newHashSet(this.networks));
    }

    public void afterLoad() {
        for (INetwork network : this.networks) {
            network.afterServerLoad();
        }
    }

    public void beforeSave() {
        for (INetwork network : this.networks) {
            network.beforeServerStop();
        }
    }
}

