/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.logicprogrammer;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.client.gui.subgui.ISubGuiBox;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.item.IValueTypeVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElementType;
import org.cyclops.integrateddynamics.api.logicprogrammer.IValueTypeLogicProgrammerElement;
import org.cyclops.integrateddynamics.block.BlockLogicProgrammer;
import org.cyclops.integrateddynamics.client.gui.GuiLogicProgrammerBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.evaluate.variable.gui.GuiElementValueTypeString;
import org.cyclops.integrateddynamics.core.item.ValueTypeVariableFacade;
import org.cyclops.integrateddynamics.core.logicprogrammer.LogicProgrammerElementTypes;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeLPElementRenderPattern;
import org.cyclops.integrateddynamics.inventory.container.ContainerLogicProgrammerBase;
import org.cyclops.integrateddynamics.item.ItemVariable;

public abstract class ValueTypeLPElementBase
implements IValueTypeLogicProgrammerElement<ISubGuiBox, GuiLogicProgrammerBase, ContainerLogicProgrammerBase> {
    private final IValueType<?> valueType;
    private GuiElementValueTypeString<GuiLogicProgrammerBase, ContainerLogicProgrammerBase> innerGuiElement;

    public ValueTypeLPElementBase(IValueType<?> valueType) {
        this.valueType = valueType;
        this.innerGuiElement = new GuiElementValueTypeString(this.valueType, this.getRenderPattern());
    }

    @Override
    public void loadTooltip(List<String> lines) {
        this.getInnerGuiElement().loadTooltip(lines);
    }

    @Override
    public ILogicProgrammerElementType getType() {
        return LogicProgrammerElementTypes.VALUETYPE;
    }

    @Override
    public String getMatchString() {
        return this.getLocalizedNameFull().toLowerCase();
    }

    @Override
    public boolean matchesInput(IValueType<?> valueType) {
        return false;
    }

    @Override
    public boolean matchesOutput(IValueType<?> valueType) {
        return ValueHelpers.correspondsTo(valueType, valueType);
    }

    @Override
    public String getLocalizedNameFull() {
        return L10NHelpers.localize((String)this.valueType.getUnlocalizedName(), (Object[])new Object[0]);
    }

    @Override
    public IConfigRenderPattern getRenderPattern() {
        return IConfigRenderPattern.NONE;
    }

    @Override
    public void onInputSlotUpdated(int slotId, ItemStack itemStack) {
    }

    @Override
    public boolean isFor(IVariableFacade variableFacade) {
        IValueTypeVariableFacade valueTypeFacade;
        if (variableFacade instanceof IValueTypeVariableFacade && (valueTypeFacade = (IValueTypeVariableFacade)variableFacade).isValid()) {
            return this.getValueType() == valueTypeFacade.getValueType();
        }
        return false;
    }

    @Override
    public boolean canWriteElementPre() {
        return true;
    }

    @Override
    public ItemStack writeElement(EntityPlayer player, ItemStack itemStack) {
        IVariableFacadeHandlerRegistry registry = (IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class);
        return registry.writeVariableFacadeItem(!MinecraftHelpers.isClientSide(), itemStack, ValueTypes.REGISTRY, new ValueTypeVariableFacadeFactory(this.getValueType(), this.getValue()), player, (Block)BlockLogicProgrammer.getInstance());
    }

    @Override
    public boolean canCurrentlyReadFromOtherItem() {
        return true;
    }

    @Override
    public void activate() {
    }

    @Override
    public void deactivate() {
    }

    @Override
    public int getColor() {
        return this.valueType.getDisplayColor();
    }

    @Override
    public String getSymbol() {
        return L10NHelpers.localize((String)this.valueType.getUnlocalizedName(), (Object[])new Object[0]);
    }

    @Override
    public boolean isItemValidForSlot(int slotId, ItemStack itemStack) {
        return itemStack.func_77973_b() == ItemVariable.getInstance();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isFocused(ISubGuiBox subGui) {
        if (subGui instanceof ValueTypeLPElementRenderPattern) {
            return ((ValueTypeLPElementRenderPattern)subGui).getSearchField().func_146206_l();
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setFocused(ISubGuiBox subGui, boolean focused) {
        if (subGui instanceof ValueTypeLPElementRenderPattern) {
            ((ValueTypeLPElementRenderPattern)subGui).getSearchField().func_146195_b(focused);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public abstract ISubGuiBox createSubGui(int var1, int var2, int var3, int var4, GuiLogicProgrammerBase var5, ContainerLogicProgrammerBase var6);

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setValueInGui(ISubGuiBox subGui) {
    }

    @Override
    public IValueType<?> getValueType() {
        return this.valueType;
    }

    public GuiElementValueTypeString<GuiLogicProgrammerBase, ContainerLogicProgrammerBase> getInnerGuiElement() {
        return this.innerGuiElement;
    }

    protected static class ValueTypeVariableFacadeFactory
    implements IVariableFacadeHandlerRegistry.IVariableFacadeFactory<IValueTypeVariableFacade> {
        private final IValueType valueType;
        private final IValue value;

        public ValueTypeVariableFacadeFactory(IValueType valueType, IValue value) {
            this.valueType = valueType;
            this.value = value;
        }

        public ValueTypeVariableFacadeFactory(IValue value) {
            this(value.getType(), value);
        }

        @Override
        public IValueTypeVariableFacade create(boolean generateId) {
            return new ValueTypeVariableFacade<IValue>(generateId, this.valueType, this.value);
        }

        @Override
        public IValueTypeVariableFacade create(int id) {
            return new ValueTypeVariableFacade<IValue>(id, this.valueType, this.value);
        }
    }
}

