/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.operator;

import java.util.Objects;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import org.apache.commons.lang3.ArrayUtils;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperatorSerializer;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.core.evaluate.operator.OperatorBase;
import org.cyclops.integrateddynamics.core.evaluate.operator.Operators;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.evaluate.variable.Variable;

public class CombinedOperator
extends OperatorBase {
    private final String unlocalizedType;

    public CombinedOperator(String symbol, String operatorName, OperatorsFunction function, IValueType outputType) {
        this(symbol, operatorName, function, new IValueType[]{ValueTypes.CATEGORY_ANY}, outputType, IConfigRenderPattern.PREFIX_1);
    }

    public CombinedOperator(String symbol, String operatorName, OperatorsFunction function, IValueType[] inputTypes, IValueType outputType, IConfigRenderPattern configRenderPattern) {
        super(symbol, operatorName, inputTypes, outputType, function, configRenderPattern);
        this.unlocalizedType = "virtual";
    }

    @Override
    protected String getUnlocalizedType() {
        return this.unlocalizedType;
    }

    @Override
    public IOperator materialize() {
        return this;
    }

    public static abstract class ListOperatorSerializer<F extends OperatorBase.IFunction>
    implements IOperatorSerializer<CombinedOperator> {
        private final String functionName;
        private final Class<F> functionClass;

        public ListOperatorSerializer(String functionName, Class<F> functionClass) {
            this.functionName = functionName;
            this.functionClass = functionClass;
        }

        @Override
        public boolean canHandle(IOperator operator) {
            return operator instanceof CombinedOperator && this.functionClass.isInstance(((CombinedOperator)operator).getFunction());
        }

        @Override
        public String getUniqueName() {
            return "combined." + this.functionName;
        }

        @Override
        public String serialize(CombinedOperator operator) {
            OperatorsFunction function = (OperatorsFunction)operator.getFunction();
            IOperator[] operators = function.getOperators();
            NBTTagCompound tag = new NBTTagCompound();
            NBTTagList list = new NBTTagList();
            for (IOperator functionOperator : operators) {
                list.func_74742_a((NBTBase)new NBTTagString(Operators.REGISTRY.serialize(functionOperator)));
            }
            tag.func_74782_a("operators", (NBTBase)list);
            return tag.toString();
        }

        @Override
        public CombinedOperator deserialize(String valueOperator) throws EvaluationException {
            NBTTagList list;
            try {
                NBTTagCompound tag = JsonToNBT.func_180713_a((String)valueOperator);
                list = tag.func_150295_c("operators", MinecraftHelpers.NBTTag_Types.NBTTagString.ordinal());
            }
            catch (NBTException e) {
                e.printStackTrace();
                throw new EvaluationException(e.getMessage());
            }
            IOperator[] operators = new IOperator[list.func_74745_c()];
            for (int i = 0; i < list.func_74745_c(); ++i) {
                operators[i] = Objects.requireNonNull(Operators.REGISTRY.deserialize(list.func_150307_f(i)));
            }
            return this.newFunction(operators);
        }

        public abstract CombinedOperator newFunction(IOperator ... var1) throws EvaluationException;
    }

    public static class Flip
    extends OperatorsFunction {
        public Flip(IOperator operator) {
            super(operator);
        }

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            int size = variables.getVariables().length;
            IValue[] values = new IValue[size];
            for (int i = 0; i < size; ++i) {
                int targetI = i < 2 ? 1 - i : i;
                values[i] = variables.getValue(targetI);
            }
            return ValueHelpers.evaluateOperator(this.getOperators()[0], values);
        }

        public static CombinedOperator asOperator(IOperator operator) throws EvaluationException {
            CombinedOperator combinedOperator;
            Flip flip = new Flip(operator);
            IValueType[] originalInputTypes = operator.getInputTypes();
            IValueType[] flippedInputTypes = new IValueType[originalInputTypes.length];
            if (originalInputTypes.length < 2) {
                throw new EvaluationException(L10NHelpers.localize((String)"operator.integrateddynamics.error.wrong_input_length_virtual", (Object[])new Object[]{L10NHelpers.localize((String)Operators.OPERATOR_FLIP.getUnlocalizedName(), (Object[])new Object[0]), L10NHelpers.localize((String)operator.getUnlocalizedName(), (Object[])new Object[0]), originalInputTypes.length, 2}));
            }
            for (int i = 0; i < flippedInputTypes.length; ++i) {
                int targetI = i < 2 ? 1 - i : i;
                flippedInputTypes[i] = originalInputTypes[targetI];
            }
            try {
                combinedOperator = new CombinedOperator(":flip:", "flipped", flip, flippedInputTypes, operator.getOutputType(), operator.getRenderPattern());
            }
            catch (IllegalArgumentException e) {
                throw new EvaluationException(e.getMessage());
            }
            return combinedOperator;
        }

        public static class Serializer
        extends ListOperatorSerializer<Flip> {
            public Serializer() {
                super("flip", Flip.class);
            }

            @Override
            public CombinedOperator newFunction(IOperator ... operators) throws EvaluationException {
                return Flip.asOperator(operators[0]);
            }
        }
    }

    public static class Pipe2
    extends OperatorsFunction {
        public Pipe2(IOperator ... operators) {
            super(operators);
        }

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            IOperator[] operators = this.getOperators();
            Object input = variables.getValue(0);
            IValue[] intermediates = new IValue[operators.length - 1];
            for (int i = 0; i < operators.length - 1; ++i) {
                intermediates[i] = ValueHelpers.evaluateOperator(operators[i], new IValue[]{input});
            }
            return ValueHelpers.evaluateOperator(operators[operators.length - 1], intermediates);
        }

        public static CombinedOperator asOperator(IOperator ... operators) {
            Pipe2 pipe2 = new Pipe2(operators);
            return new CombinedOperator(":.2:", "piped2", pipe2, operators[operators.length - 1].getOutputType());
        }

        public static class Serializer
        extends ListOperatorSerializer<Pipe2> {
            public Serializer() {
                super("pipe2", Pipe2.class);
            }

            @Override
            public CombinedOperator newFunction(IOperator ... operators) {
                return Pipe2.asOperator(operators);
            }
        }
    }

    public static class Pipe
    extends OperatorsFunction {
        public Pipe(IOperator ... operators) {
            super(operators);
        }

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            return Pipe.pipeVariablesToOperators(variables.getVariables(), this.getOperators())[0].getValue();
        }

        protected static IVariable[] pipeVariablesToOperators(IVariable[] allVariables, IOperator[] operators) throws EvaluationException {
            for (IOperator operator : operators) {
                if (allVariables.length < operator.getRequiredInputLength()) {
                    throw new EvaluationException(String.format("Pipe failure: operator %s expects input of length %s,but %s was given.", operator.getUniqueName(), operator.getRequiredInputLength(), allVariables.length));
                }
                IVariable[] subVariables = (IVariable[])ArrayUtils.subarray((Object[])allVariables, (int)0, (int)operator.getRequiredInputLength());
                Object[] remainingVariables = (IVariable[])ArrayUtils.subarray((Object[])allVariables, (int)operator.getRequiredInputLength(), (int)allVariables.length);
                IValue outputValue = ValueHelpers.evaluateOperator(operator, subVariables);
                allVariables = (IVariable[])ArrayUtils.addAll((Object[])new IVariable[]{new Variable<IValue>(outputValue)}, (Object[])remainingVariables);
            }
            return allVariables;
        }

        public static CombinedOperator asOperator(final IOperator ... operators) {
            Pipe pipe = new Pipe(operators);
            return new CombinedOperator(":.:", "piped", pipe, operators[operators.length - 1].getOutputType()){

                @Override
                public IValueType getConditionalOutputType(IVariable[] allVariables) {
                    try {
                        allVariables = Pipe.pipeVariablesToOperators(allVariables, operators);
                    }
                    catch (EvaluationException e) {
                        return ValueTypes.CATEGORY_ANY;
                    }
                    return operators[operators.length - 1].getConditionalOutputType(allVariables);
                }

                @Override
                public IValueType[] getInputTypes() {
                    Object[] valueTypes = new IValueType[]{};
                    boolean removeOutputType = false;
                    for (IOperator operator : operators) {
                        Object[] operatorInputTypes = operator.getInputTypes();
                        if (removeOutputType && operatorInputTypes.length > 0) {
                            operatorInputTypes = (IValueType[])ArrayUtils.subarray((Object[])operatorInputTypes, (int)1, (int)operatorInputTypes.length);
                        }
                        valueTypes = (IValueType[])ArrayUtils.addAll((Object[])valueTypes, (Object[])operatorInputTypes);
                        removeOutputType = true;
                    }
                    return valueTypes;
                }
            };
        }

        public static class Serializer
        extends ListOperatorSerializer<Pipe> {
            public Serializer() {
                super("pipe", Pipe.class);
            }

            @Override
            public CombinedOperator newFunction(IOperator ... operators) {
                return Pipe.asOperator(operators);
            }
        }
    }

    public static class Negation
    extends OperatorsFunction {
        public Negation(IOperator operator) {
            super(operator);
        }

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            Object value = variables.getValue(0);
            IValue result = ValueHelpers.evaluateOperator(this.getOperators()[0], new IValue[]{value});
            return ValueTypeBoolean.ValueBoolean.of(!((ValueTypeBoolean.ValueBoolean)result).getRawValue());
        }

        public static CombinedOperator asOperator(IOperator operator) {
            Negation negation = new Negation(operator);
            return new CombinedOperator("!:", "p_negation", negation, ValueTypes.BOOLEAN);
        }

        public static class Serializer
        extends ListOperatorSerializer<Negation> {
            public Serializer() {
                super("negation", Negation.class);
            }

            @Override
            public CombinedOperator newFunction(IOperator ... operators) {
                return Negation.asOperator(operators[0]);
            }
        }
    }

    public static class Disjunction
    extends OperatorsFunction {
        public Disjunction(IOperator ... operators) {
            super(operators);
        }

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            Object value = variables.getValue(0);
            for (IOperator operator : this.getOperators()) {
                IValue result = ValueHelpers.evaluateOperator(operator, new IValue[]{value});
                if (!((ValueTypeBoolean.ValueBoolean)result).getRawValue()) continue;
                return ValueTypeBoolean.ValueBoolean.of(true);
            }
            return ValueTypeBoolean.ValueBoolean.of(false);
        }

        public static CombinedOperator asOperator(IOperator ... operators) {
            Disjunction disjunction = new Disjunction(operators);
            return new CombinedOperator(":||:", "p_disjunction", disjunction, ValueTypes.BOOLEAN);
        }

        public static class Serializer
        extends ListOperatorSerializer<Disjunction> {
            public Serializer() {
                super("disjunction", Disjunction.class);
            }

            @Override
            public CombinedOperator newFunction(IOperator ... operators) {
                return Disjunction.asOperator(operators);
            }
        }
    }

    public static class Conjunction
    extends OperatorsFunction {
        public Conjunction(IOperator ... operators) {
            super(operators);
        }

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            Object value = variables.getValue(0);
            for (IOperator operator : this.getOperators()) {
                IValue result = ValueHelpers.evaluateOperator(operator, new IValue[]{value});
                if (((ValueTypeBoolean.ValueBoolean)result).getRawValue()) continue;
                return ValueTypeBoolean.ValueBoolean.of(false);
            }
            return ValueTypeBoolean.ValueBoolean.of(true);
        }

        public static CombinedOperator asOperator(IOperator ... operators) {
            Conjunction conjunction = new Conjunction(operators);
            return new CombinedOperator(":&&:", "p_conjunction", conjunction, ValueTypes.BOOLEAN);
        }

        public static class Serializer
        extends ListOperatorSerializer<Conjunction> {
            public Serializer() {
                super("conjunction", Conjunction.class);
            }

            @Override
            public CombinedOperator newFunction(IOperator ... operators) {
                return Conjunction.asOperator(operators);
            }
        }
    }

    public static abstract class OperatorsFunction
    implements OperatorBase.IFunction {
        private final IOperator[] operators;

        public OperatorsFunction(IOperator ... operators) {
            this.operators = operators;
        }

        public IOperator[] getOperators() {
            return this.operators;
        }

        public int getInputOperatorCount() {
            return this.getOperators().length;
        }
    }
}

