/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.tileentity;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.datastructure.SingleCache;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.inventory.slot.SlotFluidContainer;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipe;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeInput;
import org.cyclops.cyclopscore.recipe.custom.component.IngredientRecipeComponent;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;
import org.cyclops.evilcraft.block.BloodInfuser;
import org.cyclops.evilcraft.core.fluid.BloodFluidConverter;
import org.cyclops.evilcraft.core.fluid.ImplicitFluidConversionTank;
import org.cyclops.evilcraft.core.recipe.custom.DurationXpRecipeProperties;
import org.cyclops.evilcraft.core.recipe.custom.IngredientFluidStackAndTierRecipeComponent;
import org.cyclops.evilcraft.core.tileentity.tickaction.ITickAction;
import org.cyclops.evilcraft.core.tileentity.tickaction.TickComponent;
import org.cyclops.evilcraft.core.tileentity.upgrade.IUpgradeSensitiveEvent;
import org.cyclops.evilcraft.core.tileentity.upgrade.UpgradeBehaviour;
import org.cyclops.evilcraft.core.tileentity.upgrade.Upgrades;
import org.cyclops.evilcraft.fluid.Blood;
import org.cyclops.evilcraft.tileentity.TileWorking;
import org.cyclops.evilcraft.tileentity.tickaction.EmptyFluidContainerInTankTickAction;
import org.cyclops.evilcraft.tileentity.tickaction.bloodinfuser.FluidContainerItemTickAction;
import org.cyclops.evilcraft.tileentity.tickaction.bloodinfuser.InfuseItemTickAction;

public class TileBloodInfuser
extends TileWorking<TileBloodInfuser, MutableInt> {
    public static final int SLOTS = 3;
    public static final int SLOT_CONTAINER = 0;
    public static final int SLOT_INFUSE = 1;
    public static final int SLOT_INFUSE_RESULT = 2;
    public static String TANKNAME = "bloodInfuserTank";
    public static final int LIQUID_PER_SLOT = 10000;
    public static final int TICKS_PER_LIQUID = 2;
    public static final Fluid ACCEPTED_FLUID = Blood.getInstance();
    private int infuseTicker = this.addTicker(new TickComponent<TileBloodInfuser, ITickAction<TileBloodInfuser>>(this, INFUSE_TICK_ACTIONS, 1));
    private SingleCache<Triple<ItemStack, FluidStack, Integer>, IRecipe<IngredientFluidStackAndTierRecipeComponent, IngredientRecipeComponent, DurationXpRecipeProperties>> recipeCache;
    private static final Multimap<Class<?>, ITickAction<TileBloodInfuser>> INFUSE_TICK_ACTIONS = LinkedListMultimap.create();
    private static final Map<Class<?>, ITickAction<TileBloodInfuser>> EMPTY_IN_TANK_TICK_ACTIONS;
    public static final Upgrades.UpgradeEventType UPGRADEEVENT_SPEED;
    public static final Upgrades.UpgradeEventType UPGRADEEVENT_BLOODUSAGE;
    public static final Upgrades.UpgradeEventType UPGRADEEVENT_FILLBLOODPERTICK;

    public TileBloodInfuser() {
        super(3, BloodInfuser.getInstance().func_149732_F(), 10000, TANKNAME, ACCEPTED_FLUID);
        this.addTicker(new TickComponent<TileBloodInfuser, ITickAction<TileBloodInfuser>>(this, EMPTY_IN_TANK_TICK_ACTIONS, 0, false, true));
        LinkedList<Integer> inSlots = new LinkedList<Integer>();
        inSlots.add(1);
        LinkedList<Integer> inSlotsTank = new LinkedList<Integer>();
        inSlotsTank.add(0);
        LinkedList<Integer> outSlots = new LinkedList<Integer>();
        outSlots.add(2);
        this.addSlotsToSide(EnumFacing.EAST, inSlotsTank);
        this.addSlotsToSide(EnumFacing.UP, inSlots);
        this.addSlotsToSide(EnumFacing.NORTH, inSlots);
        this.addSlotsToSide(EnumFacing.DOWN, outSlots);
        this.addSlotsToSide(EnumFacing.SOUTH, outSlots);
        this.addSlotsToSide(EnumFacing.WEST, outSlots);
        this.upgradeBehaviour.put(UPGRADE_EFFICIENCY, new UpgradeBehaviour<TileBloodInfuser, MutableInt>(2.0){

            @Override
            public void applyUpgrade(TileBloodInfuser upgradable, Upgrades.Upgrade upgrade, int upgradeLevel, IUpgradeSensitiveEvent<MutableInt> event) {
                if (event.getType() == UPGRADEEVENT_BLOODUSAGE) {
                    int val = event.getObject().getValue();
                    val = (int)((double)val / (1.0 + (double)upgradeLevel / this.valueFactor));
                    event.getObject().setValue(val);
                }
            }
        });
        this.upgradeBehaviour.put(UPGRADE_SPEED, new UpgradeBehaviour<TileBloodInfuser, MutableInt>(1.0){

            @Override
            public void applyUpgrade(TileBloodInfuser upgradable, Upgrades.Upgrade upgrade, int upgradeLevel, IUpgradeSensitiveEvent<MutableInt> event) {
                if (event.getType() == UPGRADEEVENT_FILLBLOODPERTICK) {
                    int val = event.getObject().getValue();
                    val = (int)((double)val * (1.0 + (double)upgradeLevel / this.valueFactor));
                    event.getObject().setValue(val);
                } else if (event.getType() == UPGRADEEVENT_SPEED) {
                    int val = event.getObject().getValue();
                    val = (int)((double)val / (1.0 + (double)upgradeLevel / this.valueFactor));
                    event.getObject().setValue(val);
                }
            }
        });
        this.recipeCache = new SingleCache((SingleCache.ICacheUpdater)new SingleCache.ICacheUpdater<Triple<ItemStack, FluidStack, Integer>, IRecipe<IngredientFluidStackAndTierRecipeComponent, IngredientRecipeComponent, DurationXpRecipeProperties>>(){

            public IRecipe<IngredientFluidStackAndTierRecipeComponent, IngredientRecipeComponent, DurationXpRecipeProperties> getNewValue(Triple<ItemStack, FluidStack, Integer> key) {
                IngredientFluidStackAndTierRecipeComponent recipeInput = new IngredientFluidStackAndTierRecipeComponent((ItemStack)key.getLeft(), (FluidStack)key.getMiddle(), -1);
                IRecipe maxRecipe = null;
                int maxRecipeTier = -1;
                for (IRecipe recipe : BloodInfuser.getInstance().getRecipeRegistry().findRecipesByInput((IRecipeInput)recipeInput)) {
                    if (((IngredientFluidStackAndTierRecipeComponent)recipe.getInput()).getTier() <= maxRecipeTier || (Integer)key.getRight() < ((IngredientFluidStackAndTierRecipeComponent)recipe.getInput()).getTier()) continue;
                    maxRecipe = recipe;
                }
                return maxRecipe;
            }

            public boolean isKeyEqual(Triple<ItemStack, FluidStack, Integer> cacheKey, Triple<ItemStack, FluidStack, Integer> newKey) {
                return cacheKey == null || newKey == null || ItemStack.func_77989_b((ItemStack)((ItemStack)cacheKey.getLeft()), (ItemStack)((ItemStack)newKey.getLeft())) && FluidStack.areFluidStackTagsEqual((FluidStack)((FluidStack)cacheKey.getMiddle()), (FluidStack)((FluidStack)newKey.getMiddle())) && ((Integer)cacheKey.getRight()).equals(newKey.getRight());
            }
        });
    }

    public EnumFacing getRotation() {
        return ((EnumFacing)BlockHelpers.getSafeBlockStateProperty((IBlockState)this.func_145831_w().func_180495_p(this.func_174877_v()), (IProperty)BloodInfuser.FACING, (Comparable)EnumFacing.NORTH)).func_176734_d();
    }

    protected SingleUseTank newTank(String tankName, int tankSize) {
        return new ImplicitFluidConversionTank(tankName, tankSize, (CyclopsTileEntity)this, BloodFluidConverter.getInstance());
    }

    public IRecipe<IngredientFluidStackAndTierRecipeComponent, IngredientRecipeComponent, DurationXpRecipeProperties> getRecipe(ItemStack itemStack) {
        return (IRecipe)this.recipeCache.get((Object)Triple.of((Object)(itemStack.func_190926_b() ? ItemStack.field_190927_a : itemStack.func_77946_l()), (Object)(this.getTank().getFluid() == null ? null : this.getTank().getFluid().copy()), (Object)this.getTier()));
    }

    @Override
    public boolean canConsume(ItemStack itemStack) {
        IFluidHandlerItem fluidHandler;
        if (!itemStack.func_190926_b() && (fluidHandler = FluidUtil.getFluidHandler((ItemStack)itemStack.func_77946_l().func_77979_a(1))) != null) {
            return fluidHandler.fill(this.getTank().getFluid(), false) > 0;
        }
        IRecipe<IngredientFluidStackAndTierRecipeComponent, IngredientRecipeComponent, DurationXpRecipeProperties> recipe = this.getRecipe(itemStack);
        return recipe != null;
    }

    public int getConsumeSlot() {
        return 1;
    }

    public int getProduceSlot() {
        return 2;
    }

    @Override
    public boolean canInsertItem(int slot, ItemStack itemStack) {
        return slot != this.getProduceSlot() && super.canInsertItem(slot, itemStack);
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack itemStack) {
        if (slot == 1) {
            return this.canConsume(itemStack);
        }
        if (slot == 0) {
            return SlotFluidContainer.checkIsItemValid((ItemStack)itemStack, (SingleUseTank)this.getTank());
        }
        return super.func_94041_b(slot, itemStack);
    }

    @Override
    public void onStateChanged() {
        this.sendUpdate();
        this.field_145850_b.func_175656_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()).func_177226_a((IProperty)BloodInfuser.ON, (Comparable)Boolean.valueOf(this.isWorking())));
        BlockHelpers.markForUpdate((World)this.func_145831_w(), (BlockPos)this.func_174877_v());
    }

    @Override
    public boolean canWork() {
        return true;
    }

    @Override
    protected int getWorkTicker() {
        return this.infuseTicker;
    }

    protected boolean isUpdateInventoryHashOnTankContentsChanged() {
        return true;
    }

    static {
        INFUSE_TICK_ACTIONS.put(Item.class, (Object)new FluidContainerItemTickAction());
        INFUSE_TICK_ACTIONS.put(Item.class, (Object)new InfuseItemTickAction());
        EMPTY_IN_TANK_TICK_ACTIONS = new LinkedHashMap();
        EMPTY_IN_TANK_TICK_ACTIONS.put(Item.class, new EmptyFluidContainerInTankTickAction());
        UPGRADEEVENT_SPEED = Upgrades.newUpgradeEventType();
        UPGRADEEVENT_BLOODUSAGE = Upgrades.newUpgradeEventType();
        UPGRADEEVENT_FILLBLOODPERTICK = Upgrades.newUpgradeEventType();
    }
}

