/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.infobook.pageelement;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.infobook.AdvancedButton;
import org.cyclops.cyclopscore.infobook.GuiInfoBook;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.infobook.pageelement.RecipeAppendix;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipe;
import org.cyclops.cyclopscore.recipe.custom.component.IngredientRecipeComponent;
import org.cyclops.evilcraft.api.broom.BroomModifier;
import org.cyclops.evilcraft.core.recipe.custom.DurationXpRecipeProperties;
import org.cyclops.evilcraft.core.recipe.custom.IngredientFluidStackAndTierRecipeComponent;

public class BroomModifierRecipeAppendix
extends RecipeAppendix<IRecipe<IngredientFluidStackAndTierRecipeComponent, IngredientRecipeComponent, DurationXpRecipeProperties>> {
    private static final int START_X_RESULT = 68;
    private static final AdvancedButton.Enum INPUT = AdvancedButton.Enum.create();
    private final BroomModifier modifier;
    private final List<Pair<ItemStack, Float>> modifierValues;

    public BroomModifierRecipeAppendix(IInfoBook infoBook, BroomModifier modifier, Map<ItemStack, Float> modifierValues) {
        super(infoBook, null);
        this.modifier = modifier;
        this.modifierValues = Lists.newArrayList();
        for (Map.Entry<ItemStack, Float> entry : modifierValues.entrySet()) {
            this.modifierValues.add((Pair<ItemStack, Float>)Pair.of((Object)entry.getKey(), (Object)entry.getValue()));
        }
    }

    protected int getWidth() {
        return 100;
    }

    protected int getHeightInner() {
        return 15;
    }

    protected String getUnlocalizedTitle() {
        return "broom.modifiers.evilcraft.type.name";
    }

    public void bakeElement(InfoSection infoSection) {
        this.renderItemHolders.put(INPUT, new RecipeAppendix.ItemButton(this.getInfoBook()));
        super.bakeElement(infoSection);
    }

    public void drawElementInner(GuiInfoBook gui, int x, int y, int width, int height, int page, int mx, int my) {
        int tick = this.getTick(gui);
        Pair<ItemStack, Float> value = this.modifierValues.get(tick % this.modifierValues.size());
        ItemStack input = (ItemStack)value.getKey();
        this.renderItem(gui, x, y, input, mx, my, INPUT);
        String line = String.format("+ %s %s", ((Float)value.getValue()).toString(), L10NHelpers.localize((String)this.modifier.getUnlocalizedName(), (Object[])new Object[0]));
        this.drawString(gui, line, x + 16 + 4, y + 3);
    }

    protected void drawString(GuiInfoBook gui, String string, int x, int y) {
        FontRenderer fontRenderer = gui.getFontRenderer();
        boolean oldUnicode = fontRenderer.func_82883_a();
        fontRenderer.func_78264_a(true);
        fontRenderer.func_78275_b(false);
        fontRenderer.func_78279_b(string, x, y, 200, 0);
        fontRenderer.func_78264_a(oldUnicode);
    }
}

