/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import org.cyclops.cyclopscore.helper.InventoryHelpers;

public class NBTCraftingGrid
extends InventoryCrafting {
    private static final String NBT_TAG_ROOT = "CraftingGridInventory";
    protected EntityPlayer player;
    protected int itemIndex;
    protected EnumHand hand;

    public NBTCraftingGrid(EntityPlayer player, int itemIndex, EnumHand hand, Container eventHandler) {
        super(eventHandler, 3, 3);
        ItemStack itemStack = InventoryHelpers.getItemFromIndex((EntityPlayer)player, (int)itemIndex, (EnumHand)hand);
        this.player = player;
        this.itemIndex = itemIndex;
        this.hand = hand;
        InventoryHelpers.validateNBTStorage((IInventory)this, (ItemStack)itemStack, (String)NBT_TAG_ROOT);
    }

    public void save() {
        ItemStack itemStack = InventoryHelpers.getItemFromIndex((EntityPlayer)this.player, (int)this.itemIndex, (EnumHand)this.hand);
        NBTTagCompound tag = itemStack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        this.writeToNBT(tag, NBT_TAG_ROOT);
        itemStack.func_77982_d(tag);
    }

    protected void readFromNBT(NBTTagCompound data, String tagName) {
        InventoryHelpers.readFromNBT((IInventory)this, (NBTTagCompound)data, (String)tagName);
    }

    protected void writeToNBT(NBTTagCompound data, String tagName) {
        InventoryHelpers.writeToNBT((IInventory)this, (NBTTagCompound)data, (String)tagName);
    }
}

