/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.broom;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.StringUtils;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.api.broom.BroomModifier;
import org.cyclops.evilcraft.api.broom.BroomModifiers;
import org.cyclops.evilcraft.api.broom.IBroomPart;
import org.cyclops.evilcraft.api.broom.IBroomPartRegistry;
import org.cyclops.evilcraft.core.broom.BroomPartBase;
import org.cyclops.evilcraft.core.broom.BroomPartCapGem;
import org.cyclops.evilcraft.core.broom.BroomPartCapMetal;
import org.cyclops.evilcraft.item.BroomPart;

public final class BroomParts {
    public static final IBroomPartRegistry REGISTRY = (IBroomPartRegistry)EvilCraft._instance.getRegistryManager().getRegistry(IBroomPartRegistry.class);
    public static IBroomPart ROD_BARE;
    public static IBroomPart ROD_WOOD;
    public static IBroomPart ROD_STONE;
    public static IBroomPart ROD_BONE;
    public static IBroomPart ROD_BLAZE;
    public static IBroomPart ROD_REED;
    public static IBroomPart ROD_NETHERRACK;
    public static IBroomPart ROD_OBSIDIAN;
    public static IBroomPart ROD_UNDEAD;
    public static IBroomPart ROD_PRISMARINE;
    public static IBroomPart ROD_ICE;
    public static IBroomPart ROD_SPONGE;
    public static IBroomPart ROD_ENDSTONE;
    public static IBroomPart ROD_PURPUR;
    public static IBroomPart BRUSH_BARE;
    public static IBroomPart BRUSH_WHEAT;
    public static IBroomPart BRUSH_WOOL;
    public static IBroomPart BRUSH_FEATHER;
    public static IBroomPart BRUSH_TWIG;
    public static IBroomPart BRUSH_LEAVES;
    public static IBroomPart CAP_BARE;
    public static IBroomPart CAP_GEM_DARK;
    public static IBroomPart CAP_GEM_DIAMOND;
    public static IBroomPart CAP_GEM_EMERALD;
    public static IBroomPart CAP_GEM_QUARTZ;
    public static IBroomPart CAP_GEM_DARKPOWER;
    public static IBroomPart CAP_HEAD_SKELETON;
    public static IBroomPart CAP_HEAD_WITHERSKELETON;
    public static IBroomPart CAP_HEAD_ZOMBIE;
    public static IBroomPart CAP_HEAD_PLAYER;
    public static IBroomPart CAP_HEAD_CREEPER;
    public static IBroomPart CAP_HEAD_WITHER;
    public static IBroomPart CAP_METAL_IRON;
    public static IBroomPart CAP_METAL_GOLD;
    public static IBroomPart CAP_METAL_THAUMIUM;
    public static IBroomPart CAP_METAL_COPPER;
    public static IBroomPart CAP_METAL_SILVER;
    public static IBroomPart CAP_METAL_BRASS;
    public static IBroomPart CAP_METAL_ARDITE;
    public static IBroomPart CAP_METAL_COBALT;
    public static IBroomPart CAP_METAL_MANYULLYN;
    public static IBroomPart CAP_SLIME;

    public static void init() {
    }

    public static void loadPre() {
        ROD_BARE = REGISTRY.registerPart(new BroomPartBase(new ResourceLocation("evilcraft", "rod_bare"), IBroomPart.BroomPartType.ROD, 1.0f));
        ROD_WOOD = REGISTRY.registerPart(new BroomPartBase(new ResourceLocation("evilcraft", "rod_wood"), IBroomPart.BroomPartType.ROD, 1.0f));
        ROD_STONE = REGISTRY.registerPart(new BroomPartBase(new ResourceLocation("evilcraft", "rod_stone"), IBroomPart.BroomPartType.ROD, 1.0f));
        ROD_BONE = REGISTRY.registerPart(new BroomPartBase(new ResourceLocation("evilcraft", "rod_bone"), IBroomPart.BroomPartType.ROD, 1.0f));
        ROD_BLAZE = REGISTRY.registerPart(new BroomPartBase(new ResourceLocation("evilcraft", "rod_blaze"), IBroomPart.BroomPartType.ROD, 1.0f));
        ROD_REED = REGISTRY.registerPart(new BroomPartBase(new ResourceLocation("evilcraft", "rod_reed"), IBroomPart.BroomPartType.ROD, 1.0f));
        ROD_NETHERRACK = REGISTRY.registerPart(new BroomPartBase(new ResourceLocation("evilcraft", "rod_netherrack"), IBroomPart.BroomPartType.ROD, 1.0f));
        ROD_OBSIDIAN = REGISTRY.registerPart(new BroomPartBase(new ResourceLocation("evilcraft", "rod_obsidian"), IBroomPart.BroomPartType.ROD, 1.0f));
        ROD_UNDEAD = REGISTRY.registerPart(new BroomPartBase(new ResourceLocation("evilcraft", "rod_undead"), IBroomPart.BroomPartType.ROD, 1.0f));
        ROD_PRISMARINE = REGISTRY.registerPart(new BroomPartBase(new ResourceLocation("evilcraft", "rod_prismarine"), IBroomPart.BroomPartType.ROD, 1.0f));
        ROD_ICE = REGISTRY.registerPart(new BroomPartBase(new ResourceLocation("evilcraft", "rod_ice"), IBroomPart.BroomPartType.ROD, 1.0f));
        ROD_SPONGE = REGISTRY.registerPart(new BroomPartBase(new ResourceLocation("evilcraft", "rod_sponge"), IBroomPart.BroomPartType.ROD, 1.0f));
        ROD_ENDSTONE = REGISTRY.registerPart(new BroomPartBase(new ResourceLocation("evilcraft", "rod_endstone"), IBroomPart.BroomPartType.ROD, 1.0f));
        ROD_PURPUR = REGISTRY.registerPart(new BroomPartBase(new ResourceLocation("evilcraft", "rod_purpur"), IBroomPart.BroomPartType.ROD, 1.0f));
        BRUSH_BARE = REGISTRY.registerPart(new BroomPartBase(new ResourceLocation("evilcraft", "brush_bare"), IBroomPart.BroomPartType.BRUSH, 0.4375f));
        BRUSH_WHEAT = REGISTRY.registerPart(new BroomPartBase(new ResourceLocation("evilcraft", "brush_wheat"), IBroomPart.BroomPartType.BRUSH, 0.4375f));
        BRUSH_WOOL = REGISTRY.registerPart(new BroomPartBase(new ResourceLocation("evilcraft", "brush_wool"), IBroomPart.BroomPartType.BRUSH, 0.4375f));
        BRUSH_FEATHER = REGISTRY.registerPart(new BroomPartBase(new ResourceLocation("evilcraft", "brush_feather"), IBroomPart.BroomPartType.BRUSH, 0.4375f));
        BRUSH_TWIG = REGISTRY.registerPart(new BroomPartBase(new ResourceLocation("evilcraft", "brush_twig"), IBroomPart.BroomPartType.BRUSH, 0.4375f));
        BRUSH_LEAVES = REGISTRY.registerPart(new BroomPartBase(new ResourceLocation("evilcraft", "brush_leaves"), IBroomPart.BroomPartType.BRUSH, 0.4375f));
        CAP_BARE = REGISTRY.registerPart(new BroomPartBase(new ResourceLocation("evilcraft", "cap_bare"), IBroomPart.BroomPartType.CAP, 0.0625f));
        CAP_GEM_DARK = BroomParts.registerCapGemOredict("dark", 55, 55, 55);
        CAP_GEM_DIAMOND = BroomParts.registerCapGemOredict("diamond", 105, 223, 218);
        CAP_GEM_EMERALD = BroomParts.registerCapGemOredict("emerald", 66, 216, 109);
        CAP_GEM_QUARTZ = BroomParts.registerCapGemOredict("quartz", 237, 235, 228);
        CAP_GEM_DARKPOWER = BroomParts.registerCapGemOredict("darkPower", 112, 59, 59);
        CAP_HEAD_SKELETON = BroomParts.registerCapHead("skeleton");
        CAP_HEAD_WITHERSKELETON = BroomParts.registerCapHead("witherskeleton");
        CAP_HEAD_ZOMBIE = BroomParts.registerCapHead("zombie");
        CAP_HEAD_PLAYER = BroomParts.registerCapHead("player");
        CAP_HEAD_CREEPER = BroomParts.registerCapHead("creeper");
        CAP_HEAD_WITHER = BroomParts.registerCapHead("wither");
        CAP_METAL_IRON = BroomParts.registerCapMetalOredict("iron", 216, 216, 216);
        CAP_METAL_GOLD = BroomParts.registerCapMetalOredict("gold", 255, 255, 139);
        CAP_METAL_THAUMIUM = BroomParts.registerCapMetalOredict("thaumium", 98, 81, 151);
        CAP_METAL_COPPER = BroomParts.registerCapMetalOredict("copper", 167, 108, 68);
        CAP_METAL_SILVER = BroomParts.registerCapMetalOredict("silver", 123, 135, 120);
        CAP_METAL_BRASS = BroomParts.registerCapMetalOredict("alubrass", 230, 195, 75);
        CAP_METAL_ARDITE = BroomParts.registerCapMetalOredict("ardite", 214, 71, 0);
        CAP_METAL_COBALT = BroomParts.registerCapMetalOredict("cobalt", 31, 126, 239);
        CAP_METAL_MANYULLYN = BroomParts.registerCapMetalOredict("manyullyn", 117, 58, 159);
        CAP_SLIME = REGISTRY.registerPart(new BroomPartBase(new ResourceLocation("evilcraft", "cap_slime"), IBroomPart.BroomPartType.CAP, 0.0625f));
        for (IBroomPart part : REGISTRY.getParts()) {
            if (!part.shouldAutoRegisterMissingItem() || !REGISTRY.getItemsFromPart(part).isEmpty()) continue;
            ItemStack itemStack = new ItemStack((Item)BroomPart.getInstance());
            REGISTRY.setBroomParts(itemStack, Collections.singleton(part));
            REGISTRY.registerPartItem(part, itemStack);
        }
    }

    public static void loadPost() {
        REGISTRY.registerBaseModifiers(ROD_WOOD, (Map<BroomModifier, Float>)ImmutableMap.of((Object)BroomModifiers.MODIFIER_COUNT, (Object)Float.valueOf(4.0f), (Object)BroomModifiers.SPEED, (Object)Float.valueOf(100.0f), (Object)BroomModifiers.MANEUVERABILITY, (Object)Float.valueOf(150.0f), (Object)BroomModifiers.ACCELERATION, (Object)Float.valueOf(50.0f), (Object)BroomModifiers.LEVITATION, (Object)Float.valueOf(20.0f)));
        REGISTRY.registerBaseModifiers(ROD_STONE, (Map<BroomModifier, Float>)ImmutableMap.of((Object)BroomModifiers.MODIFIER_COUNT, (Object)Float.valueOf(6.0f), (Object)BroomModifiers.SPEED, (Object)Float.valueOf(50.0f), (Object)BroomModifiers.MANEUVERABILITY, (Object)Float.valueOf(30.0f), (Object)BroomModifiers.ACCELERATION, (Object)Float.valueOf(10.0f), (Object)BroomModifiers.STURDYNESS, (Object)Float.valueOf(20.0f)));
        REGISTRY.registerBaseModifiers(ROD_BONE, (Map<BroomModifier, Float>)ImmutableMap.of((Object)BroomModifiers.MODIFIER_COUNT, (Object)Float.valueOf(4.0f), (Object)BroomModifiers.SPEED, (Object)Float.valueOf(150.0f), (Object)BroomModifiers.MANEUVERABILITY, (Object)Float.valueOf(150.0f), (Object)BroomModifiers.ACCELERATION, (Object)Float.valueOf(100.0f)));
        REGISTRY.registerBaseModifiers(ROD_BLAZE, (Map<BroomModifier, Float>)new ImmutableMap.Builder().put((Object)BroomModifiers.MODIFIER_COUNT, (Object)Float.valueOf(3.0f)).put((Object)BroomModifiers.SPEED, (Object)Float.valueOf(250.0f)).put((Object)BroomModifiers.MANEUVERABILITY, (Object)Float.valueOf(100.0f)).put((Object)BroomModifiers.ACCELERATION, (Object)Float.valueOf(100.0f)).put((Object)BroomModifiers.LEVITATION, (Object)Float.valueOf(50.0f)).put((Object)BroomModifiers.FLAME, (Object)Float.valueOf(2.0f)).build());
        REGISTRY.registerBaseModifiers(ROD_REED, (Map<BroomModifier, Float>)ImmutableMap.of((Object)BroomModifiers.MODIFIER_COUNT, (Object)Float.valueOf(5.0f), (Object)BroomModifiers.SPEED, (Object)Float.valueOf(50.0f), (Object)BroomModifiers.MANEUVERABILITY, (Object)Float.valueOf(200.0f), (Object)BroomModifiers.ACCELERATION, (Object)Float.valueOf(200.0f), (Object)BroomModifiers.LEVITATION, (Object)Float.valueOf(30.0f)));
        REGISTRY.registerBaseModifiers(ROD_NETHERRACK, (Map<BroomModifier, Float>)ImmutableMap.of((Object)BroomModifiers.MODIFIER_COUNT, (Object)Float.valueOf(8.0f), (Object)BroomModifiers.SPEED, (Object)Float.valueOf(100.0f), (Object)BroomModifiers.MANEUVERABILITY, (Object)Float.valueOf(50.0f), (Object)BroomModifiers.ACCELERATION, (Object)Float.valueOf(100.0f)));
        REGISTRY.registerBaseModifiers(ROD_OBSIDIAN, (Map<BroomModifier, Float>)ImmutableMap.of((Object)BroomModifiers.MODIFIER_COUNT, (Object)Float.valueOf(8.0f), (Object)BroomModifiers.SPEED, (Object)Float.valueOf(70.0f), (Object)BroomModifiers.MANEUVERABILITY, (Object)Float.valueOf(50.0f), (Object)BroomModifiers.ACCELERATION, (Object)Float.valueOf(10.0f), (Object)BroomModifiers.STURDYNESS, (Object)Float.valueOf(100.0f)));
        REGISTRY.registerBaseModifiers(ROD_UNDEAD, (Map<BroomModifier, Float>)new ImmutableMap.Builder().put((Object)BroomModifiers.MODIFIER_COUNT, (Object)Float.valueOf(4.0f)).put((Object)BroomModifiers.SPEED, (Object)Float.valueOf(120.0f)).put((Object)BroomModifiers.MANEUVERABILITY, (Object)Float.valueOf(150.0f)).put((Object)BroomModifiers.ACCELERATION, (Object)Float.valueOf(50.0f)).put((Object)BroomModifiers.LEVITATION, (Object)Float.valueOf(20.0f)).put((Object)BroomModifiers.EFFICIENCY, (Object)Float.valueOf(10.0f)).build());
        REGISTRY.registerBaseModifiers(ROD_PRISMARINE, (Map<BroomModifier, Float>)ImmutableMap.of((Object)BroomModifiers.MODIFIER_COUNT, (Object)Float.valueOf(4.0f), (Object)BroomModifiers.SPEED, (Object)Float.valueOf(70.0f), (Object)BroomModifiers.ACCELERATION, (Object)Float.valueOf(10.0f), (Object)BroomModifiers.STURDYNESS, (Object)Float.valueOf(50.0f), (Object)BroomModifiers.SWIMMING, (Object)Float.valueOf(100.0f)));
        REGISTRY.registerBaseModifiers(ROD_ICE, (Map<BroomModifier, Float>)ImmutableMap.of((Object)BroomModifiers.MODIFIER_COUNT, (Object)Float.valueOf(4.0f), (Object)BroomModifiers.SPEED, (Object)Float.valueOf(70.0f), (Object)BroomModifiers.ACCELERATION, (Object)Float.valueOf(50.0f), (Object)BroomModifiers.STURDYNESS, (Object)Float.valueOf(50.0f), (Object)BroomModifiers.ICY, (Object)Float.valueOf(10.0f)));
        REGISTRY.registerBaseModifiers(ROD_SPONGE, (Map<BroomModifier, Float>)new ImmutableMap.Builder().put((Object)BroomModifiers.MODIFIER_COUNT, (Object)Float.valueOf(4.0f)).put((Object)BroomModifiers.SPEED, (Object)Float.valueOf(50.0f)).put((Object)BroomModifiers.ACCELERATION, (Object)Float.valueOf(10.0f)).put((Object)BroomModifiers.STURDYNESS, (Object)Float.valueOf(80.0f)).put((Object)BroomModifiers.SWIMMING, (Object)Float.valueOf(120.0f)).put((Object)BroomModifiers.BOUNCY, (Object)Float.valueOf(2.0f)).build());
        REGISTRY.registerBaseModifiers(ROD_ENDSTONE, (Map<BroomModifier, Float>)ImmutableMap.of((Object)BroomModifiers.MODIFIER_COUNT, (Object)Float.valueOf(6.0f), (Object)BroomModifiers.SPEED, (Object)Float.valueOf(80.0f), (Object)BroomModifiers.MANEUVERABILITY, (Object)Float.valueOf(50.0f), (Object)BroomModifiers.ACCELERATION, (Object)Float.valueOf(50.0f), (Object)BroomModifiers.STURDYNESS, (Object)Float.valueOf(50.0f)));
        REGISTRY.registerBaseModifiers(ROD_PURPUR, (Map<BroomModifier, Float>)ImmutableMap.of((Object)BroomModifiers.MODIFIER_COUNT, (Object)Float.valueOf(5.0f), (Object)BroomModifiers.SPEED, (Object)Float.valueOf(100.0f), (Object)BroomModifiers.MANEUVERABILITY, (Object)Float.valueOf(75.0f), (Object)BroomModifiers.ACCELERATION, (Object)Float.valueOf(50.0f), (Object)BroomModifiers.LEVITATION, (Object)Float.valueOf(100.0f)));
        REGISTRY.registerBaseModifiers(BRUSH_WHEAT, BroomModifiers.SPEED, 100.0f);
        REGISTRY.registerBaseModifiers(BRUSH_WOOL, (Map<BroomModifier, Float>)ImmutableMap.of((Object)BroomModifiers.SPEED, (Object)Float.valueOf(80.0f), (Object)BroomModifiers.LEVITATION, (Object)Float.valueOf(100.0f)));
        REGISTRY.registerBaseModifiers(BRUSH_FEATHER, BroomModifiers.LEVITATION, 200.0f);
        REGISTRY.registerBaseModifiers(BRUSH_TWIG, BroomModifiers.MANEUVERABILITY, 100.0f);
        REGISTRY.registerBaseModifiers(BRUSH_LEAVES, BroomModifiers.SPEED, 20.0f);
        REGISTRY.registerBaseModifiers(CAP_GEM_DARK, (Map<BroomModifier, Float>)ImmutableMap.of((Object)BroomModifiers.MANEUVERABILITY, (Object)Float.valueOf(50.0f), (Object)BroomModifiers.MODIFIER_COUNT, (Object)Float.valueOf(1.0f)));
        REGISTRY.registerBaseModifiers(CAP_GEM_DIAMOND, (Map<BroomModifier, Float>)ImmutableMap.of((Object)BroomModifiers.MANEUVERABILITY, (Object)Float.valueOf(50.0f), (Object)BroomModifiers.MODIFIER_COUNT, (Object)Float.valueOf(2.0f), (Object)BroomModifiers.STURDYNESS, (Object)Float.valueOf(100.0f)));
        REGISTRY.registerBaseModifiers(CAP_GEM_EMERALD, (Map<BroomModifier, Float>)ImmutableMap.of((Object)BroomModifiers.MANEUVERABILITY, (Object)Float.valueOf(50.0f), (Object)BroomModifiers.MODIFIER_COUNT, (Object)Float.valueOf(2.0f), (Object)BroomModifiers.ACCELERATION, (Object)Float.valueOf(100.0f)));
        REGISTRY.registerBaseModifiers(CAP_GEM_QUARTZ, (Map<BroomModifier, Float>)ImmutableMap.of((Object)BroomModifiers.MANEUVERABILITY, (Object)Float.valueOf(50.0f), (Object)BroomModifiers.DAMAGE, (Object)Float.valueOf(50.0f)));
        REGISTRY.registerBaseModifiers(CAP_GEM_DARKPOWER, (Map<BroomModifier, Float>)ImmutableMap.of((Object)BroomModifiers.MANEUVERABILITY, (Object)Float.valueOf(50.0f), (Object)BroomModifiers.MODIFIER_COUNT, (Object)Float.valueOf(1.0f), (Object)BroomModifiers.EFFICIENCY, (Object)Float.valueOf(10.0f)));
        REGISTRY.registerBaseModifiers(CAP_HEAD_SKELETON, BroomModifiers.MANEUVERABILITY, 150.0f);
        REGISTRY.registerBaseModifiers(CAP_HEAD_WITHERSKELETON, BroomModifiers.WITHERER, 5.0f);
        REGISTRY.registerBaseModifiers(CAP_HEAD_ZOMBIE, (Map<BroomModifier, Float>)ImmutableMap.of((Object)BroomModifiers.HUNGERER, (Object)Float.valueOf(10.0f), (Object)BroomModifiers.DAMAGE, (Object)Float.valueOf(2.0f)));
        REGISTRY.registerBaseModifiers(CAP_HEAD_PLAYER, BroomModifiers.SPEED, 50.0f);
        REGISTRY.registerBaseModifiers(CAP_HEAD_CREEPER, BroomModifiers.KAMIKAZE, 10.0f);
        REGISTRY.registerBaseModifiers(CAP_HEAD_WITHER, BroomModifiers.WITHERSHIELD, 20.0f);
        REGISTRY.registerBaseModifiers(CAP_METAL_IRON, (Map<BroomModifier, Float>)ImmutableMap.of((Object)BroomModifiers.SPEED, (Object)Float.valueOf(100.0f), (Object)BroomModifiers.STURDYNESS, (Object)Float.valueOf(40.0f), (Object)BroomModifiers.MANEUVERABILITY, (Object)Float.valueOf(10.0f)));
        REGISTRY.registerBaseModifiers(CAP_METAL_GOLD, (Map<BroomModifier, Float>)ImmutableMap.of((Object)BroomModifiers.SPEED, (Object)Float.valueOf(80.0f), (Object)BroomModifiers.STURDYNESS, (Object)Float.valueOf(70.0f), (Object)BroomModifiers.MANEUVERABILITY, (Object)Float.valueOf(30.0f)));
        REGISTRY.registerBaseModifiers(CAP_METAL_THAUMIUM, (Map<BroomModifier, Float>)ImmutableMap.of((Object)BroomModifiers.SPEED, (Object)Float.valueOf(100.0f), (Object)BroomModifiers.STURDYNESS, (Object)Float.valueOf(70.0f), (Object)BroomModifiers.MANEUVERABILITY, (Object)Float.valueOf(30.0f)));
        REGISTRY.registerBaseModifiers(CAP_METAL_COPPER, (Map<BroomModifier, Float>)ImmutableMap.of((Object)BroomModifiers.SPEED, (Object)Float.valueOf(120.0f), (Object)BroomModifiers.STURDYNESS, (Object)Float.valueOf(50.0f), (Object)BroomModifiers.MANEUVERABILITY, (Object)Float.valueOf(10.0f)));
        REGISTRY.registerBaseModifiers(CAP_METAL_SILVER, (Map<BroomModifier, Float>)ImmutableMap.of((Object)BroomModifiers.SPEED, (Object)Float.valueOf(130.0f), (Object)BroomModifiers.STURDYNESS, (Object)Float.valueOf(50.0f), (Object)BroomModifiers.MANEUVERABILITY, (Object)Float.valueOf(10.0f)));
        REGISTRY.registerBaseModifiers(CAP_METAL_BRASS, (Map<BroomModifier, Float>)ImmutableMap.of((Object)BroomModifiers.SPEED, (Object)Float.valueOf(80.0f), (Object)BroomModifiers.STURDYNESS, (Object)Float.valueOf(60.0f), (Object)BroomModifiers.MANEUVERABILITY, (Object)Float.valueOf(30.0f)));
        REGISTRY.registerBaseModifiers(CAP_METAL_ARDITE, (Map<BroomModifier, Float>)ImmutableMap.of((Object)BroomModifiers.SPEED, (Object)Float.valueOf(150.0f), (Object)BroomModifiers.STURDYNESS, (Object)Float.valueOf(50.0f), (Object)BroomModifiers.MANEUVERABILITY, (Object)Float.valueOf(20.0f)));
        REGISTRY.registerBaseModifiers(CAP_METAL_COBALT, (Map<BroomModifier, Float>)ImmutableMap.of((Object)BroomModifiers.SPEED, (Object)Float.valueOf(130.0f), (Object)BroomModifiers.STURDYNESS, (Object)Float.valueOf(60.0f), (Object)BroomModifiers.MANEUVERABILITY, (Object)Float.valueOf(20.0f)));
        REGISTRY.registerBaseModifiers(CAP_METAL_MANYULLYN, (Map<BroomModifier, Float>)ImmutableMap.of((Object)BroomModifiers.SPEED, (Object)Float.valueOf(150.0f), (Object)BroomModifiers.STURDYNESS, (Object)Float.valueOf(60.0f), (Object)BroomModifiers.MANEUVERABILITY, (Object)Float.valueOf(20.0f)));
        REGISTRY.registerBaseModifiers(CAP_SLIME, (Map<BroomModifier, Float>)ImmutableMap.of((Object)BroomModifiers.SPEED, (Object)Float.valueOf(50.0f), (Object)BroomModifiers.ACCELERATION, (Object)Float.valueOf(150.0f), (Object)BroomModifiers.STURDYNESS, (Object)Float.valueOf(30.0f), (Object)BroomModifiers.BOUNCY, (Object)Float.valueOf(15.0f)));
        int combinations = REGISTRY.getParts(IBroomPart.BroomPartType.ROD).size() * REGISTRY.getParts(IBroomPart.BroomPartType.CAP).size() * REGISTRY.getParts(IBroomPart.BroomPartType.BRUSH).size();
        EvilCraft.clog(String.format("%s possible Broom base combinations are ready for flying!", combinations));
    }

    public static IBroomPart registerCapGemOredict(String name, int r, int g, int b) {
        if (OreDictionary.doesOreNameExist((String)("gem" + StringUtils.capitalize((String)name)))) {
            return REGISTRY.registerPart(new BroomPartCapGem(new ResourceLocation("evilcraft", "cap_gem_" + name), Helpers.RGBToInt((int)r, (int)g, (int)b)));
        }
        return null;
    }

    public static IBroomPart registerCapHead(String name) {
        return REGISTRY.registerPart(new BroomPartBase(new ResourceLocation("evilcraft", "cap_head_" + name), IBroomPart.BroomPartType.CAP, 0.5f));
    }

    public static IBroomPart registerCapMetalOredict(String name, int r, int g, int b) {
        if (OreDictionary.doesOreNameExist((String)("ingot" + StringUtils.capitalize((String)name)))) {
            return REGISTRY.registerPart(new BroomPartCapMetal(new ResourceLocation("evilcraft", "cap_metal_" + name), Helpers.RGBToInt((int)r, (int)g, (int)b)));
        }
        return null;
    }
}

