/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.api.broom;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.EnumRarity;
import net.minecraft.util.ResourceLocation;

public interface IBroomPart {
    public BroomPartType getType();

    public ResourceLocation getId();

    public String getUnlocalizedName();

    @Nullable
    public String getTooltipLine(String var1);

    public float getLength();

    public EnumRarity getRarity();

    public boolean isEffect();

    public int getModelColor();

    public boolean shouldAutoRegisterMissingItem();

    public static interface IBroomPartTypeModelOffsetter {
        public float getOffset(float var1, float var2, int var3);
    }

    public static class BroomPartType {
        private static final List<BroomPartType> ALL_TYPES = Lists.newArrayList();
        public static final BroomPartType ROD = new BroomPartType("rod", new IBroomPartTypeModelOffsetter(){

            @Override
            public float getOffset(float rodLength, float selfLength, int typeIndex) {
                return 0.0f;
            }
        });
        public static final BroomPartType BRUSH = new BroomPartType("brush", new IBroomPartTypeModelOffsetter(){

            @Override
            public float getOffset(float rodLength, float selfLength, int typeIndex) {
                return -selfLength;
            }
        });
        public static final BroomPartType CAP = new BroomPartType("cap", new IBroomPartTypeModelOffsetter(){

            @Override
            public float getOffset(float rodLength, float selfLength, int typeIndex) {
                return rodLength;
            }
        });
        public static final BroomPartType MODIFIER = new BroomPartType("modifier", new IBroomPartTypeModelOffsetter(){

            @Override
            public float getOffset(float rodLength, float selfLength, int typeIndex) {
                return rodLength - selfLength * (float)(1 + typeIndex);
            }
        });
        private final String name;
        private final IBroomPartTypeModelOffsetter offsetter;
        public static final BroomPartType[] BASE_TYPES = new BroomPartType[]{ROD, BRUSH, CAP};

        public static List<BroomPartType> getAllTypes() {
            return Collections.unmodifiableList(ALL_TYPES);
        }

        public BroomPartType(String name, IBroomPartTypeModelOffsetter offsetter) {
            this.name = name;
            this.offsetter = offsetter;
            ALL_TYPES.add(this);
        }

        public String getName() {
            return this.name;
        }

        public String getUnlocalizedName() {
            return "broom.parts.evilcraft.type." + this.getName() + ".name";
        }

        public IBroomPartTypeModelOffsetter getOffsetter() {
            return this.offsetter;
        }

        public String toString() {
            return this.getName();
        }
    }
}

