/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.item;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.item.ItemBase;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;

public class ItemUpgrade
extends ItemBase {
    public static final int TYPE_RANGE = 1;
    public static final int TYPE_SPEED = 2;
    public static final int TYPE_CRAFTING = 3;
    public static final int TYPE_STACK = 4;
    public static final int TYPE_INTERDIMENSIONAL = 5;
    public static final int TYPE_SILK_TOUCH = 6;
    public static final int TYPE_FORTUNE_1 = 7;
    public static final int TYPE_FORTUNE_2 = 8;
    public static final int TYPE_FORTUNE_3 = 9;

    public ItemUpgrade() {
        super("upgrade");
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    public boolean func_77636_d(ItemStack stack) {
        return stack.func_77960_j() == 6 || ItemUpgrade.getFortuneLevel(stack) > 0;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        if (ItemUpgrade.getFortuneLevel(stack) > 0) {
            tooltip.add(I18n.func_135052_a((String)"enchantment.lootBonusDigger", (Object[])new Object[0]) + " " + I18n.func_135052_a((String)("enchantment.level." + ItemUpgrade.getFortuneLevel(stack)), (Object[])new Object[0]));
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (int i = 0; i <= 9; ++i) {
            items.add((Object)new ItemStack((Item)this, 1, i));
        }
    }

    public static int getFortuneLevel(@Nullable ItemStack stack) {
        if (stack != null) {
            if (stack.func_77960_j() == 7) {
                return 1;
            }
            if (stack.func_77960_j() == 8) {
                return 2;
            }
            if (stack.func_77960_j() == 9) {
                return 3;
            }
        }
        return 0;
    }

    public static int getEnergyUsage(ItemStack stack) {
        switch (stack.func_77952_i()) {
            case 1: {
                return RS.INSTANCE.config.rangeUpgradeUsage;
            }
            case 2: {
                return RS.INSTANCE.config.speedUpgradeUsage;
            }
            case 3: {
                return RS.INSTANCE.config.craftingUpgradeUsage;
            }
            case 4: {
                return RS.INSTANCE.config.stackUpgradeUsage;
            }
            case 5: {
                return RS.INSTANCE.config.interdimensionalUpgradeUsage;
            }
            case 6: {
                return RS.INSTANCE.config.silkTouchUpgradeUsage;
            }
            case 7: 
            case 8: 
            case 9: {
                return RS.INSTANCE.config.fortuneUpgradeUsagePerFortune * ItemUpgrade.getFortuneLevel(stack);
            }
        }
        return 0;
    }
}

