/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.item;

import com.raoulvdberge.refinedstorage.api.network.security.Permission;
import com.raoulvdberge.refinedstorage.item.ItemBase;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class ItemSecurityCard
extends ItemBase {
    private static final String NBT_OWNER = "Owner";
    private static final String NBT_OWNER_NAME = "OwnerName";
    private static final String NBT_PERMISSION = "Permission_%d";

    public ItemSecurityCard() {
        super("security_card");
        this.func_77625_d(1);
        this.func_185043_a(new ResourceLocation("active"), (stack, world, entity) -> entity != null && ItemSecurityCard.isValid(stack) ? 1.0f : 0.0f);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74778_a(NBT_OWNER, player.func_146103_bH().getId().toString());
            stack.func_77978_p().func_74778_a(NBT_OWNER_NAME, player.func_146103_bH().getName());
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    @Nullable
    public static UUID getOwner(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_OWNER)) {
            return UUID.fromString(stack.func_77978_p().func_74779_i(NBT_OWNER));
        }
        return null;
    }

    public static boolean hasPermission(ItemStack stack, Permission permission) {
        String id = String.format(NBT_PERMISSION, permission.getId());
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(id)) {
            return stack.func_77978_p().func_74767_n(id);
        }
        return true;
    }

    public static void setPermission(ItemStack stack, Permission permission, boolean state) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74757_a(String.format(NBT_PERMISSION, permission.getId()), state);
    }

    public static boolean isValid(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_OWNER);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_OWNER_NAME)) {
            tooltip.add(I18n.func_135052_a((String)"item.refinedstorage:security_card.owner", (Object[])new Object[]{stack.func_77978_p().func_74779_i(NBT_OWNER_NAME)}));
        }
    }
}

