/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.inventory;

import com.raoulvdberge.refinedstorage.api.storage.IStorage;
import com.raoulvdberge.refinedstorage.api.storage.IStorageCache;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class ItemHandlerStorage
implements IItemHandler {
    private IStorage<ItemStack> storage;
    private IStorageCache<ItemStack> storageCache;
    private ItemStack[] storageCacheData;

    public ItemHandlerStorage(IStorage<ItemStack> storage, IStorageCache<ItemStack> storageCache) {
        this.storage = storage;
        this.storageCache = storageCache;
        this.invalidate();
    }

    public int getSlots() {
        return this.storageCacheData.length + 1;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return slot >= this.storageCacheData.length ? ItemStack.field_190927_a : this.storageCacheData[slot];
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        return StackUtils.nullToEmpty(this.storage.insert(stack, stack.func_190916_E(), simulate));
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return slot >= this.storageCacheData.length ? ItemStack.field_190927_a : StackUtils.nullToEmpty(this.storage.extract(this.storageCacheData[slot], amount, 3, simulate));
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public void invalidate() {
        this.storageCacheData = this.storageCache.getList().getStacks().toArray(new ItemStack[0]);
    }
}

