/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.gui.grid.view;

import com.raoulvdberge.refinedstorage.api.network.grid.IGrid;
import com.raoulvdberge.refinedstorage.gui.grid.GuiGrid;
import com.raoulvdberge.refinedstorage.gui.grid.filtering.GridFilterParser;
import com.raoulvdberge.refinedstorage.gui.grid.sorting.GridSorterDirection;
import com.raoulvdberge.refinedstorage.gui.grid.sorting.IGridSorter;
import com.raoulvdberge.refinedstorage.gui.grid.stack.IGridStack;
import com.raoulvdberge.refinedstorage.gui.grid.view.IGridView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public abstract class GridViewBase
implements IGridView {
    private GuiGrid gui;
    private boolean canCraft;
    private IGridSorter defaultSorter;
    private List<IGridSorter> sorters;
    private List<IGridStack> stacks = new ArrayList<IGridStack>();
    protected Map<Integer, IGridStack> map = new HashMap<Integer, IGridStack>();

    public GridViewBase(GuiGrid gui, IGridSorter defaultSorter, List<IGridSorter> sorters) {
        this.gui = gui;
        this.defaultSorter = defaultSorter;
        this.sorters = sorters;
    }

    @Override
    public List<IGridStack> getStacks() {
        return this.stacks;
    }

    @Override
    public void sort() {
        ArrayList<IGridStack> stacks = new ArrayList<IGridStack>();
        if (this.gui.getGrid().isActive()) {
            stacks.addAll(this.map.values());
            IGrid grid = this.gui.getGrid();
            List<Predicate<IGridStack>> filters = GridFilterParser.getFilters(grid, this.gui.getSearchField() != null ? this.gui.getSearchField().func_146179_b() : "", grid.getTabSelected() >= 0 && grid.getTabSelected() < grid.getTabs().size() ? grid.getTabs().get(grid.getTabSelected()).getFilters() : grid.getFilters());
            Iterator it = stacks.iterator();
            block0: while (it.hasNext()) {
                IGridStack stack = (IGridStack)it.next();
                for (Predicate<IGridStack> filter : filters) {
                    if (filter.test(stack)) continue;
                    it.remove();
                    continue block0;
                }
            }
            GridSorterDirection sortingDirection = grid.getSortingDirection() == 1 ? GridSorterDirection.DESCENDING : GridSorterDirection.ASCENDING;
            stacks.sort((left, right) -> this.defaultSorter.compare((IGridStack)left, (IGridStack)right, sortingDirection));
            for (IGridSorter sorter : this.sorters) {
                if (!sorter.isApplicable(grid)) continue;
                stacks.sort((left, right) -> sorter.compare((IGridStack)left, (IGridStack)right, sortingDirection));
            }
        }
        this.stacks = stacks;
        this.gui.updateScrollbarAndTabs();
    }

    @Override
    public void setCanCraft(boolean canCraft) {
        this.canCraft = canCraft;
    }

    @Override
    public boolean canCraft() {
        return this.canCraft;
    }
}

