/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.gui.grid.stack;

import com.raoulvdberge.refinedstorage.api.storage.IStorageTracker;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.gui.grid.stack.IGridStack;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class GridStackFluid
implements IGridStack {
    private int hash;
    private FluidStack stack;
    @Nullable
    private IStorageTracker.IStorageTrackerEntry entry;

    public GridStackFluid(Pair<Integer, FluidStack> data, @Nullable IStorageTracker.IStorageTrackerEntry entry) {
        this.hash = (Integer)data.getLeft();
        this.stack = (FluidStack)data.getRight();
        this.entry = entry;
    }

    public FluidStack getStack() {
        return this.stack;
    }

    @Override
    public int getHash() {
        return this.hash;
    }

    @Override
    public String getName() {
        return this.stack.getFluid().getLocalizedName(this.stack);
    }

    @Override
    public String getModId() {
        return this.stack.getFluid().getStill(this.stack).func_110624_b();
    }

    @Override
    public String[] getOreIds() {
        return new String[]{this.stack.getFluid().getName()};
    }

    @Override
    public String getTooltip() {
        return this.stack.getFluid().getLocalizedName(this.stack);
    }

    @Override
    public int getQuantity() {
        return this.stack.amount;
    }

    @Override
    public String getFormattedFullQuantity() {
        return API.instance().getQuantityFormatter().format(this.getQuantity()) + " mB";
    }

    @Override
    public void draw(GuiBase gui, int x, int y) {
        GuiBase.FLUID_RENDERER.draw(gui.field_146297_k, x, y, this.stack);
        float amountRaw = (float)this.stack.amount / 1000.0f;
        int amount = (int)amountRaw;
        String formattedAmount = amount >= 1 ? API.instance().getQuantityFormatter().formatWithUnits(amount) : String.format("%.1f", Float.valueOf(amountRaw));
        gui.drawQuantity(x, y, formattedAmount);
    }

    @Override
    public Object getIngredient() {
        return this.stack;
    }

    @Override
    @Nullable
    public IStorageTracker.IStorageTrackerEntry getTrackerEntry() {
        return this.entry;
    }

    @Override
    public void setTrackerEntry(@Nullable IStorageTracker.IStorageTrackerEntry entry) {
        this.entry = entry;
    }
}

