/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.gui.control;

import com.raoulvdberge.refinedstorage.api.network.grid.GridType;
import com.raoulvdberge.refinedstorage.api.network.grid.IGrid;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.gui.control.SideButton;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.Loader;

public class SideButtonGridSortingType
extends SideButton {
    private IGrid grid;

    public SideButtonGridSortingType(GuiBase gui, IGrid grid) {
        super(gui);
        this.grid = grid;
    }

    @Override
    public String getTooltip() {
        return GuiBase.t("sidebutton.refinedstorage:grid.sorting.type", new Object[0]) + "\n" + TextFormatting.GRAY + GuiBase.t("sidebutton.refinedstorage:grid.sorting.type." + this.grid.getSortingType(), new Object[0]);
    }

    @Override
    protected void drawButtonIcon(int x, int y) {
        if (this.grid.getSortingType() == 4) {
            this.gui.drawTexture(x, y, 48, 48, 16, 16);
        } else {
            this.gui.drawTexture(x, y, this.grid.getSortingType() * 16, 32, 16, 16);
        }
    }

    @Override
    public void actionPerformed() {
        int type = this.grid.getSortingType();
        if (type == 0) {
            type = 1;
        } else if (type == 1) {
            type = this.grid.getType() == GridType.FLUID ? 4 : 2;
        } else if (type == 2) {
            type = 4;
        } else if (type == 4) {
            type = this.grid.getType() == GridType.FLUID || !Loader.isModLoaded((String)"inventorytweaks") ? 0 : 3;
        } else if (type == 3) {
            type = 0;
        }
        this.grid.onSortingTypeChanged(type);
    }
}

