/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.gui;

import com.raoulvdberge.refinedstorage.container.ContainerFluidInterface;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.gui.control.SideButtonCompare;
import com.raoulvdberge.refinedstorage.gui.control.SideButtonRedstoneMode;
import com.raoulvdberge.refinedstorage.tile.TileFluidInterface;
import com.raoulvdberge.refinedstorage.util.RenderUtils;

public class GuiFluidInterface
extends GuiBase {
    private static final RenderUtils.FluidRenderer TANK_RENDERER = new RenderUtils.FluidRenderer(16000, 12, 47);

    public GuiFluidInterface(ContainerFluidInterface container) {
        super(container, 211, 204);
    }

    @Override
    public void init(int x, int y) {
        this.addSideButton(new SideButtonRedstoneMode(this, TileFluidInterface.REDSTONE_MODE));
        this.addSideButton(new SideButtonCompare(this, TileFluidInterface.COMPARE, 2));
    }

    @Override
    public void update(int x, int y) {
    }

    @Override
    public void drawBackground(int x, int y, int mouseX, int mouseY) {
        this.bindTexture("gui/fluid_interface.png");
        this.drawTexture(x, y, 0, 0, this.screenWidth, this.screenHeight);
        if (TileFluidInterface.TANK_IN.getValue() != null) {
            TANK_RENDERER.draw(this.field_146297_k, x + 46, y + 56, TileFluidInterface.TANK_IN.getValue());
        }
        if (TileFluidInterface.TANK_OUT.getValue() != null) {
            TANK_RENDERER.draw(this.field_146297_k, x + 118, y + 56, TileFluidInterface.TANK_OUT.getValue());
        }
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        this.drawString(7, 7, GuiFluidInterface.t("gui.refinedstorage:fluid_interface", new Object[0]));
        this.drawString(47, 20, GuiFluidInterface.t("gui.refinedstorage:fluid_interface.in", new Object[0]));
        this.drawString(116, 20, GuiFluidInterface.t("gui.refinedstorage:fluid_interface.out", new Object[0]));
        this.drawString(7, 111, GuiFluidInterface.t("container.inventory", new Object[0]));
        if (this.inBounds(46, 56, 12, 47, mouseX, mouseY) && TileFluidInterface.TANK_IN.getValue() != null) {
            this.drawTooltip(mouseX, mouseY, TileFluidInterface.TANK_IN.getValue().getLocalizedName() + "\n" + TileFluidInterface.TANK_IN.getValue().amount + " mB");
        }
        if (this.inBounds(118, 56, 12, 47, mouseX, mouseY) && TileFluidInterface.TANK_OUT.getValue() != null) {
            this.drawTooltip(mouseX, mouseY, TileFluidInterface.TANK_OUT.getValue().getLocalizedName() + "\n" + TileFluidInterface.TANK_OUT.getValue().amount + " mB");
        }
    }
}

