/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.gui;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.render.IElementDrawer;
import com.raoulvdberge.refinedstorage.api.render.IElementDrawers;
import com.raoulvdberge.refinedstorage.gui.control.Scrollbar;
import com.raoulvdberge.refinedstorage.gui.control.SideButton;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerFluid;
import com.raoulvdberge.refinedstorage.util.RenderUtils;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.config.GuiCheckBox;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.items.SlotItemHandler;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public abstract class GuiBase
extends GuiContainer {
    private static final Map<String, ResourceLocation> TEXTURE_CACHE = new HashMap<String, ResourceLocation>();
    private static final Map<Class, Queue<Consumer>> RUNNABLES = new HashMap<Class, Queue<Consumer>>();
    public static final RenderUtils.FluidRenderer FLUID_RENDERER = new RenderUtils.FluidRenderer(-1, 16, 16);
    private int lastButtonId;
    private int lastSideButtonY;
    private String hoveringFluid = null;
    protected int screenWidth;
    protected int screenHeight;
    protected Scrollbar scrollbar;
    private boolean initializing;

    public GuiBase(Container container, int screenWidth, int screenHeight) {
        super(container);
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        this.field_146999_f = screenWidth;
        this.field_147000_g = screenHeight;
    }

    private void runRunnables() {
        Queue<Consumer> queue = RUNNABLES.get(((Object)((Object)this)).getClass());
        if (queue != null && !queue.isEmpty()) {
            Consumer callback;
            while ((callback = queue.poll()) != null) {
                callback.accept(this);
            }
        }
    }

    public Scrollbar getScrollbar() {
        return this.scrollbar;
    }

    public void func_73866_w_() {
        if (this.initializing) {
            return;
        }
        this.initializing = true;
        Keyboard.enableRepeatEvents((boolean)true);
        this.calcHeight();
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.lastButtonId = 0;
        this.lastSideButtonY = this.getSideButtonYStart();
        this.init(this.field_147003_i, this.field_147009_r);
        this.runRunnables();
        this.initializing = false;
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void calcHeight() {
    }

    protected int getSideButtonYStart() {
        return 6;
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.runRunnables();
        this.update(this.field_147003_i, this.field_147009_r);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        try {
            super.func_73863_a(mouseX, mouseY, partialTicks);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.func_191948_b(mouseX, mouseY);
        if (this.scrollbar != null) {
            this.scrollbar.update(this, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
    }

    protected void func_146976_a(float renderPartialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawBackground(this.field_147003_i, this.field_147009_r, mouseX, mouseY);
        this.hoveringFluid = null;
        for (int i = 0; i < this.field_147002_h.field_75151_b.size(); ++i) {
            FluidStack stack;
            Slot slot = (Slot)this.field_147002_h.field_75151_b.get(i);
            if (!(slot instanceof SlotItemHandler) || !(((SlotItemHandler)slot).getItemHandler() instanceof ItemHandlerFluid) || (stack = ((ItemHandlerFluid)((SlotItemHandler)slot).getItemHandler()).getFluidStackInSlot(slot.getSlotIndex())) == null) continue;
            FLUID_RENDERER.draw(this.field_146297_k, this.field_147003_i + slot.field_75223_e, this.field_147009_r + slot.field_75221_f, stack);
            if (!this.inBounds(this.field_147003_i + slot.field_75223_e, this.field_147009_r + slot.field_75221_f, 18, 18, mouseX, mouseY)) continue;
            this.hoveringFluid = stack.getLocalizedName();
        }
        if (this.scrollbar != null) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.scrollbar.draw(this);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mouseX -= this.field_147003_i;
        mouseY -= this.field_147009_r;
        String sideButtonTooltip = null;
        for (int i = 0; i < this.field_146292_n.size(); ++i) {
            GuiButton button = (GuiButton)this.field_146292_n.get(i);
            if (!(button instanceof SideButton) || !((SideButton)button).isHovered()) continue;
            sideButtonTooltip = ((SideButton)button).getTooltip();
        }
        this.drawForeground(mouseX, mouseY);
        if (sideButtonTooltip != null || this.hoveringFluid != null) {
            this.drawTooltip(mouseX, mouseY, sideButtonTooltip != null ? sideButtonTooltip : this.hoveringFluid);
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int d = Mouse.getEventDWheel();
        if (this.scrollbar != null && d != 0) {
            this.scrollbar.wheel(d);
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button instanceof SideButton) {
            ((SideButton)button).actionPerformed();
        }
    }

    public GuiCheckBox addCheckBox(int x, int y, String text, boolean checked) {
        GuiCheckBox checkBox = new GuiCheckBox(this.lastButtonId++, x, y, text, checked);
        this.field_146292_n.add(checkBox);
        return checkBox;
    }

    public GuiButton addButton(int x, int y, int w, int h, String text) {
        return this.addButton(x, y, w, h, text, true, true);
    }

    public GuiButton addButton(int x, int y, int w, int h, String text, boolean enabled, boolean visible) {
        GuiButton button = new GuiButton(this.lastButtonId++, x, y, w, h, text);
        button.field_146124_l = enabled;
        button.field_146125_m = visible;
        this.field_146292_n.add(button);
        return button;
    }

    public SideButton addSideButton(SideButton button) {
        button.field_146127_k = this.lastButtonId++;
        button.field_146128_h = this.field_147003_i + -18 - 2;
        button.field_146129_i = this.field_147009_r + this.lastSideButtonY;
        this.lastSideButtonY += 20;
        this.field_146292_n.add(button);
        return button;
    }

    public boolean inBounds(int x, int y, int w, int h, int ox, int oy) {
        return ox >= x && ox <= x + w && oy >= y && oy <= y + h;
    }

    public void bindTexture(String file) {
        this.bindTexture("refinedstorage", file);
    }

    public void bindTexture(String base, String file) {
        String id = base + ":" + file;
        if (!TEXTURE_CACHE.containsKey(id)) {
            TEXTURE_CACHE.put(id, new ResourceLocation(base, "textures/" + file));
        }
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE_CACHE.get(id));
    }

    public void drawItem(int x, int y, ItemStack stack) {
        this.drawItem(x, y, stack, false);
    }

    public void drawItem(int x, int y, ItemStack stack, boolean withOverlay) {
        this.drawItem(x, y, stack, withOverlay, null);
    }

    public void drawItem(int x, int y, ItemStack stack, boolean withOverlay, @Nullable String text) {
        this.field_73735_i = 200.0f;
        this.field_146296_j.field_77023_b = 200.0f;
        try {
            this.field_146296_j.func_175042_a(stack, x, y);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (withOverlay) {
            this.drawItemOverlay(stack, text, x, y);
        }
        this.field_73735_i = 0.0f;
        this.field_146296_j.field_77023_b = 0.0f;
    }

    public void drawItemOverlay(ItemStack stack, @Nullable String text, int x, int y) {
        try {
            this.field_146296_j.func_180453_a(this.field_146289_q, stack, x, y, "");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (text != null) {
            this.drawQuantity(x, y, text);
        }
    }

    public void drawQuantity(int x, int y, String qty) {
        boolean large = this.field_146289_q.func_82883_a() || RS.INSTANCE.config.largeFont;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)1.0f);
        if (!large) {
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)1.0f);
        }
        GlStateManager.func_179140_f();
        GlStateManager.func_179101_C();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179097_i();
        this.field_146289_q.func_175063_a(qty, (float)((large ? 16 : 30) - this.field_146289_q.func_78256_a(qty)), large ? 8.0f : 22.0f, 0xFFFFFF);
        GlStateManager.func_179126_j();
        GlStateManager.func_179098_w();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    public void drawString(int x, int y, String message) {
        this.drawString(x, y, message, 0x404040);
    }

    public void drawString(int x, int y, String message, int color) {
        GlStateManager.func_179140_f();
        this.field_146289_q.func_78276_b(message, x, y, color);
        GlStateManager.func_179145_e();
    }

    public void drawTooltip(@Nonnull ItemStack stack, int x, int y, String lines) {
        this.drawTooltip(stack, x, y, Arrays.asList(lines.split("\n")));
    }

    public void drawTooltip(int x, int y, String lines) {
        this.drawTooltip(ItemStack.field_190927_a, x, y, lines);
    }

    public void drawTooltip(@Nonnull ItemStack stack, int x, int y, List<String> lines) {
        GlStateManager.func_179140_f();
        GuiUtils.drawHoveringText((ItemStack)stack, lines, (int)x, (int)y, (int)(this.field_146294_l - this.field_147003_i), (int)this.field_146295_m, (int)-1, (FontRenderer)this.field_146289_q);
        GlStateManager.func_179145_e();
    }

    public void drawTexture(int x, int y, int textureX, int textureY, int width, int height) {
        this.func_73729_b(x, y, textureX, textureY, width, height);
    }

    public static String t(String name, Object ... format) {
        return I18n.func_135052_a((String)name, (Object[])format);
    }

    public abstract void init(int var1, int var2);

    public abstract void update(int var1, int var2);

    public abstract void drawBackground(int var1, int var2, int var3, int var4);

    public abstract void drawForeground(int var1, int var2);

    public int getGuiLeft() {
        return this.field_147003_i;
    }

    public int getGuiTop() {
        return this.field_147009_r;
    }

    public static <T> void executeLater(Class<T> clazz, Consumer<T> callback) {
        Queue<Consumer> queue = RUNNABLES.get(clazz);
        if (queue == null) {
            queue = new ArrayDeque<Consumer>();
            RUNNABLES.put(clazz, queue);
        }
        queue.add(callback);
    }

    public class ElementDrawers
    implements IElementDrawers {
        private IElementDrawer<FluidStack> fluidDrawer = (x, y, element) -> FLUID_RENDERER.draw(GuiBase.this.field_146297_k, x, y, (FluidStack)element);

        @Override
        public IElementDrawer<ItemStack> getItemDrawer() {
            return GuiBase.this::drawItem;
        }

        @Override
        public IElementDrawer<FluidStack> getFluidDrawer() {
            return this.fluidDrawer;
        }

        @Override
        public IElementDrawer<String> getStringDrawer() {
            return GuiBase.this::drawString;
        }

        @Override
        public FontRenderer getFontRenderer() {
            return GuiBase.this.field_146289_q;
        }
    }
}

