/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.container;

import com.raoulvdberge.refinedstorage.RSItems;
import com.raoulvdberge.refinedstorage.api.network.grid.GridType;
import com.raoulvdberge.refinedstorage.api.network.grid.IGrid;
import com.raoulvdberge.refinedstorage.api.network.grid.handler.IFluidGridHandler;
import com.raoulvdberge.refinedstorage.api.network.grid.handler.IItemGridHandler;
import com.raoulvdberge.refinedstorage.api.storage.IStorageCache;
import com.raoulvdberge.refinedstorage.api.storage.IStorageCacheListener;
import com.raoulvdberge.refinedstorage.api.storage.IStorageDiskProvider;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNodeGrid;
import com.raoulvdberge.refinedstorage.container.ContainerBase;
import com.raoulvdberge.refinedstorage.container.slot.SlotDisabled;
import com.raoulvdberge.refinedstorage.container.slot.SlotFilter;
import com.raoulvdberge.refinedstorage.container.slot.SlotFilterLegacy;
import com.raoulvdberge.refinedstorage.container.slot.SlotGridCrafting;
import com.raoulvdberge.refinedstorage.container.slot.SlotGridCraftingResult;
import com.raoulvdberge.refinedstorage.gui.IResizableDisplay;
import com.raoulvdberge.refinedstorage.tile.TileBase;
import com.raoulvdberge.refinedstorage.tile.grid.WirelessGrid;
import com.raoulvdberge.refinedstorage.tile.grid.portable.IPortableGrid;
import com.raoulvdberge.refinedstorage.tile.grid.portable.PortableGrid;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ContainerGrid
extends ContainerBase {
    public static final int TAB_WIDTH = 28;
    public static final int TAB_HEIGHT = 31;
    private IGrid grid;
    private IStorageCache cache;
    private IStorageCacheListener listener;
    private IResizableDisplay display;
    private SlotGridCraftingResult craftingResultSlot;
    private SlotDisabled patternResultSlot;

    public ContainerGrid(IGrid grid, IResizableDisplay display, @Nullable TileBase gridTile, EntityPlayer player) {
        super(gridTile, player);
        this.grid = grid;
        this.display = display;
        this.initSlots();
    }

    public void initSlots() {
        int y;
        int x;
        this.field_75151_b.clear();
        this.field_75153_a.clear();
        int headerAndSlots = this.getTabDelta() + this.display.getTopHeight() + this.display.getVisibleRows() * 18;
        if (this.grid.getType() != GridType.FLUID) {
            int yStart = 6;
            if (this.grid instanceof IPortableGrid) {
                yStart = 38;
            }
            for (int i = 0; i < 4; ++i) {
                this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.grid.getFilter(), i, 204, yStart + 18 * i + this.getTabDelta()));
            }
        }
        if (this.grid.getType() == GridType.PATTERN) {
            this.func_75146_a((Slot)new SlotItemHandler(((NetworkNodeGrid)this.grid).getPatterns(), 0, 172, headerAndSlots + 4));
            this.func_75146_a((Slot)new SlotItemHandler(((NetworkNodeGrid)this.grid).getPatterns(), 1, 172, headerAndSlots + 40));
        }
        if (this.grid instanceof IPortableGrid) {
            this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)((IPortableGrid)((Object)this.grid)).getDisk(), 0, 204, 6 + this.getTabDelta()));
        }
        this.addPlayerInventory(8, this.display.getYPlayerInventory());
        if (this.grid.getType() == GridType.CRAFTING) {
            x = 26;
            y = headerAndSlots + 4;
            for (int i = 0; i < 9; ++i) {
                this.func_75146_a(new SlotGridCrafting((IInventory)this.grid.getCraftingMatrix(), i, x, y));
                x += 18;
                if ((i + 1) % 3 != 0) continue;
                y += 18;
                x = 26;
            }
            this.craftingResultSlot = new SlotGridCraftingResult(this, this.getPlayer(), this.grid, 0, 134, headerAndSlots + 22);
            this.func_75146_a((Slot)this.craftingResultSlot);
        } else if (this.grid.getType() == GridType.PATTERN) {
            if (((NetworkNodeGrid)this.grid).isProcessingPattern()) {
                int ox;
                int x2 = ox = 8;
                int y2 = headerAndSlots + 4;
                for (int i = 0; i < 18; ++i) {
                    this.func_75146_a((Slot)new SlotFilter((IItemHandler)((NetworkNodeGrid)this.grid).getProcessingMatrix(), i, x2, y2, 1));
                    x2 += 18;
                    if ((i + 1) % 3 != 0) continue;
                    if (i == 8) {
                        x2 = ox = 98;
                        y2 = headerAndSlots + 4;
                        continue;
                    }
                    x2 = ox;
                    y2 += 18;
                }
            } else {
                x = 26;
                y = headerAndSlots + 4;
                for (int i = 0; i < 9; ++i) {
                    this.func_75146_a(new SlotFilterLegacy((IInventory)this.grid.getCraftingMatrix(), i, x, y));
                    x += 18;
                    if ((i + 1) % 3 != 0) continue;
                    y += 18;
                    x = 26;
                }
                this.patternResultSlot = new SlotDisabled((IInventory)this.grid.getCraftingResult(), 0, 134, headerAndSlots + 22);
                this.func_75146_a(this.patternResultSlot);
            }
        }
    }

    private int getTabDelta() {
        return !this.grid.getTabs().isEmpty() ? 27 : 0;
    }

    public IGrid getGrid() {
        return this.grid;
    }

    public void sendCraftingSlots() {
        for (int i = 0; i < this.field_75151_b.size(); ++i) {
            Slot slot = (Slot)this.field_75151_b.get(i);
            if (!(slot instanceof SlotGridCrafting) && slot != this.craftingResultSlot) continue;
            for (IContainerListener listener : this.field_75149_d) {
                listener.func_71111_a((Container)this, i, slot.func_75211_c());
            }
        }
    }

    public void sendAllSlots() {
        for (int i = 0; i < this.field_75151_b.size(); ++i) {
            Slot slot = (Slot)this.field_75151_b.get(i);
            for (IContainerListener listener : this.field_75149_d) {
                listener.func_71111_a((Container)this, i, slot.func_75211_c());
            }
        }
    }

    @Override
    public void func_75142_b() {
        if (!this.getPlayer().field_70170_p.field_72995_K) {
            if (this.grid.getStorageCache() == null) {
                if (this.listener != null) {
                    this.cache.removeListener(this.listener);
                    this.listener = null;
                    this.cache = null;
                }
            } else if (this.listener == null) {
                this.listener = this.grid.createListener((EntityPlayerMP)this.getPlayer());
                this.cache = this.grid.getStorageCache();
                this.cache.addListener(this.listener);
            }
        }
        super.func_75142_b();
    }

    @Override
    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (!player.func_130014_f_().field_72995_K) {
            this.grid.onClosed(player);
            if (this.cache != null && this.listener != null) {
                this.cache.removeListener(this.listener);
            }
        }
    }

    public boolean func_94530_a(ItemStack stack, Slot slot) {
        return slot == this.craftingResultSlot || slot == this.patternResultSlot ? false : super.func_94530_a(stack, slot);
    }

    @Override
    public ItemStack func_82846_b(EntityPlayer player, int slotIndex) {
        Slot slot;
        if (!player.func_130014_f_().field_72995_K && (slot = (Slot)this.field_75151_b.get(slotIndex)).func_75216_d()) {
            if (slot == this.craftingResultSlot) {
                this.grid.onCraftedShift(player);
                this.sendCraftingSlots();
                this.func_75142_b();
            } else if (slot != this.patternResultSlot && !(slot instanceof SlotFilterLegacy)) {
                int startIndex;
                ItemStack stack = slot.func_75211_c();
                if (this.grid.getType() != GridType.FLUID && stack.func_77973_b() == RSItems.FILTER) {
                    startIndex = 0;
                    int endIndex = 4;
                    if (slotIndex < 4) {
                        startIndex = 4;
                        if (this.grid.getType() == GridType.PATTERN) {
                            startIndex += 2;
                        }
                        endIndex = startIndex + 36;
                    }
                    if (this.func_75135_a(stack, startIndex, endIndex, false)) {
                        slot.func_75218_e();
                        this.func_75142_b();
                        if (slotIndex < 4) {
                            this.grid.getFilter().setStackInSlot(slotIndex, ItemStack.field_190927_a);
                        }
                        return ItemStack.field_190927_a;
                    }
                } else if (this.grid.getType() == GridType.PATTERN && stack.func_77973_b() == RSItems.PATTERN || this.grid instanceof IPortableGrid && stack.func_77973_b() instanceof IStorageDiskProvider) {
                    startIndex = 4;
                    int endIndex = startIndex + 1;
                    if (slotIndex == 4) {
                        startIndex = endIndex;
                        endIndex = startIndex + 36;
                    }
                    if (this.func_75135_a(stack, startIndex, endIndex, false)) {
                        slot.func_75218_e();
                        this.func_75142_b();
                        if (this.grid instanceof IPortableGrid && slotIndex == 4) {
                            ((IPortableGrid)((Object)this.grid)).getDisk().setStackInSlot(0, ItemStack.field_190927_a);
                        }
                        return ItemStack.field_190927_a;
                    }
                    if (this.grid instanceof PortableGrid) {
                        return ItemStack.field_190927_a;
                    }
                }
                if (this.grid.getType() == GridType.FLUID) {
                    IFluidGridHandler fluidHandler = this.grid.getFluidHandler();
                    if (fluidHandler != null) {
                        slot.func_75215_d(fluidHandler.onShiftClick((EntityPlayerMP)player, stack));
                    }
                } else {
                    IItemGridHandler itemHandler = this.grid.getItemHandler();
                    if (itemHandler != null) {
                        slot.func_75215_d(itemHandler.onShiftClick((EntityPlayerMP)player, stack));
                    } else if (slot instanceof SlotGridCrafting && this.func_75135_a(stack, 4, 40, false)) {
                        slot.func_75218_e();
                    }
                }
                this.func_75142_b();
            }
        }
        return ItemStack.field_190927_a;
    }

    @Override
    protected boolean isHeldItemDisabled() {
        return this.grid instanceof WirelessGrid || this.grid instanceof PortableGrid;
    }
}

