/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.util;

import com.google.common.collect.ArrayListMultimap;
import com.raoulvdberge.refinedstorage.api.util.IStackList;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class StackListFluid
implements IStackList<FluidStack> {
    private ArrayListMultimap<Fluid, FluidStack> stacks = ArrayListMultimap.create();
    private List<FluidStack> removeTracker = new LinkedList<FluidStack>();

    @Override
    public void add(@Nonnull FluidStack stack, int size) {
        for (FluidStack otherStack : this.stacks.get((Object)stack.getFluid())) {
            if (!stack.isFluidEqual(otherStack)) continue;
            otherStack.amount += size;
            return;
        }
        FluidStack newStack = stack.copy();
        newStack.amount = size;
        this.stacks.put((Object)stack.getFluid(), (Object)newStack);
    }

    @Override
    public boolean remove(@Nonnull FluidStack stack, int size) {
        for (FluidStack otherStack : this.stacks.get((Object)stack.getFluid())) {
            boolean success;
            if (!stack.isFluidEqual(otherStack)) continue;
            otherStack.amount -= size;
            boolean bl = success = otherStack.amount >= 0;
            if (otherStack.amount <= 0) {
                this.stacks.remove((Object)otherStack.getFluid(), (Object)otherStack);
            }
            return success;
        }
        return false;
    }

    @Override
    public boolean trackedRemove(@Nonnull FluidStack stack, int size) {
        for (FluidStack otherStack : this.stacks.get((Object)stack.getFluid())) {
            boolean success;
            if (!stack.isFluidEqual(otherStack)) continue;
            FluidStack removed = new FluidStack(otherStack.getFluid(), Math.min(size, otherStack.amount));
            this.removeTracker.add(removed);
            otherStack.amount -= size;
            boolean bl = success = otherStack.amount >= 0;
            if (otherStack.amount <= 0) {
                this.stacks.remove((Object)otherStack.getFluid(), (Object)otherStack);
            }
            return success;
        }
        return false;
    }

    @Override
    public void undo() {
        this.removeTracker.forEach(s -> this.add((FluidStack)s, s.amount));
        this.removeTracker.clear();
    }

    @Override
    public List<FluidStack> getRemoveTracker() {
        return this.removeTracker;
    }

    @Override
    @Nullable
    public FluidStack get(@Nonnull FluidStack stack, int flags) {
        for (FluidStack otherStack : this.stacks.get((Object)stack.getFluid())) {
            if (!API.instance().getComparer().isEqual(otherStack, stack, flags)) continue;
            return otherStack;
        }
        return null;
    }

    @Override
    @Nullable
    public FluidStack get(int hash) {
        for (FluidStack stack : this.stacks.values()) {
            if (API.instance().getFluidStackHashCode(stack) != hash) continue;
            return stack;
        }
        return null;
    }

    @Override
    public void clear() {
        this.stacks.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.stacks.isEmpty();
    }

    @Override
    public int getSizeFromStack(FluidStack stack) {
        return stack.amount;
    }

    @Override
    @Nonnull
    public Collection<FluidStack> getStacks() {
        return this.stacks.values();
    }

    @Override
    @Nonnull
    public IStackList<FluidStack> copy() {
        StackListFluid list = new StackListFluid();
        for (FluidStack stack : this.stacks.values()) {
            list.stacks.put((Object)stack.getFluid(), (Object)stack.copy());
        }
        return list;
    }

    @Override
    public IStackList<FluidStack> getOredicted() {
        throw new UnsupportedOperationException("Fluid lists have no oredicted version!");
    }

    public String toString() {
        return this.stacks.toString();
    }
}

