/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.storage;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.storage.IStorageCacheListener;
import com.raoulvdberge.refinedstorage.api.storage.IStorageTracker;
import com.raoulvdberge.refinedstorage.network.MessageGridItemDelta;
import com.raoulvdberge.refinedstorage.network.MessageGridItemUpdate;
import com.raoulvdberge.refinedstorage.tile.grid.portable.IPortableGrid;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class StorageCacheListenerGridPortable
implements IStorageCacheListener<ItemStack> {
    private IPortableGrid portableGrid;
    private EntityPlayerMP player;

    public StorageCacheListenerGridPortable(IPortableGrid portableGrid, EntityPlayerMP player) {
        this.portableGrid = portableGrid;
        this.player = player;
    }

    @Override
    public void onAttached() {
        RS.INSTANCE.network.sendTo((IMessage)new MessageGridItemUpdate(buf -> {
            buf.writeInt(this.portableGrid.getCache().getList().getStacks().size());
            for (ItemStack stack : this.portableGrid.getCache().getList().getStacks()) {
                StackUtils.writeItemStack(buf, stack, null, false);
                IStorageTracker.IStorageTrackerEntry entry = this.portableGrid.getStorageTracker().get(stack);
                buf.writeBoolean(entry != null);
                if (entry == null) continue;
                buf.writeLong(entry.getTime());
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)entry.getName());
            }
        }, false), this.player);
    }

    @Override
    public void onInvalidated() {
    }

    @Override
    public void onChanged(@Nonnull ItemStack stack, int size) {
        RS.INSTANCE.network.sendTo((IMessage)new MessageGridItemDelta(null, this.portableGrid.getStorageTracker(), stack, size), this.player);
    }
}

