/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.RSBlocks;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReaderWriterChannel;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReaderWriterHandler;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IWriter;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.IGuiReaderWriter;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.tile.TileWriter;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class NetworkNodeWriter
extends NetworkNode
implements IWriter,
IGuiReaderWriter {
    public static final String ID = "writer";
    private static final String NBT_CHANNEL = "Channel";
    private String channel = "";
    private int redstoneStrength;
    private int lastRedstoneStrength;

    public NetworkNodeWriter(World world, BlockPos pos) {
        super(world, pos);
    }

    @Override
    public int getEnergyUsage() {
        return RS.INSTANCE.config.writerUsage;
    }

    @Override
    public void update() {
        super.update();
        if (this.getRedstoneStrength() != this.lastRedstoneStrength) {
            this.lastRedstoneStrength = this.getRedstoneStrength();
            this.world.func_175685_c(this.pos, (Block)RSBlocks.WRITER, true);
        }
    }

    @Override
    public int getRedstoneStrength() {
        return this.network != null ? this.redstoneStrength : 0;
    }

    @Override
    public void setRedstoneStrength(int strength) {
        this.redstoneStrength = strength;
    }

    @Override
    public String getTitle() {
        return "gui.refinedstorage:writer";
    }

    @Override
    public String getChannel() {
        return this.channel;
    }

    @Override
    public void setChannel(String channel) {
        IReaderWriterChannel networkChannel;
        if (this.network != null && channel.equals("") && (networkChannel = this.network.getReaderWriterManager().getChannel(this.channel)) != null) {
            for (IReaderWriterHandler handler : networkChannel.getHandlers()) {
                handler.onWriterDisabled(this);
            }
        }
        this.channel = channel;
    }

    @Override
    public TileDataParameter<String, ?> getChannelParameter() {
        return TileWriter.CHANNEL;
    }

    @Override
    public TileDataParameter<Integer, ?> getRedstoneModeParameter() {
        return TileWriter.REDSTONE_MODE;
    }

    @Override
    public boolean hasConnectivityState() {
        return true;
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        if (tag.func_74764_b(NBT_CHANNEL)) {
            this.channel = tag.func_74779_i(NBT_CHANNEL);
        }
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        tag.func_74778_a(NBT_CHANNEL, this.channel);
        return tag;
    }

    public void onOpened(EntityPlayer entity) {
        if (this.network != null) {
            this.network.getReaderWriterManager().sendUpdateTo((EntityPlayerMP)entity);
        }
    }
}

