/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.autocrafting.EventAutocraftingComplete;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingManager;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternChain;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternProvider;
import com.raoulvdberge.refinedstorage.api.autocrafting.registry.ICraftingTaskFactory;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingStep;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNodeProxy;
import com.raoulvdberge.refinedstorage.api.util.IStackList;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.CraftingPatternChainList;
import com.raoulvdberge.refinedstorage.container.ContainerCraftingMonitor;
import com.raoulvdberge.refinedstorage.network.MessageCraftingMonitorElements;
import com.raoulvdberge.refinedstorage.tile.TileController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class CraftingManager
implements ICraftingManager {
    private static final String NBT_CRAFTING_TASKS = "CraftingTasks";
    private static final String NBT_BLOCKED_CONTAINERS = "BlockedContainers";
    private static final String NBT_BLOCKER_UUID = "BlockerUuid";
    private static final String NBT_BLOCKEE_UUID = "BlockeeUuid";
    private TileController network;
    private List<ICraftingPatternContainer> containers = new ArrayList<ICraftingPatternContainer>();
    private Map<String, List<IItemHandlerModifiable>> containerInventories = new LinkedHashMap<String, List<IItemHandlerModifiable>>();
    private CraftingPatternChainList patterns = new CraftingPatternChainList();
    private Map<UUID, UUID> blockingContainers = new HashMap<UUID, UUID>();
    private Set<UUID> blockedContainers = new HashSet<UUID>();
    private List<ICraftingTask> craftingTasks = new ArrayList<ICraftingTask>();
    private List<ICraftingTask> craftingTasksToAdd = new ArrayList<ICraftingTask>();
    private List<ICraftingTask> craftingTasksToCancel = new ArrayList<ICraftingTask>();
    private List<NBTTagCompound> craftingTasksToRead = new ArrayList<NBTTagCompound>();
    private List<ICraftingStep> runningSteps = new ArrayList<ICraftingStep>();
    private boolean craftingMonitorUpdateRequested;
    private int ticks;

    public CraftingManager(TileController network) {
        this.network = network;
    }

    @Override
    public List<ICraftingTask> getTasks() {
        return this.craftingTasks;
    }

    @Override
    public List<ICraftingPatternContainer> getContainers() {
        return this.containers;
    }

    @Override
    public Map<String, List<IItemHandlerModifiable>> getNamedContainers() {
        return this.containerInventories;
    }

    @Override
    public void addContainerBlock(UUID blocker, UUID blockee) {
        this.blockedContainers.add(blockee);
        this.blockingContainers.put(blocker, blockee);
    }

    @Override
    public void removeContainerBlock(UUID blocker) {
        this.blockedContainers.remove(this.blockingContainers.get(blocker));
        this.blockingContainers.remove(blocker);
    }

    @Override
    public boolean isContainerBlocked(UUID blockee) {
        return this.blockedContainers.contains(blockee);
    }

    @Override
    public void setContainerBlocked(ICraftingPatternContainer container, boolean blocked) {
        if (blocked) {
            ICraftingPatternContainer proxy = container.getRootContainer();
            if (proxy != null) {
                this.addContainerBlock(container.getUuid(), proxy.getUuid());
            }
        } else {
            this.removeContainerBlock(container.getUuid());
        }
    }

    @Override
    public void add(@Nonnull ICraftingTask task) {
        this.craftingTasksToAdd.add(task);
        this.network.func_70296_d();
    }

    @Override
    public void cancel(@Nonnull ICraftingTask task) {
        this.craftingTasksToCancel.add(task);
        this.network.func_70296_d();
    }

    @Override
    public ICraftingTask create(@Nullable ItemStack stack, ICraftingPattern pattern, int quantity, boolean automated) {
        return API.instance().getCraftingTaskRegistry().get(pattern.getId()).create(this.network, stack, pattern, quantity, automated, null);
    }

    @Override
    public ICraftingTask create(@Nullable ItemStack stack, ICraftingPatternChain patternChain, int quantity, boolean automated) {
        return API.instance().getCraftingTaskRegistry().get(patternChain.getPrototype().getId()).create(this.network, stack, patternChain, quantity, automated);
    }

    @Override
    public List<ICraftingPattern> getPatterns() {
        return this.patterns.asList();
    }

    @Override
    public List<ICraftingPattern> getPatterns(ItemStack pattern, int flags) {
        return this.getPatternChains(pattern, flags).stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<ICraftingPatternChain> getPatternChains(ItemStack pattern, int flags) {
        LinkedList<ICraftingPatternChain> patternChains = new LinkedList<ICraftingPatternChain>();
        for (CraftingPatternChainList.CraftingPatternChain chain : this.patterns) {
            for (ItemStack output : chain.getPrototype().getOutputs()) {
                if (!API.instance().getComparer().isEqual(output, pattern, flags)) continue;
                patternChains.add(chain);
            }
        }
        return patternChains;
    }

    @Override
    public boolean hasPattern(ItemStack stack, int flags) {
        for (CraftingPatternChainList.CraftingPatternChain chain : this.patterns) {
            for (ItemStack output : chain.getPrototype().getOutputs()) {
                if (!API.instance().getComparer().isEqual(output, stack, flags)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public ICraftingPatternChain getPatternChain(ItemStack pattern, int flags) {
        return this.getPatternChain(pattern, flags, this.network.getItemStorageCache().getList().getOredicted());
    }

    @Override
    public ICraftingPatternChain getPatternChain(ItemStack pattern, int flags, IStackList<ItemStack> itemList) {
        List<ICraftingPatternChain> patternChains = this.getPatternChains(pattern, flags);
        if (patternChains.isEmpty()) {
            return null;
        }
        if (patternChains.size() == 1) {
            return patternChains.get(0);
        }
        int highestScore = 0;
        int highestPattern = 0;
        for (int i = 0; i < patternChains.size(); ++i) {
            int score = 0;
            for (ItemStack input : patternChains.get(i).getPrototype().getInputs()) {
                if (input == null) continue;
                ItemStack stored = itemList.get(input, 3 | (patternChains.get(i).getPrototype().isOredict() ? 8 : 0));
                score += stored != null ? stored.func_190916_E() : 0;
            }
            if (score <= highestScore) continue;
            highestScore = score;
            highestPattern = i;
        }
        return patternChains.get(highestPattern);
    }

    @Override
    public void update() {
        if (!this.craftingTasksToRead.isEmpty()) {
            for (NBTTagCompound tag : this.craftingTasksToRead) {
                ICraftingTask task = CraftingManager.readCraftingTask(this.network, tag);
                if (task == null) continue;
                this.add(task);
            }
            this.craftingTasksToRead.clear();
        }
        if (this.network.canRun()) {
            boolean craftingTasksChanged = !this.craftingTasksToAdd.isEmpty() || !this.craftingTasksToCancel.isEmpty();
            this.craftingTasksToCancel.forEach(ICraftingTask::onCancelled);
            this.craftingTasks.removeAll(this.craftingTasksToCancel);
            this.craftingTasksToCancel.clear();
            this.craftingTasksToAdd.stream().filter(ICraftingTask::isValid).forEach(this.craftingTasks::add);
            this.craftingTasksToAdd.clear();
            if (this.ticks++ % 5 == 0) {
                Iterator<ICraftingTask> craftingTaskIterator = this.craftingTasks.iterator();
                HashMap<ICraftingPatternContainer, Integer> usedCrafters = new HashMap<ICraftingPatternContainer, Integer>();
                while (craftingTaskIterator.hasNext()) {
                    ICraftingTask task = craftingTaskIterator.next();
                    if (task.update(usedCrafters)) {
                        EventAutocraftingComplete.fire(this.network, task.getRequested(), task.getQuantity());
                        craftingTaskIterator.remove();
                        craftingTasksChanged = true;
                        continue;
                    }
                    if (task.getMissing().isEmpty() || this.ticks % 100 != 0 || !(Math.random() > 0.5)) continue;
                    task.getMissing().clear();
                }
                this.runningSteps = this.craftingTasks.stream().map(ICraftingTask::getSteps).flatMap(Collection::stream).filter(ICraftingStep::hasStartedProcessing).collect(Collectors.toList());
                if (craftingTasksChanged) {
                    this.markCraftingMonitorForUpdate();
                }
            }
        }
        if (this.craftingMonitorUpdateRequested) {
            this.craftingMonitorUpdateRequested = false;
            this.sendCraftingMonitorUpdate();
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        int i;
        if (tag.func_74764_b(NBT_CRAFTING_TASKS)) {
            NBTTagList taskList = tag.func_150295_c(NBT_CRAFTING_TASKS, 10);
            for (i = 0; i < taskList.func_74745_c(); ++i) {
                this.craftingTasksToRead.add(taskList.func_150305_b(i));
            }
        }
        if (tag.func_74764_b(NBT_BLOCKED_CONTAINERS)) {
            NBTTagList containerList = tag.func_150295_c(NBT_BLOCKED_CONTAINERS, 10);
            for (i = 0; i < containerList.func_74745_c(); ++i) {
                NBTTagCompound compound = containerList.func_150305_b(i);
                this.addContainerBlock(compound.func_186857_a(NBT_BLOCKER_UUID), compound.func_186857_a(NBT_BLOCKEE_UUID));
            }
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        NBTTagList craftingTaskList = new NBTTagList();
        for (ICraftingTask task : this.craftingTasks) {
            craftingTaskList.func_74742_a((NBTBase)task.writeToNBT(new NBTTagCompound()));
        }
        tag.func_74782_a(NBT_CRAFTING_TASKS, (NBTBase)craftingTaskList);
        NBTTagList blockingContainersList = new NBTTagList();
        for (Map.Entry<UUID, UUID> pair : this.blockingContainers.entrySet()) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_186854_a(NBT_BLOCKER_UUID, pair.getKey());
            compound.func_186854_a(NBT_BLOCKEE_UUID, pair.getValue());
            blockingContainersList.func_74742_a((NBTBase)compound);
        }
        tag.func_74782_a(NBT_BLOCKED_CONTAINERS, (NBTBase)blockingContainersList);
        return tag;
    }

    @Override
    public ICraftingTask schedule(ItemStack stack, int toSchedule, int compare) {
        ICraftingPatternChain patternChain;
        for (ICraftingTask task : this.getTasks()) {
            for (ItemStack output : task.getPattern().getOutputs()) {
                if (!API.instance().getComparer().isEqual(output, stack, compare)) continue;
                toSchedule -= output.func_190916_E() * task.getQuantity();
            }
        }
        if (toSchedule > 0 && (patternChain = this.getPatternChain(stack, compare)) != null) {
            ICraftingTask task;
            task = this.create(stack, patternChain, toSchedule, true);
            task.calculate();
            task.getMissing().clear();
            this.add(task);
            this.markCraftingMonitorForUpdate();
            return task;
        }
        return null;
    }

    @Override
    public void track(ItemStack stack, int size) {
        ItemStack inserted = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
        for (ICraftingStep step : this.runningSteps) {
            if (!step.onReceiveOutput(inserted)) continue;
            return;
        }
    }

    @Override
    public void rebuild() {
        this.patterns.clear();
        this.containerInventories.clear();
        for (INetworkNode node : this.network.getNodeGraph().all()) {
            if (!(node instanceof ICraftingPatternContainer) || !node.canUpdate()) continue;
            ICraftingPatternContainer container = (ICraftingPatternContainer)((Object)node);
            this.patterns.addAll(container.getPatterns());
            IItemHandlerModifiable handler = container.getPatternInventory();
            if (handler == null) continue;
            this.containerInventories.computeIfAbsent(container.getName(), k -> new ArrayList()).add(handler);
        }
        this.craftingTasks.forEach(t -> t.getMissing().clear());
    }

    @Override
    public void markCraftingMonitorForUpdate() {
        this.craftingMonitorUpdateRequested = true;
    }

    @Override
    public void sendCraftingMonitorUpdate() {
        this.network.world().func_73046_m().func_184103_al().func_181057_v().stream().filter(player -> player.field_71070_bA instanceof ContainerCraftingMonitor && this.network.getPosition().equals((Object)((ContainerCraftingMonitor)player.field_71070_bA).getCraftingMonitor().getNetworkPosition())).forEach(player -> RS.INSTANCE.network.sendTo((IMessage)new MessageCraftingMonitorElements(((ContainerCraftingMonitor)player.field_71070_bA).getCraftingMonitor()), player));
    }

    @Override
    public void sendCraftingMonitorUpdate(EntityPlayerMP player) {
        RS.INSTANCE.network.sendTo((IMessage)new MessageCraftingMonitorElements(((ContainerCraftingMonitor)player.field_71070_bA).getCraftingMonitor()), player);
    }

    private static ICraftingTask readCraftingTask(INetwork network, NBTTagCompound tag) {
        INetworkNodeProxy proxy;
        TileEntity container;
        ItemStack stack = new ItemStack(tag.func_74775_l("PatternStack"));
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ICraftingPatternProvider && (container = network.world().func_175625_s(BlockPos.func_177969_a((long)tag.func_74763_f("PatternContainer")))) instanceof INetworkNodeProxy && (proxy = (INetworkNodeProxy)container).getNode() instanceof ICraftingPatternContainer) {
            ICraftingPattern pattern = ((ICraftingPatternProvider)stack.func_77973_b()).create(network.world(), stack, (ICraftingPatternContainer)proxy.getNode());
            ICraftingTaskFactory factory = API.instance().getCraftingTaskRegistry().get(tag.func_74779_i("PatternID"));
            if (factory != null) {
                return factory.create(network, tag.func_74764_b("Requested") ? new ItemStack(tag.func_74775_l("Requested")) : null, pattern, tag.func_74762_e("Quantity"), false, tag);
            }
        }
        return null;
    }
}

