/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.api.autocrafting;

import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternChain;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.raoulvdberge.refinedstorage.api.util.IStackList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.IItemHandlerModifiable;

public interface ICraftingManager {
    public List<ICraftingTask> getTasks();

    public List<ICraftingPatternContainer> getContainers();

    public Map<String, List<IItemHandlerModifiable>> getNamedContainers();

    public void addContainerBlock(UUID var1, UUID var2);

    public void removeContainerBlock(UUID var1);

    public boolean isContainerBlocked(UUID var1);

    public void setContainerBlocked(ICraftingPatternContainer var1, boolean var2);

    public void add(@Nonnull ICraftingTask var1);

    public void cancel(@Nonnull ICraftingTask var1);

    public ICraftingTask create(@Nullable ItemStack var1, ICraftingPattern var2, int var3, boolean var4);

    public ICraftingTask create(@Nullable ItemStack var1, ICraftingPatternChain var2, int var3, boolean var4);

    @Nullable
    public ICraftingTask schedule(ItemStack var1, int var2, int var3);

    public void track(ItemStack var1, int var2);

    public List<ICraftingPattern> getPatterns();

    public void rebuild();

    public List<ICraftingPattern> getPatterns(ItemStack var1, int var2);

    @Nullable
    default public ICraftingPattern getPattern(ItemStack pattern, int flags) {
        ICraftingPatternChain chain = this.getPatternChain(pattern, flags);
        return chain == null ? null : chain.cycle();
    }

    @Nullable
    default public ICraftingPattern getPattern(ItemStack pattern, int flags, IStackList<ItemStack> itemList) {
        ICraftingPatternChain chain = this.getPatternChain(pattern, flags, itemList);
        return chain == null ? null : chain.cycle();
    }

    @Nullable
    default public ICraftingPattern getPattern(ItemStack pattern) {
        return this.getPattern(pattern, 3);
    }

    @Nullable
    public ICraftingPatternChain getPatternChain(ItemStack var1, int var2);

    @Nullable
    public ICraftingPatternChain getPatternChain(ItemStack var1, int var2, IStackList<ItemStack> var3);

    @Nullable
    default public ICraftingPatternChain getPatternChain(ItemStack pattern) {
        return this.getPatternChain(pattern, 3);
    }

    default public boolean hasPattern(ItemStack stack) {
        return this.hasPattern(stack, 3);
    }

    public boolean hasPattern(ItemStack var1, int var2);

    public void update();

    public void readFromNBT(NBTTagCompound var1);

    public NBTTagCompound writeToNBT(NBTTagCompound var1);

    public void markCraftingMonitorForUpdate();

    public void sendCraftingMonitorUpdate();

    public void sendCraftingMonitorUpdate(EntityPlayerMP var1);
}

