/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.integration.minetweaker;

import com.google.common.collect.Lists;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.oredict.IOreDictEntry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import sonar.core.SonarCore;
import sonar.core.recipes.DefinedRecipeHelper;
import sonar.core.recipes.ISonarRecipeObject;
import sonar.core.recipes.RecipeHelperV2;
import sonar.core.recipes.RecipeItemStack;
import sonar.core.recipes.RecipeOreStack;
import sonar.core.recipes.ValueHelperV2;

public class SonarAddRecipeV2<T extends RecipeHelperV2>
implements IAction {
    public ArrayList<ISonarRecipeObject> inputs;
    public ArrayList<ISonarRecipeObject> outputs;
    public boolean liquidStack;
    public boolean wasNull;
    public boolean wrongSize;
    public T helper;

    public SonarAddRecipeV2(T helper, ArrayList inputs, ArrayList<ItemStack> outputs) {
        this.helper = helper;
        if (helper instanceof DefinedRecipeHelper && (inputs.size() != ((DefinedRecipeHelper)helper).getInputSize() || outputs.size() != ((DefinedRecipeHelper)helper).getOutputSize())) {
            CraftTweakerAPI.logError((String)("A " + ((RecipeHelperV2)helper).getRecipeID() + " recipe was the wrong size"));
            this.wrongSize = true;
            return;
        }
        ArrayList<ISonarRecipeObject> adaptedInputs = new ArrayList<ISonarRecipeObject>();
        ArrayList<RecipeItemStack> adaptedOutputs = new ArrayList<RecipeItemStack>();
        for (Object input : inputs) {
            if (input == null) {
                CraftTweakerAPI.logError((String)String.format("An ingredient of a %s was null", ((RecipeHelperV2)helper).getRecipeID()));
                this.wasNull = true;
                return;
            }
            if (input instanceof IItemStack) {
                adaptedInputs.add(((RecipeHelperV2)helper).buildRecipeObject(CraftTweakerMC.getItemStack((IItemStack)((IItemStack)input))));
                continue;
            }
            if (input instanceof IOreDictEntry) {
                adaptedInputs.add(new RecipeOreStack(((IOreDictEntry)input).getName(), 1));
                continue;
            }
            if (input instanceof ILiquidStack) {
                CraftTweakerAPI.logError((String)String.format("A liquid was passed into a %s, aborting!", ((RecipeHelperV2)helper).getRecipeID()));
                this.liquidStack = true;
                return;
            }
            if (!(input instanceof ItemStack)) {
                CraftTweakerAPI.logError((String)String.format("%s: Invalid ingredient: %s", ((RecipeHelperV2)helper).getRecipeID(), input));
                continue;
            }
            adaptedInputs.add(((RecipeHelperV2)helper).buildRecipeObject(input));
        }
        for (ItemStack stack : outputs) {
            adaptedOutputs.add(new RecipeItemStack(stack, false));
        }
        this.inputs = adaptedInputs;
        this.outputs = adaptedOutputs;
    }

    public void apply() {
        if (!(this.wasNull || this.liquidStack || this.wrongSize)) {
            boolean isShapeless = !(this.helper instanceof DefinedRecipeHelper) || ((DefinedRecipeHelper)this.helper).shapeless;
            Object recipe = ((RecipeHelperV2)this.helper).buildRecipe((ArrayList)this.inputs.clone(), (ArrayList)this.outputs.clone(), new ArrayList(), isShapeless);
            ((RecipeHelperV2)this.helper).addRecipe(recipe);
        } else {
            SonarCore.logger.error(String.format("Failed to add %s recipe (%s = %s)", ((RecipeHelperV2)this.helper).getRecipeID(), this.inputs, this.outputs));
        }
    }

    public String describe() {
        return String.format("Adding %s recipe (%s = %s)", ((RecipeHelperV2)this.helper).getRecipeID(), RecipeHelperV2.getValuesFromList(this.inputs), RecipeHelperV2.getValuesFromList(this.outputs));
    }

    public static class Value
    extends SonarAddRecipeV2<ValueHelperV2> {
        public int recipeValue;

        public Value(ValueHelperV2 helper, ArrayList inputs, ArrayList outputs, int recipeValue) {
            super(helper, inputs, outputs);
            this.recipeValue = recipeValue;
        }

        @Override
        public void apply() {
            if (!(this.wasNull || this.liquidStack || this.wrongSize)) {
                ((ValueHelperV2)this.helper).addRecipe(((ValueHelperV2)this.helper).buildRecipe((ArrayList)this.inputs.clone(), (ArrayList)this.outputs.clone(), (List)Lists.newArrayList((Object[])new Integer[]{this.recipeValue}), ((ValueHelperV2)this.helper).shapeless));
            } else {
                SonarCore.logger.error(String.format("Failed to add %s recipe (%s = %s)", ((ValueHelperV2)this.helper).getRecipeID(), this.inputs, this.outputs));
            }
        }
    }
}

