/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.handlers.energy;

import net.minecraft.item.ItemStack;
import sonar.core.api.energy.EnergyType;
import sonar.core.api.energy.IItemEnergyHandler;
import sonar.core.api.utils.ActionType;
import sonar.core.handlers.energy.EnumEnergyWrapperType;
import sonar.core.handlers.energy.IEnergyHandler;

public class ItemHandlingWrapper
implements IEnergyHandler {
    public ItemStack stack;
    public IItemEnergyHandler handler;
    public boolean canAdd;
    public boolean canRemove;
    public boolean canRead;
    public EnergyType type;

    public ItemHandlingWrapper(ItemStack stack, IItemEnergyHandler handler) {
        this.stack = stack;
        this.handler = handler;
        this.canAdd = handler.canAddEnergy(stack);
        this.canRemove = handler.canRemoveEnergy(stack);
        this.canRead = handler.canReadEnergy(stack);
        this.type = handler.getEnergyType();
    }

    @Override
    public EnumEnergyWrapperType getWrapperType() {
        return EnumEnergyWrapperType.EXTERNAL_ITEM;
    }

    @Override
    public EnergyType getEnergyType() {
        return this.type;
    }

    @Override
    public boolean canAddEnergy() {
        return this.canAdd;
    }

    @Override
    public boolean canRemoveEnergy() {
        return this.canRemove;
    }

    @Override
    public boolean canReadEnergy() {
        return this.canRead;
    }

    @Override
    public long addEnergy(long add, ActionType actionType) {
        return this.handler.addEnergy(add, this.stack, actionType);
    }

    @Override
    public long removeEnergy(long remove, ActionType actionType) {
        return this.handler.removeEnergy(remove, this.stack, actionType);
    }

    @Override
    public long getStored() {
        return this.handler.getStored(this.stack);
    }

    @Override
    public long getCapacity() {
        return this.handler.getCapacity(this.stack);
    }
}

