/*
 * Decompiled with CFR 0.152.
 */
package brad16840.common;

import brad16840.common.Common;
import brad16840.common.CustomPacket;
import brad16840.common.Logger;
import brad16840.common.MessageChannel;
import brad16840.common.PacketHandler;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;

public class Translatable
implements CustomPacket.Serializable {
    public String unlocalized;
    public Object[] args;
    public boolean toLowerCase = false;

    public Translatable(String unlocalized, Object ... args) {
        this.unlocalized = unlocalized;
        this.args = args;
    }

    public Translatable setToLowerCase(boolean toLowerCase) {
        this.toLowerCase = toLowerCase;
        return this;
    }

    public String translate() {
        if (this.unlocalized.isEmpty()) {
            return "";
        }
        Object[] params = new Object[this.args.length];
        for (int i = 0; i < this.args.length; ++i) {
            params[i] = this.args[i] instanceof Translatable ? ((Translatable)this.args[i]).translate() : this.args[i];
        }
        if (MessageChannel.getEffectiveSide() == Side.SERVER) {
            String s = "Translation(" + this.unlocalized;
            if (params.length > 0) {
                s = s + ": ";
                String sep = "";
                for (Object o : params) {
                    s = s + sep + o.toString();
                    sep = ", ";
                }
            }
            return s + ")";
        }
        String s = I18n.func_135052_a((String)this.unlocalized, (Object[])params);
        if (this.toLowerCase) {
            return s.toLowerCase();
        }
        return s;
    }

    public Translatable(CustomPacket.CustomPacketReader reader) {
        this.unlocalized = reader.readString();
        this.args = new Object[reader.readInt()];
        block7: for (int i = 0; i < this.args.length; ++i) {
            switch (reader.readInt()) {
                case 0: {
                    this.args[i] = reader.readSerializable(Translatable.class);
                    continue block7;
                }
                case 1: {
                    this.args[i] = reader.readString();
                    continue block7;
                }
                case 2: {
                    this.args[i] = reader.readInt();
                    continue block7;
                }
                case 3: {
                    this.args[i] = reader.readDouble();
                    continue block7;
                }
                case 4: {
                    this.args[i] = reader.readBoolean();
                }
            }
        }
    }

    @Override
    public void write(CustomPacket packet) {
        packet.write(this.unlocalized);
        packet.write(this.args.length);
        for (Object o : this.args) {
            if (o instanceof Translatable) {
                packet.write(0).write((Translatable)o);
                continue;
            }
            if (o instanceof String) {
                packet.write(1).write((String)o);
                continue;
            }
            if (o instanceof Integer) {
                packet.write(2).write((Integer)o);
                continue;
            }
            if (o instanceof Double) {
                packet.write(3).write((Double)o);
                continue;
            }
            if (!(o instanceof Boolean)) continue;
            packet.write(4).write((Boolean)o);
        }
    }

    public void log(EntityPlayer player) {
        if (player == null || player.field_70170_p.field_72995_K) {
            Logger.log(this);
        } else {
            Logger.internalLog(this.translate());
        }
    }

    public void send(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        Logger.internalLog(this.translate());
        Common.channel.sendToPlayer(player, new PacketHandler.LogMessage(this));
    }

    public void broadcast() {
        if (MessageChannel.getEffectiveSide() == Side.SERVER) {
            Logger.internalLog(this.translate());
            Common.channel.sendToAll(new PacketHandler.LogMessage(this));
        }
    }

    public void logOrSend(EntityPlayer player) {
        if (player == null || player.field_70170_p.field_72995_K) {
            this.log(player);
        } else {
            this.send(player);
        }
    }

    public void addTo(List list) {
        Translatable.addTo(this.translate(), list);
    }

    public static void addTo(String message, List list) {
        String[] sections = message.split("\\\\\\\\");
        String current = "";
        String join = "";
        boolean first = true;
        for (String section : sections) {
            String[] parts = section.split("\\\\n");
            current = current + join + parts[0];
            join = "\\";
            if (parts.length <= 1) continue;
            for (int i = 1; i < parts.length; ++i) {
                list.add(current);
                current = parts[i];
            }
        }
        list.add(current);
    }
}

