/*
 * Decompiled with CFR 0.152.
 */
package brad16840.backpacks.blocks;

import brad16840.backpacks.blocks.QuantumChestTileEntity;
import brad16840.backpacks.items.QuantumBackpack;
import brad16840.common.Common;
import brad16840.common.Translatable;
import brad16840.common.UniqueItem;
import brad16840.common.UniqueItemData;
import brad16840.common.permissions.PermissionGroup;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class QuantumChest
extends BlockContainer
implements UniqueItem.ProtectedBlock {
    public static final PropertyDirection FACING_PROP = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public String field_149770_b;
    public static Translatable name;
    public static int customRenderType;

    public QuantumChest(String unlocalizedName) {
        super(Material.field_151575_d);
        this.field_149770_b = unlocalizedName;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING_PROP, (Comparable)EnumFacing.NORTH));
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.func_149663_c(unlocalizedName);
        this.func_149711_c(2.5f);
        name = new Translatable("tile." + unlocalizedName + ".name", new Object[0]);
        QuantumChest.name.toLowerCase = true;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING_PROP, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING_PROP)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING_PROP});
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return !Common.preventQuantumChestCreation && super.func_176196_c(world, pos);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack stack) {
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)(MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3)).func_176734_d();
        state = state.func_177226_a((IProperty)FACING_PROP, (Comparable)enumfacing);
        world.func_180501_a(pos, state, 3);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (world.field_72995_K) {
            return false;
        }
        String chestId = "@Pos: " + pos.func_177958_n() + ", " + pos.func_177956_o() + ", " + pos.func_177952_p() + "; Dim: " + world.field_73011_w.getDimension();
        UniqueItemData data = UniqueItemData.get(player.field_70170_p);
        int accessLevel = PermissionGroup.getGroup(player.field_70170_p, "I_" + chestId).getAccessLevel(PermissionGroup.getPlayerPermission(player));
        boolean exists = data.blocks.containsKey(chestId);
        boolean canEdit = data.isPermissionDeleted(player, chestId) || accessLevel >= 2;
        QuantumChestTileEntity.VirtualQuantumChest chest = QuantumChestTileEntity.VirtualQuantumChest.getChest(player.field_70170_p, chestId);
        if (!Common.requirePermissionToDestroyQuantumChest || chest == null || chest.getUserCount(null, new HashSet<String>()) < 1 && (canEdit || !exists)) {
            return world.func_175698_g(pos);
        }
        if (exists && !canEdit) {
            UniqueItemData.permissionError("destroy", name).send(player);
        } else {
            new Translatable("problem.breakblockbeingused", new Object[0]).send(player);
        }
        world.func_184138_a(pos, state, world.func_180495_p(pos), 3);
        return false;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        QuantumChestTileEntity tileEntity = (QuantumChestTileEntity)world.func_175625_s(pos);
        if (tileEntity != null) {
            for (int j1 = 0; j1 < tileEntity.func_70302_i_(); ++j1) {
                ItemStack itemstack = tileEntity.func_70301_a(j1);
                if (itemstack.func_190926_b()) continue;
                float f = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                float f1 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                float f2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                while (itemstack.func_190916_E() > 0) {
                    int k1 = world.field_73012_v.nextInt(21) + 10;
                    if (k1 > itemstack.func_190916_E()) {
                        k1 = itemstack.func_190916_E();
                    }
                    itemstack.func_190917_f(-k1);
                    EntityItem entityitem = new EntityItem(world, (double)((float)pos.func_177958_n() + f), (double)((float)pos.func_177956_o() + f1), (double)((float)pos.func_177952_p() + f2), new ItemStack(itemstack.func_77973_b(), k1, itemstack.func_77960_j()));
                    float f3 = 0.05f;
                    entityitem.field_70159_w = (float)world.field_73012_v.nextGaussian() * f3;
                    entityitem.field_70181_x = (float)world.field_73012_v.nextGaussian() * f3 + 0.2f;
                    entityitem.field_70179_y = (float)world.field_73012_v.nextGaussian() * f3;
                    if (itemstack.func_77942_o()) {
                        entityitem.func_92059_d().func_77982_d(itemstack.func_77978_p().func_74737_b());
                    }
                    world.func_72838_d((Entity)entityitem);
                }
            }
            world.func_175666_e(pos, (Block)this);
        }
        if (!world.field_72995_K) {
            UniqueItemData.get(world).deleteItem(world, QuantumChestTileEntity.getChestId(new brad16840.common.BlockPos(pos), world.field_73011_w.getDimension()));
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float par7, float par8, float par9) {
        UniqueItemData data = UniqueItemData.get(player.field_70170_p);
        String blockId = QuantumChestTileEntity.getChestId(new brad16840.common.BlockPos(pos), world.field_73011_w.getDimension());
        ArrayList<String> dataNeeded = new ArrayList<String>();
        if (!data.isSubscribed(blockId)) {
            dataNeeded.add(blockId);
        }
        if (!Common.ensureInventoryIdentifiers(player, (IInventory)player.field_71071_by, ItemStack.field_190927_a, -1, dataNeeded)) {
            return true;
        }
        QuantumChestTileEntity tileEntity = (QuantumChestTileEntity)world.func_175625_s(pos);
        if (tileEntity == null) {
            new Translatable("problem.corrupttileentity", name).log(player);
            return true;
        }
        if (world.field_72995_K) {
            return true;
        }
        tileEntity.func_145829_t();
        player.openGui((Object)"backpacks16840", 5, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public TileEntity func_149915_a(World par1World, int var2) {
        return new QuantumChestTileEntity();
    }

    @Override
    public void subscribeToSubItems(EntityPlayer player, UniqueItemData data, NBTTagCompound tag, ArrayList<NBTTagCompound> tags) {
        if (tag.func_74764_b("backpack")) {
            ItemStack stack = UniqueItem.loadItemStackFromNBT(tag.func_74775_l("backpack"));
            if (UniqueItem.hasIdentifier(stack) && ((UniqueItem)stack.func_77973_b()).hasUniqueData()) {
                data.subscribePlayer(player, UniqueItem.getIdentifier(stack), tags, true);
                return;
            }
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof QuantumBackpack) {
                data.subscribePlayer(player, QuantumBackpack.getInfo(stack), tags, true);
            }
        }
    }

    @Override
    public String getProtectedBlockType() {
        return "quantumchest";
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        return false;
    }

    static {
        customRenderType = -1;
    }
}

