/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.funkylocomotion.blocks;

import com.google.common.collect.ImmutableList;
import com.mojang.authlib.GameProfile;
import com.rwtema.funkylocomotion.api.IAdvStickyBlock;
import com.rwtema.funkylocomotion.api.IMoveCheck;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileFrameProjector
extends TileEntity
implements IAdvStickyBlock,
IMoveCheck {
    public static final int MAX_RANGE = 16;
    public int range;
    public EnumFacing facing;
    public boolean powered = true;

    public TileFrameProjector(EnumFacing facing) {
        this();
        this.facing = facing;
    }

    public TileFrameProjector() {
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("Facing", this.facing.ordinal());
        tag.func_74768_a("Range", this.range);
        tag.func_74757_a("Powered", this.powered);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        this.facing = EnumFacing.values()[tag.func_74762_e("Facing")];
        this.range = tag.func_74762_e("Range");
        this.powered = tag.func_74767_n("Powered");
        super.func_145839_a(tag);
    }

    @Override
    public Iterable<BlockPos> getBlocksToMove(World world, BlockPos pos) {
        if (!this.powered) {
            return ImmutableList.of();
        }
        final int range = this.range;
        if (range <= 0) {
            return ImmutableList.of();
        }
        final BlockPos center = this.field_174879_c;
        final EnumFacing facing = this.facing;
        if (center == null || facing == null) {
            return ImmutableList.of();
        }
        final EnumFacing.Axis axis = facing.func_176740_k();
        if (range <= 0) {
            return ImmutableList.of();
        }
        return () -> new Iterator<BlockPos>(){
            int r;
            Iterator curIterator;
            {
                this.r = range;
            }

            @Override
            public boolean hasNext() {
                if (this.curIterator != null && this.curIterator.hasNext()) {
                    return true;
                }
                if (this.r == 0) {
                    return false;
                }
                BlockPos a = center.func_177967_a(facing, this.r);
                int dx = axis != EnumFacing.Axis.X ? this.r : 0;
                int dy = axis != EnumFacing.Axis.Y ? this.r : 0;
                int dz = axis != EnumFacing.Axis.Z ? this.r : 0;
                this.curIterator = BlockPos.func_177975_b((BlockPos)a.func_177982_a(-dx, -dy, -dz), (BlockPos)a.func_177982_a(dx, dy, dz)).iterator();
                --this.r;
                return true;
            }

            @Override
            public BlockPos next() {
                return (BlockPos)this.curIterator.next();
            }
        };
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        tag.func_74768_a("Range", this.range);
        if (this.facing != null) {
            tag.func_74768_a("Facing", this.facing.ordinal());
        }
        tag.func_74757_a("Powered", this.powered);
        return tag;
    }

    public void handleUpdateTag(@Nonnull NBTTagCompound tag) {
        this.range = tag.func_74762_e("Range");
        this.facing = EnumFacing.values()[tag.func_74762_e("Facing")];
        this.powered = tag.func_74767_n("Powered");
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }

    @Override
    public EnumActionResult canMove(World worldObj, BlockPos pos, @Nullable GameProfile profile) {
        return this.range == 0 ? EnumActionResult.FAIL : EnumActionResult.PASS;
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public boolean shouldRefresh(World world, BlockPos pos, @Nonnull IBlockState oldState, @Nonnull IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public boolean shouldRenderInPass(int pass) {
        return this.powered && super.shouldRenderInPass(pass);
    }
}

