/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.network.client;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.astro.IAstroCapability;

public class ClientPacketHandlerAstroData
implements IMessageHandler<Packet, IMessage> {
    @SideOnly(value=Side.CLIENT)
    private static void processPacket(Packet message, World world) {
        IAstroCapability cap;
        EntityPlayer player;
        Entity e = world.func_73045_a(message.entityID);
        if (e instanceof EntityPlayer && (player = (EntityPlayer)e).hasCapability(CapabilityList.ASTRO, null) && (cap = (IAstroCapability)player.getCapability(CapabilityList.ASTRO, null)) != null) {
            cap.setDraw(message.draw);
            cap.setBurn(message.burn);
            cap.setSpread(message.spread);
            cap.setDrawTime(message.drawTime);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(Packet message, MessageContext ctx) {
        Minecraft.func_71410_x().func_152344_a(() -> ClientPacketHandlerAstroData.processPacket(message, (World)Minecraft.func_71410_x().field_71441_e));
        return null;
    }

    public static class Packet
    implements IMessage {
        private int entityID;
        private IAstroCapability.ICard draw;
        private IAstroCapability.ICard burn;
        private IAstroCapability.ICard spread;
        private int drawTime;

        public Packet() {
        }

        public Packet(EntityPlayer player) {
            if (player.hasCapability(CapabilityList.ASTRO, null)) {
                IAstroCapability cap = (IAstroCapability)player.getCapability(CapabilityList.ASTRO, null);
                if (cap == null) {
                    return;
                }
                this.entityID = player.func_145782_y();
                this.draw = cap.getDraw();
                this.burn = cap.getBurn();
                this.spread = cap.getSpread();
                this.drawTime = cap.getDrawTime();
            }
        }

        public void fromBytes(ByteBuf stream) {
            this.entityID = stream.readInt();
            this.draw = IAstroCapability.ICard.getCardFromID(stream.readInt());
            this.burn = IAstroCapability.ICard.getCardFromID(stream.readInt());
            this.spread = IAstroCapability.ICard.getCardFromID(stream.readInt());
            this.drawTime = stream.readInt();
        }

        public void toBytes(ByteBuf stream) {
            stream.writeInt(this.entityID);
            stream.writeInt(IAstroCapability.ICard.getCardID(this.draw));
            stream.writeInt(IAstroCapability.ICard.getCardID(this.burn));
            stream.writeInt(IAstroCapability.ICard.getCardID(this.spread));
            stream.writeInt(this.drawTime);
        }
    }
}

