/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.events;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import tamaized.aov.AoV;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.capabilities.astro.IAstroCapability;
import tamaized.aov.common.capabilities.leap.ILeapCapability;
import tamaized.aov.common.capabilities.stun.IStunCapability;
import tamaized.aov.proxy.CommonProxy;
import tamaized.aov.registry.AoVPotions;

public class TickHandler {
    private static void spawnSlowfallParticles(EntityLivingBase living) {
        ILeapCapability cap;
        ILeapCapability iLeapCapability = cap = living.hasCapability(CapabilityList.LEAP, null) ? (ILeapCapability)living.getCapability(CapabilityList.LEAP, null) : null;
        if (cap == null || cap.getLeapDuration() <= 0) {
            return;
        }
        float perc = MathHelper.func_76131_a((float)((float)cap.getLeapDuration() / (float)cap.getMaxLeapDuration()), (float)0.0f, (float)1.0f);
        int bound = 100 - (int)(perc * 100.0f) + 1;
        Vec3d pos = living.func_174791_d();
        for (int i = 0; i < 3; ++i) {
            if (living.field_70170_p.field_73012_v.nextInt(bound > 0 ? bound : 1) > 2) continue;
            double yaw = Math.toRadians(living.field_70761_aq + 63.0f);
            float range = 1.0f;
            float r = living.field_70170_p.field_73012_v.nextFloat() * (1.0f + range) - (0.5f + range);
            Vec3d vec = new Vec3d(-Math.cos(yaw), (double)1.7f, -Math.sin(yaw)).func_178785_b(r);
            vec = pos.func_178787_e(vec).func_72441_c(0.0, (double)(living.field_70170_p.field_73012_v.nextFloat() * 0.5f - 0.5f), 0.0);
            AoV.proxy.spawnParticle(CommonProxy.ParticleType.Feather, living.field_70170_p, vec, new Vec3d(0.0, 0.0, 0.0), 55, 0.1f, 1.5f, -65281);
        }
    }

    @SubscribeEvent
    public void update(TickEvent.PlayerTickEvent e) {
        Object cap;
        if (e.phase == TickEvent.Phase.START) {
            return;
        }
        EntityPlayer player = e.player;
        if (player.func_110143_aJ() <= player.func_110138_aP() / 2.0f && player.func_70660_b(AoVPotions.stalwartPact) != null) {
            player.func_184596_c(AoVPotions.stalwartPact);
            player.func_70690_d(new PotionEffect(MobEffects.field_76444_x, 6000, 2));
            player.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 200, 2));
        }
        if (player.hasCapability(CapabilityList.AOV, null) && (cap = (IAoVCapability)player.getCapability(CapabilityList.AOV, null)) != null) {
            cap.update(player);
        }
        if (player.hasCapability(CapabilityList.ASTRO, null) && (cap = (IAstroCapability)player.getCapability(CapabilityList.ASTRO, null)) != null) {
            cap.update((EntityLivingBase)player);
        }
        if (player.hasCapability(CapabilityList.LEAP, null) && (cap = (ILeapCapability)player.getCapability(CapabilityList.LEAP, null)) != null) {
            cap.update((EntityLivingBase)player);
        }
    }

    @SubscribeEvent
    public void updateLiving(LivingEvent.LivingUpdateEvent e) {
        EntityLivingBase living = e.getEntityLiving();
        if (living.field_70170_p.field_72995_K) {
            TickHandler.spawnSlowfallParticles(living);
        } else {
            ILeapCapability cap = living.hasCapability(CapabilityList.LEAP, null) ? (ILeapCapability)living.getCapability(CapabilityList.LEAP, null) : null;
            PotionEffect pot = living.func_70660_b(AoVPotions.slowFall);
            if (pot == null || cap == null) {
                return;
            }
            if (living.field_70173_aa % 20 == 0) {
                cap.setLeapDuration(pot.func_76459_b());
            }
        }
    }

    @SubscribeEvent
    public void updateEntity(TickEvent.WorldTickEvent e) {
        if (e.phase == TickEvent.Phase.START) {
            return;
        }
        ArrayList list = Lists.newArrayList((Iterable)e.world.field_72996_f);
        for (Entity entity : list) {
            IStunCapability cap;
            if (!(entity instanceof EntityLivingBase) || entity.field_70128_L || (cap = entity.hasCapability(CapabilityList.STUN, null) ? (IStunCapability)entity.getCapability(CapabilityList.STUN, null) : null) == null) continue;
            cap.update((EntityLivingBase)entity);
        }
    }
}

