/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.core.abilities.healer.Cores;

import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.aov.common.helper.ParticleHelper;
import tamaized.aov.proxy.CommonProxy;
import tamaized.aov.registry.AoVDamageSource;
import tamaized.aov.registry.SoundEvents;

public class Burst
extends AbilityBase {
    private static final int charges = 6;
    private static final int range = 20;
    private static final int dmg = 10;

    public Burst() {
        super(new TextComponentTranslation(Burst.getStaticName(), new Object[0]), new TextComponentTranslation("", new Object[0]), new TextComponentTranslation("aov.spells.global.charges", new Object[]{6}), new TextComponentTranslation("aov.spells.global.range", new Object[]{20}), new TextComponentTranslation("aov.spells.global.healing", new Object[]{10}), new TextComponentTranslation("", new Object[0]), new TextComponentTranslation("aov.spells.burst.desc", new Object[0]));
    }

    public static String getStaticName() {
        return "aov.spells.burst.name";
    }

    @Override
    public boolean cast(Ability ability, EntityPlayer caster, EntityLivingBase e) {
        IAoVCapability cap;
        IAoVCapability iAoVCapability = cap = caster.hasCapability(CapabilityList.AOV, null) ? (IAoVCapability)caster.getCapability(CapabilityList.AOV, null) : null;
        if (cap == null) {
            return false;
        }
        ParticleHelper.spawnParticleMesh(ParticleHelper.MeshType.BURST, CommonProxy.ParticleType.Heart, caster.field_70170_p, caster.func_174791_d(), 20, -65281);
        SoundEvents.playMovingSoundOnServer(SoundEvents.burst, (Entity)caster);
        int a = (int)(10.0f * (1.0f + cap.getSpellPower() / 100.0f));
        List list = caster.field_70170_p.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(caster.func_180425_c().func_177982_a(-20, -20, -20), caster.func_180425_c().func_177982_a(20, 20, 20)));
        for (EntityLivingBase entity : list) {
            if (entity.func_70662_br()) {
                entity.func_70097_a(AoVDamageSource.createEntityDamageSource(DamageSource.field_76376_m, (Entity)caster), (float)a);
                continue;
            }
            if (!IAoVCapability.canBenefit((Entity)caster, cap, entity)) continue;
            entity.func_70691_i((float)a);
            entity.func_70651_bq().removeIf(pot -> pot.func_188419_a().func_76398_f());
            cap.addExp((Entity)caster, 20, this);
        }
        return true;
    }

    @Override
    public ResourceLocation getIcon() {
        return new ResourceLocation("aov", "textures/spells/burst.png");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getName() {
        return I18n.func_135052_a((String)Burst.getStaticName(), (Object[])new Object[0]);
    }

    @Override
    public int getCoolDown() {
        return 30;
    }

    @Override
    public int getMaxCharges() {
        return 6;
    }

    @Override
    public int getChargeCost() {
        return 1;
    }

    @Override
    public double getMaxDistance() {
        return 20.0;
    }

    @Override
    public boolean usesInvoke() {
        return false;
    }
}

