/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.core.abilities.defender;

import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.aov.common.helper.ParticleHelper;
import tamaized.aov.proxy.CommonProxy;
import tamaized.aov.registry.AoVPotions;
import tamaized.aov.registry.SoundEvents;

public class StalwartPact
extends AbilityBase {
    private static final String name = "aov.spells.stalwart.name";
    private static final int charges = 3;
    private static final double range = 3.0;

    public StalwartPact() {
        super(new TextComponentTranslation(name, new Object[0]), new TextComponentTranslation("", new Object[0]), new TextComponentTranslation("aov.spells.global.charges", new Object[]{3}), new TextComponentTranslation("aov.spells.global.range", new Object[]{3.0}), new TextComponentTranslation("", new Object[0]), new TextComponentTranslation("aov.spells.stalwart.desc", new Object[0]));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getName() {
        return I18n.func_135052_a((String)name, (Object[])new Object[0]);
    }

    @Override
    public double getMaxDistance() {
        return 3.0;
    }

    @Override
    public int getMaxCharges() {
        return 3;
    }

    @Override
    public boolean usesInvoke() {
        return true;
    }

    protected int getParticleColor() {
        return -1;
    }

    @Override
    public boolean cast(Ability ability, EntityPlayer caster, EntityLivingBase e) {
        IAoVCapability cap;
        IAoVCapability iAoVCapability = cap = caster.hasCapability(CapabilityList.AOV, null) ? (IAoVCapability)caster.getCapability(CapabilityList.AOV, null) : null;
        if (cap == null) {
            return false;
        }
        if (cap.getInvokeMass()) {
            this.castAsMass((EntityLivingBase)caster, cap);
        } else if (e == null) {
            this.addPotionEffects((EntityLivingBase)caster);
        } else if (IAoVCapability.canBenefit((Entity)caster, cap, e)) {
            this.addPotionEffects(e);
        }
        SoundEvents.playMovingSoundOnServer(SoundEvents.cast_2, (Entity)caster);
        cap.addExp((Entity)caster, 20, this);
        return true;
    }

    private void addPotionEffects(EntityLivingBase entity) {
        entity.func_70690_d(new PotionEffect(AoVPotions.stalwartPact, 6000));
    }

    private void castAsMass(EntityLivingBase caster, IAoVCapability cap) {
        int range = (int)(this.getMaxDistance() * 2.0);
        ParticleHelper.spawnParticleMesh(ParticleHelper.MeshType.BURST, CommonProxy.ParticleType.Fluff, caster.field_70170_p, caster.func_174791_d(), range, this.getParticleColor());
        List list = caster.field_70170_p.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(caster.func_180425_c().func_177982_a(-range, -range, -range), caster.func_180425_c().func_177982_a(range, range, range)));
        for (EntityLivingBase entity : list) {
            if (!IAoVCapability.canBenefit((Entity)caster, cap, entity)) continue;
            this.addPotionEffects(entity);
            cap.addExp((Entity)caster, 20, this);
        }
    }

    @Override
    public int getChargeCost() {
        return 1;
    }

    @Override
    public int getCoolDown() {
        return 12;
    }

    @Override
    public ResourceLocation getIcon() {
        return new ResourceLocation("aov", "textures/spells/stalwart.png");
    }
}

