/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.core.abilities.astro;

import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.aov.common.entity.EntitySpellVanillaParticles;
import tamaized.aov.registry.SoundEvents;

public class TimeDilation
extends AbilityBase {
    private static final ResourceLocation icon = new ResourceLocation("aov", "textures/spells/timedilation.png");
    private static final int charges = -1;
    private static final int distance = 10;

    public TimeDilation() {
        super(new TextComponentTranslation(TimeDilation.getStaticName(), new Object[0]), new TextComponentTranslation("", new Object[0]), new TextComponentTranslation("aov.spells.global.range", new Object[]{10}), new TextComponentTranslation("", new Object[0]), new TextComponentTranslation("aov.spells.timedilation.desc", new Object[0]));
    }

    public static String getStaticName() {
        return "aov.spells.timedilation.name";
    }

    @Override
    public ResourceLocation getIcon() {
        return icon;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getName() {
        return I18n.func_135052_a((String)TimeDilation.getStaticName(), (Object[])new Object[0]);
    }

    @Override
    public int getCoolDown() {
        return 90;
    }

    @Override
    public int getMaxCharges() {
        return -1;
    }

    @Override
    public int getChargeCost() {
        return 0;
    }

    @Override
    public double getMaxDistance() {
        return 10.0;
    }

    @Override
    public boolean usesInvoke() {
        return false;
    }

    @Override
    public boolean cast(Ability ability, EntityPlayer caster, EntityLivingBase target) {
        if (!caster.hasCapability(CapabilityList.AOV, null)) {
            return false;
        }
        IAoVCapability aov = (IAoVCapability)caster.getCapability(CapabilityList.AOV, null);
        EntityPlayer entity = target != null && aov != null && IAoVCapability.canBenefit((Entity)caster, aov, target) ? target : caster;
        for (PotionEffect effect : entity.func_70651_bq()) {
            if (effect.func_188419_a().func_76398_f()) continue;
            entity.func_70690_d(new PotionEffect(effect.func_188419_a(), effect.func_76459_b() * 2, effect.func_76458_c(), effect.func_82720_e(), effect.func_188418_e()));
        }
        if (!entity.field_70170_p.field_72995_K) {
            SoundEvents.playMovingSoundOnServer(SoundEvents.timedilation, (Entity)entity);
            entity.field_70170_p.func_72838_d((Entity)new EntitySpellVanillaParticles(entity.field_70170_p, (Entity)entity, EnumParticleTypes.VILLAGER_HAPPY, 3));
            if (aov != null) {
                aov.addExp((Entity)caster, 20, ability.getAbility());
            }
        }
        return true;
    }
}

