/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.capabilities;

import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.capabilities.astro.IAstroCapability;
import tamaized.aov.common.capabilities.leap.ILeapCapability;
import tamaized.aov.common.capabilities.stun.IStunCapability;

public class CapabilityList {
    @CapabilityInject(value=IAoVCapability.class)
    public static final Capability<IAoVCapability> AOV = null;
    @CapabilityInject(value=IAstroCapability.class)
    public static final Capability<IAstroCapability> ASTRO = null;
    @CapabilityInject(value=IStunCapability.class)
    public static final Capability<IStunCapability> STUN = null;
    @CapabilityInject(value=ILeapCapability.class)
    public static final Capability<ILeapCapability> LEAP = null;

    @SubscribeEvent
    public void attachCapabilityEntity(AttachCapabilitiesEvent<Entity> e) {
        if (e.getObject() instanceof EntityPlayer) {
            e.addCapability(IAoVCapability.ID, (ICapabilityProvider)new ICapabilitySerializable<NBTTagCompound>(){
                IAoVCapability inst = (IAoVCapability)AOV.getDefaultInstance();

                public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
                    return capability == AOV;
                }

                public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
                    return (T)(capability == AOV ? AOV.cast((Object)this.inst) : null);
                }

                public NBTTagCompound serializeNBT() {
                    return (NBTTagCompound)AOV.getStorage().writeNBT(AOV, (Object)this.inst, null);
                }

                public void deserializeNBT(NBTTagCompound nbt) {
                    AOV.getStorage().readNBT(AOV, (Object)this.inst, null, (NBTBase)nbt);
                }
            });
            e.addCapability(IAstroCapability.ID, (ICapabilityProvider)new ICapabilitySerializable<NBTTagCompound>(){
                IAstroCapability inst = (IAstroCapability)ASTRO.getDefaultInstance();

                public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
                    return capability == ASTRO;
                }

                public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
                    return (T)(capability == ASTRO ? ASTRO.cast((Object)this.inst) : null);
                }

                public NBTTagCompound serializeNBT() {
                    return (NBTTagCompound)ASTRO.getStorage().writeNBT(ASTRO, (Object)this.inst, null);
                }

                public void deserializeNBT(NBTTagCompound nbt) {
                    ASTRO.getStorage().readNBT(ASTRO, (Object)this.inst, null, (NBTBase)nbt);
                }
            });
        }
        if (e.getObject() instanceof EntityLivingBase) {
            e.addCapability(IStunCapability.ID, (ICapabilityProvider)new ICapabilitySerializable<NBTTagCompound>(){
                IStunCapability inst = (IStunCapability)STUN.getDefaultInstance();

                public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
                    return capability == STUN;
                }

                public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
                    return (T)(capability == STUN ? STUN.cast((Object)this.inst) : null);
                }

                public NBTTagCompound serializeNBT() {
                    return (NBTTagCompound)STUN.getStorage().writeNBT(STUN, (Object)this.inst, null);
                }

                public void deserializeNBT(NBTTagCompound nbt) {
                    STUN.getStorage().readNBT(STUN, (Object)this.inst, null, (NBTBase)nbt);
                }
            });
        }
        if (e.getObject() instanceof EntityLivingBase) {
            e.addCapability(ILeapCapability.ID, (ICapabilityProvider)new ICapabilitySerializable<NBTTagCompound>(){
                ILeapCapability inst = (ILeapCapability)LEAP.getDefaultInstance();

                public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
                    return capability == LEAP;
                }

                public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
                    return (T)(capability == LEAP ? LEAP.cast((Object)this.inst) : null);
                }

                public NBTTagCompound serializeNBT() {
                    return (NBTTagCompound)LEAP.getStorage().writeNBT(LEAP, (Object)this.inst, null);
                }

                public void deserializeNBT(NBTTagCompound nbt) {
                    LEAP.getStorage().readNBT(LEAP, (Object)this.inst, null, (NBTBase)nbt);
                }
            });
        }
    }

    @SubscribeEvent
    public void updateClone(PlayerEvent.Clone e) {
        IAoVCapability oldcap;
        EntityPlayer oldPlayer = e.getOriginal();
        EntityPlayer newPlayer = e.getEntityPlayer();
        IAoVCapability newcap = newPlayer.hasCapability(AOV, null) ? (IAoVCapability)newPlayer.getCapability(AOV, null) : null;
        IAoVCapability iAoVCapability = oldcap = oldPlayer.hasCapability(AOV, null) ? (IAoVCapability)oldPlayer.getCapability(AOV, null) : null;
        if (newcap != null && oldcap != null) {
            newcap.copyFrom(oldcap);
        }
    }

    @SubscribeEvent
    public void onJoin(EntityJoinWorldEvent e) {
        IAstroCapability astro;
        IAoVCapability cap;
        IAoVCapability iAoVCapability = cap = e.getEntity().hasCapability(AOV, null) ? (IAoVCapability)e.getEntity().getCapability(AOV, null) : null;
        if (cap != null) {
            cap.markDirty();
            cap.setLoaded();
        }
        IAstroCapability iAstroCapability = astro = e.getEntity().hasCapability(ASTRO, null) ? (IAstroCapability)e.getEntity().getCapability(ASTRO, null) : null;
        if (astro != null) {
            astro.markDirty();
        }
    }
}

