/*
 * Decompiled with CFR 0.152.
 */
package jackyy.exchangers.handler;

import jackyy.exchangers.client.Keys;
import jackyy.exchangers.helper.ChatHelper;
import jackyy.exchangers.helper.StringHelper;
import jackyy.exchangers.registry.ModConfig;
import jackyy.exchangers.util.IExchanger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ExchangerHandler
extends Item
implements IExchanger {
    public static final int MODE_1X1 = 0;
    public static final int MODE_3X3 = 1;
    public static final int MODE_5X5 = 2;
    public static final int MODE_7X7 = 3;
    public static final int MODE_9X9 = 4;
    public static final int MODE_11X11 = 5;
    public static final int MODE_13X13 = 6;
    public static final int MODE_15X15 = 7;
    public static final int MODE_17X17 = 8;
    public static final int MODE_19X19 = 9;
    public static final int MODE_21X21 = 10;
    public static final int MODE_23X23 = 11;
    public static final int MODE_25X25 = 12;
    public static final String[] modeSwitchList = new String[]{"1x1", "3x3", "5x5", "7x7", "9x9", "11x11", "13x13", "15x15", "17x17", "19x19", "21x21", "23x23", "25x25"};

    public static void setDefaultTagCompound(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74778_a("block", "minecraft:air");
            compound.func_74768_a("meta", 0);
            compound.func_74768_a("mode", 0);
            compound.func_74757_a("forceDropItems", false);
            stack.func_77982_d(compound);
        } else if (!stack.func_77978_p().func_74764_b("block")) {
            stack.func_77978_p().func_74778_a("block", "minecraft:air");
        } else if (!stack.func_77978_p().func_74764_b("meta")) {
            stack.func_77978_p().func_74768_a("meta", 0);
        } else if (!stack.func_77978_p().func_74764_b("mode")) {
            stack.func_77978_p().func_74768_a("mode", 0);
        } else if (!stack.func_77978_p().func_74764_b("forceDropItems")) {
            stack.func_77978_p().func_74757_a("forceDropItems", false);
        }
    }

    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        if (!StringHelper.isShiftKeyDown()) {
            tooltip.add(StringHelper.getShiftText());
        }
        ExchangerHandler.setDefaultTagCompound(stack);
        NBTTagCompound compound = stack.func_77978_p();
        String id = compound.func_74779_i("block");
        if (StringHelper.isShiftKeyDown()) {
            if (id.equals("minecraft:air")) {
                tooltip.add(StringHelper.localize("tooltip.no_selected_block", new Object[0]));
            } else {
                Block block = Block.func_149684_b((String)id);
                int meta = compound.func_74762_e("meta");
                tooltip.add(StringHelper.localize("tooltip.selected_block", new Object[0]) + " " + ExchangerHandler.getBlockName(block, meta));
            }
            tooltip.add(StringHelper.localize("tooltip.current_range", new Object[0]) + " " + modeSwitchList[compound.func_74762_e("mode")]);
            tooltip.add(StringHelper.localize("tooltip.max_range", new Object[0]) + " " + modeSwitchList[this.getMaxRange()]);
            tooltip.add(StringHelper.localize("tooltip.max_harvest_level", new Object[0]) + " " + StringHelper.formatHarvestLevel(this.getHarvestLevel()));
            if (ModConfig.misc.doExchangersSilkTouch) {
                tooltip.add(StringHelper.localize("tooltip.silk_touch.on", new Object[0]));
            } else {
                tooltip.add(StringHelper.localize("tooltip.silk_touch.off", new Object[0]));
            }
            if (compound.func_74767_n("forceDropItems")) {
                tooltip.add(StringHelper.localize("tooltip.force_drop_items.on", new Object[0]) + " " + TextFormatting.GRAY + "(" + TextFormatting.GREEN + Keys.FORCE_DROP_ITEMS_KEY.getDisplayName() + TextFormatting.GRAY + ")");
            } else {
                tooltip.add(StringHelper.localize("tooltip.force_drop_items.off", new Object[0]) + " " + TextFormatting.GRAY + "(" + TextFormatting.GREEN + Keys.FORCE_DROP_ITEMS_KEY.getDisplayName() + TextFormatting.GRAY + ")");
            }
            tooltip.add(StringHelper.localize("tooltip.shift1", new Object[0]));
            tooltip.add(StringHelper.localize("tooltip.shift2", new Object[0]));
            tooltip.add(StringHelper.localize("tooltip.shift3", new Object[0]) + " (" + TextFormatting.GREEN + Keys.MODE_KEY.getDisplayName() + TextFormatting.GRAY + ")");
            tooltip.add(StringHelper.getTierText(this.getTier()));
        }
    }

    private int getPerBlockEnergy(ItemStack stack) {
        int level;
        if (ModConfig.misc.unbreakingPoweredExchangers && new Random().nextInt(2 + (level = MathHelper.func_76125_a((int)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)stack), (int)0, (int)10))) >= 2) {
            return 0;
        }
        return this.getPerBlockUse();
    }

    public void switchMode(EntityPlayer player, ItemStack stack) {
        ExchangerHandler.setDefaultTagCompound(stack);
        int modeSwitch = stack.func_77978_p().func_74762_e("mode");
        modeSwitch = player.func_70093_af() ? --modeSwitch : ++modeSwitch;
        ItemStack heldItem = player.func_184614_ca();
        if (!heldItem.func_190926_b()) {
            if (modeSwitch > this.getMaxRange()) {
                modeSwitch = 0;
            } else if (modeSwitch < 0) {
                modeSwitch = this.getMaxRange();
            }
        }
        stack.func_77978_p().func_74768_a("mode", modeSwitch);
    }

    public void toggleForceDropItems(EntityPlayer player, ItemStack stack) {
        ExchangerHandler.setDefaultTagCompound(stack);
        boolean toggle = stack.func_77978_p().func_74767_n("forceDropItems");
        ItemStack heldItem = player.func_184614_ca();
        if (!heldItem.func_190926_b()) {
            toggle = !toggle;
        }
        stack.func_77978_p().func_74757_a("forceDropItems", toggle);
        ChatHelper.msgPlayer(player, toggle ? "msg.force_drop_items.on" : "msg.force_drop_items.off");
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            if (player.func_70093_af()) {
                this.selectBlock(player.func_184614_ca(), player, world, pos);
            } else {
                this.placeBlock(player.func_184614_ca(), player, world, pos, side);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    public static boolean isWhitelisted(World world, BlockPos pos) {
        for (String block : ModConfig.misc.blocksWhitelist) {
            if (!world.func_180495_p(pos).func_177230_c().getRegistryName().equals((Object)new ResourceLocation(block))) continue;
            return true;
        }
        return world.func_180495_p(pos).func_177230_c().getRegistryName().func_110624_b().equals("tconstruct");
    }

    public static boolean isBlacklisted(World world, BlockPos pos) {
        for (String block : ModConfig.misc.blocksBlacklist) {
            if (!world.func_180495_p(pos).func_177230_c().getRegistryName().equals((Object)new ResourceLocation(block))) continue;
            return true;
        }
        return false;
    }

    private boolean isSpecial(Block block) {
        return block instanceof BlockLog || block instanceof BlockTrapDoor || block instanceof BlockDoor || block instanceof BlockFenceGate;
    }

    private boolean isMoreSpecial(Block block) {
        return block instanceof BlockTorch;
    }

    private void placeBlock(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        String id = tagCompound.func_74779_i("block");
        Block block = Block.func_149684_b((String)id);
        int meta = tagCompound.func_74762_e("meta");
        IBlockState oldState = world.func_180495_p(pos);
        Block oldblock = oldState.func_177230_c();
        int oldmeta = oldblock.func_176201_c(oldState);
        float blockHardness = oldblock.func_176195_g(oldState, world, pos);
        if (id.equals("minecraft:air")) {
            return;
        }
        if (block == oldblock && meta == oldmeta) {
            return;
        }
        if (world.func_175625_s(pos) != null && !ExchangerHandler.isWhitelisted(world, pos)) {
            ChatHelper.msgPlayer(player, "error.invalid_block.te");
            return;
        }
        if (ExchangerHandler.isBlacklisted(world, pos)) {
            ChatHelper.msgPlayer(player, "error.blacklisted");
            return;
        }
        if (!this.isCreative() && blockHardness < -0.1f) {
            ChatHelper.msgPlayer(player, "error.invalid_block.unbreakable");
            return;
        }
        if (!this.isCreative() && this.isPowered() && stack.func_77978_p().func_74762_e("Energy") < this.getPerBlockEnergy(stack)) {
            ChatHelper.msgPlayer(player, "error.out_of_power");
            return;
        }
        if (!this.isCreative() && this.getHarvestLevel() < oldblock.getHarvestLevel(oldState)) {
            ChatHelper.msgPlayer(player, "error.low_harvest_level");
            return;
        }
        Set<BlockPos> coordinates = ExchangerHandler.findSuitableBlocks(stack, world, side, pos, oldblock, oldmeta);
        boolean notEnough = false;
        world.captureBlockSnapshots = false;
        for (BlockPos coordinate : coordinates) {
            BlockEvent.PlaceEvent event = new BlockEvent.PlaceEvent(BlockSnapshot.getBlockSnapshot((World)world, (BlockPos)coordinate, (int)3), Blocks.field_150350_a.func_176223_P(), player, player.func_184600_cs());
            world.func_180501_a(coordinate, block.func_176203_a(meta), 3);
            if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
                if (this.consumeItemInInventory(Item.func_150898_a((Block)block), meta, player.field_71071_by, player)) {
                    if (!player.field_71075_bZ.field_75098_d && !this.isCreative()) {
                        if (ModConfig.misc.doExchangersSilkTouch || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0) {
                            ItemStack oldblockItem = oldblock.func_185473_a(world, pos, oldState);
                            ExchangerHandler.giveItem(world, player, oldblockItem);
                        } else {
                            int fortuneLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
                            List oldblockItems = oldblock.getDrops((IBlockAccess)world, pos, oldState, fortuneLevel);
                            for (ItemStack oldblockItem : oldblockItems) {
                                ExchangerHandler.giveItem(world, player, oldblockItem);
                            }
                        }
                        if (!this.isPowered()) {
                            stack.func_77972_a(1, (EntityLivingBase)player);
                        } else if (stack.func_77978_p().func_74762_e("Energy") >= this.getPerBlockEnergy(stack)) {
                            stack.func_77978_p().func_74768_a("Energy", stack.func_77978_p().func_74762_e("Energy") - this.getPerBlockEnergy(stack));
                        }
                        player.field_71070_bA.func_75142_b();
                    }
                    world.func_184148_a(null, (double)coordinate.func_177958_n(), (double)coordinate.func_177956_o(), (double)coordinate.func_177952_p(), SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 0.1f, 1.0f);
                    continue;
                }
                world.restoringBlockSnapshots = true;
                event.getBlockSnapshot().restore(true);
                world.restoringBlockSnapshots = false;
                notEnough = true;
                continue;
            }
            world.restoringBlockSnapshots = true;
            event.getBlockSnapshot().restore(true);
            world.restoringBlockSnapshots = false;
            ChatHelper.msgPlayer(player, "error.event_cancelled");
        }
        if (notEnough) {
            ChatHelper.msgPlayer(player, "error.out_of_block");
        }
        world.captureBlockSnapshots = true;
    }

    private void selectBlock(ItemStack stack, EntityPlayer player, World world, BlockPos pos) {
        ExchangerHandler.setDefaultTagCompound(stack);
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        int meta = this.isSpecial(block) ? block.func_176223_P().func_177230_c().func_176201_c(block.func_176223_P()) : (this.isMoreSpecial(block) ? 0 : block.func_176201_c(state));
        NBTTagCompound tagCompound = ExchangerHandler.getTagCompound(stack);
        String name = ExchangerHandler.getBlockName(block, meta);
        float blockHardness = block.func_176195_g(state, world, pos);
        if (name == null) {
            ChatHelper.msgPlayer(player, "error.invalid_block.null");
            return;
        }
        if (world.func_175625_s(pos) != null && !ExchangerHandler.isWhitelisted(world, pos)) {
            ChatHelper.msgPlayer(player, "error.invalid_block.te");
            return;
        }
        if (ExchangerHandler.isBlacklisted(world, pos)) {
            ChatHelper.msgPlayer(player, "error.blacklisted");
            return;
        }
        if (!this.isCreative() && blockHardness < -0.1f) {
            ChatHelper.msgPlayer(player, "error.invalid_block.unbreakable");
            return;
        }
        String id = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).toString();
        tagCompound.func_74778_a("block", id);
        tagCompound.func_74768_a("meta", meta);
    }

    protected static Set<BlockPos> findSuitableBlocks(ItemStack stack, World world, EnumFacing sideHit, BlockPos pos, Block centerBlock, int centerMeta) {
        HashSet<BlockPos> coordinates = new HashSet<BlockPos>();
        int mode = stack.func_77978_p().func_74762_e("mode");
        ArrayList<BlockPos> possibleLocs = new ArrayList<BlockPos>();
        possibleLocs.add(pos);
        int index = 0;
        do {
            BlockPos currentPos = (BlockPos)possibleLocs.get(index);
            ExchangerHandler.checkAndAddBlock(world, currentPos, centerBlock, centerMeta, coordinates);
            switch (sideHit) {
                case UP: {
                    ExchangerHandler.getConnectedBlocksUD(possibleLocs, world, currentPos, pos, centerBlock, centerMeta, mode, true);
                    break;
                }
                case DOWN: {
                    ExchangerHandler.getConnectedBlocksUD(possibleLocs, world, currentPos, pos, centerBlock, centerMeta, mode, false);
                    break;
                }
                case SOUTH: {
                    ExchangerHandler.getConnectedBlocksNS(possibleLocs, world, currentPos, pos, centerBlock, centerMeta, mode, true);
                    break;
                }
                case NORTH: {
                    ExchangerHandler.getConnectedBlocksNS(possibleLocs, world, currentPos, pos, centerBlock, centerMeta, mode, false);
                    break;
                }
                case EAST: {
                    ExchangerHandler.getConnectedBlocksEW(possibleLocs, world, currentPos, pos, centerBlock, centerMeta, mode, true);
                    break;
                }
                case WEST: {
                    ExchangerHandler.getConnectedBlocksEW(possibleLocs, world, currentPos, pos, centerBlock, centerMeta, mode, false);
                }
            }
        } while (++index < possibleLocs.size());
        return coordinates;
    }

    private static void checkAndAddBlock(World world, BlockPos pos, Block centerBlock, int centerMeta, Set<BlockPos> coordinates) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == centerBlock && state.func_177230_c().func_176201_c(state) == centerMeta) {
            coordinates.add(pos);
        }
    }

    private static boolean checkBlock(World world, BlockPos pos, Block centerBlock, int centerMeta) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c() == centerBlock && state.func_177230_c().func_176201_c(state) == centerMeta;
    }

    private static void getConnectedBlocksUD(List<BlockPos> possibleLocs, World world, BlockPos currentPos, BlockPos centerPos, Block centerBlock, int centerMeta, int mode, boolean side) {
        for (int x = -1; x < 2; ++x) {
            for (int y = -1; y < 2; ++y) {
                BlockPos newPos = currentPos.func_177982_a(x, 0, y);
                if (ExchangerHandler.isLocationContained(possibleLocs, newPos) || newPos.func_177958_n() > centerPos.func_177958_n() + mode || newPos.func_177958_n() < centerPos.func_177958_n() - mode || newPos.func_177952_p() > centerPos.func_177952_p() + mode || newPos.func_177952_p() < centerPos.func_177952_p() - mode || world.func_180495_p(newPos.func_177982_a(0, side ? 1 : -1, 0)).func_185913_b() || !ExchangerHandler.checkBlock(world, newPos, centerBlock, centerMeta)) continue;
                possibleLocs.add(newPos);
            }
        }
    }

    private static void getConnectedBlocksNS(List<BlockPos> possibleLocs, World world, BlockPos currentPos, BlockPos centerPos, Block centerBlock, int centerMeta, int mode, boolean side) {
        for (int x = -1; x < 2; ++x) {
            for (int y = -1; y < 2; ++y) {
                BlockPos newPos = currentPos.func_177982_a(x, y, 0);
                if (ExchangerHandler.isLocationContained(possibleLocs, newPos) || newPos.func_177958_n() > centerPos.func_177958_n() + mode || newPos.func_177958_n() < centerPos.func_177958_n() - mode || newPos.func_177956_o() > centerPos.func_177956_o() + mode || newPos.func_177956_o() < centerPos.func_177956_o() - mode || world.func_180495_p(newPos.func_177982_a(0, 0, side ? 1 : -1)).func_185913_b() || !ExchangerHandler.checkBlock(world, newPos, centerBlock, centerMeta)) continue;
                possibleLocs.add(newPos);
            }
        }
    }

    private static void getConnectedBlocksEW(List<BlockPos> possibleLocs, World world, BlockPos currentPos, BlockPos centerPos, Block centerBlock, int centerMeta, int mode, boolean side) {
        for (int x = -1; x < 2; ++x) {
            for (int y = -1; y < 2; ++y) {
                BlockPos newPos = currentPos.func_177982_a(0, x, y);
                if (ExchangerHandler.isLocationContained(possibleLocs, newPos) || newPos.func_177956_o() > centerPos.func_177956_o() + mode || newPos.func_177956_o() < centerPos.func_177956_o() - mode || newPos.func_177952_p() > centerPos.func_177952_p() + mode || newPos.func_177952_p() < centerPos.func_177952_p() - mode || world.func_180495_p(newPos.func_177982_a(side ? 1 : -1, 0, 0)).func_185913_b() || !ExchangerHandler.checkBlock(world, newPos, centerBlock, centerMeta)) continue;
                possibleLocs.add(newPos);
            }
        }
    }

    private static boolean isLocationContained(List<BlockPos> possibleLocs, BlockPos toFind) {
        for (BlockPos pos : possibleLocs) {
            if (pos.func_177958_n() != toFind.func_177958_n() || pos.func_177956_o() != toFind.func_177956_o() || pos.func_177952_p() != toFind.func_177952_p()) continue;
            return true;
        }
        return false;
    }

    private boolean consumeItemInInventory(Item item, int meta, InventoryPlayer playerInv, EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d || this.isCreative()) {
            return true;
        }
        int i = ExchangerHandler.findItem(item, meta, (IInventory)playerInv);
        if (i < 0) {
            IItemHandler inv = ExchangerHandler.findItemHolder((IInventory)playerInv);
            if (inv == null) {
                return false;
            }
            i = ExchangerHandler.findItemInContainer(item, meta, inv);
            if (i < 0) {
                return false;
            }
            ItemStack extracted = inv.extractItem(i, 1, false);
            return !extracted.func_190926_b();
        }
        playerInv.func_70298_a(i, 1);
        return true;
    }

    private static int findItem(Item item, int meta, IInventory inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77973_b() != item || meta != stack.func_77952_i()) continue;
            return i;
        }
        return -1;
    }

    private static int findItemInContainer(Item item, int meta, IItemHandler inv) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.func_190926_b() || stack.func_77973_b() != item || meta != stack.func_77952_i()) continue;
            return i;
        }
        return -1;
    }

    private static IItemHandler findItemHolder(IInventory inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || !stack.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) continue;
            return (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        }
        return null;
    }

    private static void giveItem(World world, EntityPlayer player, ItemStack oldStack) {
        EntityItem entityItem = new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, oldStack);
        if (player.func_184614_ca().func_77978_p().func_74767_n("forceDropItems")) {
            world.func_72838_d((Entity)entityItem);
        } else if (!player.field_71071_by.func_70441_a(oldStack)) {
            world.func_72838_d((Entity)entityItem);
        }
    }

    protected static NBTTagCompound getTagCompound(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            stack.func_77982_d(tagCompound);
        }
        return tagCompound;
    }

    private static String getBlockName(Block block, int meta) {
        ItemStack stack = new ItemStack(block, 1, meta);
        return stack.func_82833_r();
    }
}

