/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.integration;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.recipe.BasicManyToOneRecipe;
import crazypants.enderio.base.recipe.IManyToOneRecipe;
import crazypants.enderio.base.recipe.Recipe;
import crazypants.enderio.base.recipe.RecipeOutput;
import crazypants.enderio.base.recipe.alloysmelter.AlloyRecipeManager;
import crazypants.enderio.base.recipe.sagmill.SagMillRecipeManager;
import java.util.Iterator;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import wanion.lib.common.FixedSizeList;
import wanion.unidict.UniDict;
import wanion.unidict.integration.AbstractIntegrationThread;

final class EnderIOIntegration
extends AbstractIntegrationThread {
    EnderIOIntegration() {
        super("Ender IO");
    }

    public String call() {
        try {
            this.fixAlloySmelterRecipes();
            this.fixSagMillRecipes();
        }
        catch (Exception e) {
            UniDict.getLogger().error(this.threadName + e);
        }
        return this.threadName + "Some inanimate objects appear to have used ender pearls. They all disappeared, how this is possible?";
    }

    private void fixOreDictPreferences() {
    }

    private void fixAlloySmelterRecipes() {
        NNList alloySmelterRecipes = AlloyRecipeManager.getInstance().getRecipes();
        FixedSizeList newAlloySmelterRecipes = new FixedSizeList(alloySmelterRecipes.size());
        Iterator alloySmelterRecipesIterator = alloySmelterRecipes.iterator();
        while (alloySmelterRecipesIterator.hasNext()) {
            IManyToOneRecipe alloySmelterRecipe = (IManyToOneRecipe)alloySmelterRecipesIterator.next();
            ItemStack correctOutput = this.resourceHandler.getMainItemStack(alloySmelterRecipe.getOutput());
            if (correctOutput == alloySmelterRecipe.getOutput()) continue;
            RecipeOutput recipeOutput = alloySmelterRecipe.getOutputs()[0];
            newAlloySmelterRecipes.add(new BasicManyToOneRecipe(new Recipe(new RecipeOutput(correctOutput, recipeOutput.getChance(), recipeOutput.getExperiance()), alloySmelterRecipe.getEnergyRequired(), alloySmelterRecipe.getBonusType(), alloySmelterRecipe.getInputs())));
            alloySmelterRecipesIterator.remove();
        }
        alloySmelterRecipes.addAll(newAlloySmelterRecipes);
    }

    private void fixSagMillRecipes() {
        NNList sagMillRecipes = SagMillRecipeManager.getInstance().getRecipes();
        FixedSizeList newSagMillRecipes = new FixedSizeList(sagMillRecipes.size());
        newSagMillRecipes.addAll(sagMillRecipes.stream().map(this::sagMillRecipe).collect(Collectors.toList()));
        sagMillRecipes.clear();
        sagMillRecipes.addAll(newSagMillRecipes);
    }

    private Recipe sagMillRecipe(Recipe sagMillRecipe) {
        int outputSize = sagMillRecipe.getOutputs().length;
        RecipeOutput[] output = new RecipeOutput[outputSize];
        for (int i = 0; i < outputSize; ++i) {
            RecipeOutput oldOutput = sagMillRecipe.getOutputs()[i];
            output[i] = new RecipeOutput(this.resourceHandler.getMainItemStack(oldOutput.getOutput()), oldOutput.getChance(), oldOutput.getExperiance());
        }
        return new Recipe(sagMillRecipe.getInputs(), output, sagMillRecipe.getEnergyRequired(), sagMillRecipe.getBonusType());
    }
}

