/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common.item;

import com.google.common.base.Strings;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.core.client.Localization;
import shetiphian.core.common.Function;
import shetiphian.core.common.IColored;
import shetiphian.core.common.item.ItemBlockMulti;
import shetiphian.endertanks.Values;
import shetiphian.endertanks.common.block.BlockEnderTank;
import shetiphian.endertanks.common.item.EnderFluidHandlerItemStack;
import shetiphian.endertanks.common.misc.StackHelper;
import shetiphian.endertanks.common.misc.TankInfoHelper;
import shetiphian.endertanks.common.tileentity.TileEntityEnderTank;

public class ItemBlockEnderTank
extends ItemBlockMulti
implements IColored {
    public ItemBlockEnderTank(Block block) {
        super(block, "BlockEnderTank", Values.nameMapper);
        this.field_77787_bX = true;
    }

    public void getSubItems(NonNullList<ItemStack> list) {
        for (String code : StackHelper.BASE_CODES) {
            list.add((Object)StackHelper.create((Item)this, code, null));
        }
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState state) {
        if (state.func_177230_c() != Values.blockEnderTank) {
            return false;
        }
        if (!Function.setBlock((World)world, (BlockPos)pos, (IBlockState)(state = state.func_177226_a((IProperty)BlockEnderTank.FACING, (Comparable)side.func_176734_d())), (boolean)true) || stack.func_77952_i() < 0) {
            return false;
        }
        ItemStack personal = StackHelper.getPersonalItem(stack);
        if (stack.func_77952_i() > 2) {
            stack.func_77964_b(personal != null ? (StackHelper.getOwnerID(stack).startsWith("#") ? 2 : 1) : 0);
        }
        if (world.func_180495_p(pos).func_177230_c() == Values.blockEnderTank) {
            Values.blockEnderTank.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof TileEntityEnderTank)) {
                return false;
            }
            String code = StackHelper.getCode(stack);
            while (code.length() < 3) {
                code = "0" + code;
            }
            ((TileEntityEnderTank)te).setCode(code);
            if (personal != null) {
                ((TileEntityEnderTank)te).setOwner(StackHelper.getOwnerName(stack), StackHelper.getOwnerID(stack), personal);
            }
        }
        return true;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return stack == null ? null : new EnderFluidHandlerItemStack(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advancedTooltips) {
        tooltip.add(" " + Localization.get((String)"info.endertanks.tank.code.txt") + " " + StackHelper.getCode(stack));
        String owner = TankInfoHelper.formatTankOwner(StackHelper.getOwnerName(stack));
        if (!Strings.isNullOrEmpty((String)owner)) {
            tooltip.add(owner);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFor(IColored.Data data, int index) {
        if (index > 0 && index < 4 && data.stack != null) {
            int value = MathHelper.func_76125_a((int)Integer.parseInt("" + StackHelper.getCode(data.stack).charAt(index - 1), 16), (int)0, (int)16);
            return Values.colorValues[value];
        }
        return 0xFFFFFF;
    }

    protected void addToNameMap() {
        this.add(0, "", "endertank_public", "public");
        this.add(1, "", "endertank_private", "private");
        this.add(2, "", "endertank_team", "team");
    }
}

