/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.attachments.cover;

import cofh.thermaldynamics.init.TDItems;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.StreamSupport;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CoverHelper {
    private static final Logger logger = LogManager.getLogger((String)"ThermalDynamics");
    private static final boolean DEBUG_BLACKLIST = false;
    private static Map<String, ItemStack> lookupMap;
    private static Map<ResourceLocation, Integer> coverBlacklist;

    public static void loadCoverBlacklist(File configFolder) {
        File file = new File(configFolder, "cover_blacklist.json");
        if (!file.exists()) {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            try {
                file.createNewFile();
                FileUtils.copyInputStreamToFile((InputStream)CoverHelper.class.getResourceAsStream("/assets/thermaldynamics/cover_blacklist_default.json"), (File)file);
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
        try {
            JsonParser parser = new JsonParser();
            JsonReader reader = new JsonReader((Reader)new FileReader(file));
            reader.setLenient(true);
            JsonElement element = parser.parse(reader);
            if (!element.isJsonArray()) {
                throw new JsonSyntaxException("Root element must be a JsonArray!");
            }
            JsonArray array = element.getAsJsonArray();
            for (JsonElement e : array) {
                if (!e.isJsonObject()) {
                    throw new JsonSyntaxException("Expected JsonObject, was " + JsonUtils.func_151222_d((JsonElement)e));
                }
                JsonObject entry = e.getAsJsonObject();
                ResourceLocation loc = new ResourceLocation(JsonUtils.func_151200_h((JsonObject)entry, (String)"block"));
                if (!entry.has("meta")) {
                    throw new JsonSyntaxException("Missing required element 'meta'.");
                }
                if (!JsonUtils.func_151201_f((JsonObject)entry, (String)"meta")) {
                    throw new JsonSyntaxException("Expected boolean or integer, was " + JsonUtils.func_151222_d((JsonElement)entry.get("meta")));
                }
                JsonPrimitive p = entry.getAsJsonPrimitive("meta");
                if (!(p.isBoolean() && !p.getAsBoolean() || p.isNumber())) {
                    throw new JsonSyntaxException("Expected false or integer, was " + p.getAsString());
                }
                int meta = p.isBoolean() ? -1 : p.getAsInt();
                coverBlacklist.put(loc, meta);
            }
        }
        catch (JsonParseException | IOException e) {
            throw new RuntimeException("Unable to read cover blacklist json!", e);
        }
    }

    public static Map<String, ItemStack> getStateLookup() {
        if (lookupMap == null) {
            lookupMap = new LinkedHashMap<String, ItemStack>();
            NonNullList stacks = NonNullList.func_191196_a();
            StreamSupport.stream(ForgeRegistries.ITEMS.spliterator(), false).filter(item -> item instanceof ItemBlock).sorted(Comparator.comparingInt(arg_0 -> ((RegistryNamespaced)Item.field_150901_e).func_148757_b(arg_0))).forEachOrdered(item -> item.func_150895_a(CreativeTabs.field_78027_g, stacks));
            for (ItemStack stack : stacks) {
                int blockMeta;
                ItemBlock item2;
                Block block;
                if (!(stack.func_77973_b() instanceof ItemBlock) || !CoverHelper.isValid(block = (item2 = (ItemBlock)stack.func_77973_b()).func_179223_d(), blockMeta = item2.func_77647_b(stack.func_77952_i()))) continue;
                lookupMap.put(block.getRegistryName() + " >> " + blockMeta, stack);
            }
        }
        return lookupMap;
    }

    public static ItemStack lookupItemForm(IBlockState state) {
        String lookup = state.func_177230_c().getRegistryName() + " >> " + state.func_177230_c().func_176201_c(state);
        return CoverHelper.getStateLookup().getOrDefault(lookup, ItemStack.field_190927_a);
    }

    public static boolean isValid(ItemStack stack) {
        try {
            return stack.func_77973_b() instanceof ItemBlock && CoverHelper.isValid(((ItemBlock)stack.func_77973_b()).func_179223_d(), stack.func_77973_b().func_77647_b(stack.func_77952_i()));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isValid(Block block, int meta) {
        try {
            int m;
            if (block == null) {
                return false;
            }
            if (coverBlacklist.containsKey(block.getRegistryName()) && ((m = coverBlacklist.get(block.getRegistryName()).intValue()) == -1 || m == meta)) {
                return false;
            }
            IBlockState state = block.func_176203_a(meta);
            return !block.hasTileEntity(state) && !block.func_149716_u();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static ItemStack getCoverStack(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemBlock) {
            return CoverHelper.getCoverStack(((ItemBlock)stack.func_77973_b()).func_179223_d(), stack.func_77973_b().func_77647_b(stack.func_77952_i()));
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getCoverStack(IBlockState state) {
        return CoverHelper.getCoverStack(state.func_177230_c(), state.func_177230_c().func_176201_c(state));
    }

    public static ItemStack getCoverStack(Block block, int meta) {
        ResourceLocation blockString = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block);
        if (blockString == null) {
            return ItemStack.field_190927_a;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("Block", blockString.toString());
        tag.func_74774_a("Meta", (byte)meta);
        ItemStack itemStack = new ItemStack((Item)TDItems.itemCover);
        itemStack.func_77982_d(tag);
        return itemStack;
    }

    public static ItemStack getCoverItemStack(ItemStack stack, boolean removeInvalidData) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null || !nbt.func_150297_b("Meta", 1) || !nbt.func_150297_b("Block", 8)) {
            return ItemStack.field_190927_a;
        }
        byte meta = nbt.func_74771_c("Meta");
        Block block = Block.func_149684_b((String)nbt.func_74779_i("Block"));
        if (block == Blocks.field_150350_a || meta < 0 || meta >= 16 || !CoverHelper.isValid(block, meta)) {
            if (removeInvalidData) {
                nbt.func_82580_o("Meta");
                nbt.func_82580_o("Block");
                if (nbt.func_82582_d()) {
                    stack.func_77982_d(null);
                }
            }
            return ItemStack.field_190927_a;
        }
        return new ItemStack(block, 1, (int)meta);
    }

    static {
        coverBlacklist = new HashMap<ResourceLocation, Integer>();
    }
}

