/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.dimensions.world.terraingen;

import java.util.Random;
import mcjty.lostcities.dimensions.world.LostCityChunkGenerator;
import mcjty.lostcities.dimensions.world.terraingen.LostCitiesTerrainGenerator;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.NoiseGeneratorSimplex;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.ChunkGeneratorEvent;
import net.minecraftforge.event.terraingen.InitNoiseGensEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;

public class IslandTerrainGenerator {
    private LostCityChunkGenerator provider;
    private double[] densities;
    private NoiseGeneratorOctaves noiseGen1;
    private NoiseGeneratorOctaves noiseGen2;
    private NoiseGeneratorOctaves noiseGen3;
    private NoiseGeneratorOctaves noiseGen4;
    private NoiseGeneratorOctaves noiseGen5;
    private NoiseGeneratorPerlin surfaceNoise;
    private double[] stoneNoise = new double[256];
    private double[] noiseData1;
    private double[] noiseData2;
    private double[] noiseData3;
    private double[] noiseData4;
    private double[] noiseData5;
    private NoiseGeneratorSimplex islandNoise;
    public static final int NORMAL = 0;
    public static final int CHAOTIC = 1;
    public static final int PLATEAUS = 3;
    public static final int ISLANDS = 4;
    private final int type;
    private final double topFactor;
    private final double botFactor;
    private final int bottomOffset;

    public IslandTerrainGenerator(int type) {
        this.type = type;
        switch (type) {
            case 3: {
                this.topFactor = -1000.0;
                this.botFactor = -300.0;
                break;
            }
            case 4: {
                this.topFactor = -600.0;
                this.botFactor = -200.0;
                break;
            }
            default: {
                this.topFactor = -3000.0;
                this.botFactor = -30.0;
            }
        }
        this.bottomOffset = type == 3 ? 14 : (type == 4 ? 11 : 8);
    }

    public void setup(World world, LostCityChunkGenerator provider) {
        this.provider = provider;
        this.noiseGen1 = new NoiseGeneratorOctaves(provider.rand, 16);
        this.noiseGen2 = new NoiseGeneratorOctaves(provider.rand, 16);
        this.noiseGen3 = new NoiseGeneratorOctaves(provider.rand, 8);
        this.noiseGen4 = new NoiseGeneratorOctaves(provider.rand, 10);
        this.noiseGen5 = new NoiseGeneratorOctaves(provider.rand, 16);
        this.islandNoise = new NoiseGeneratorSimplex(provider.rand);
        this.surfaceNoise = new NoiseGeneratorPerlin(provider.rand, 4);
        InitNoiseGensEvent.ContextEnd ctx = new InitNoiseGensEvent.ContextEnd(this.noiseGen1, this.noiseGen2, this.noiseGen3, this.noiseGen4, this.noiseGen5, this.islandNoise);
        ctx = (InitNoiseGensEvent.ContextEnd)TerrainGen.getModdedNoiseGenerators((World)world, (Random)provider.rand, (InitNoiseGensEvent.Context)ctx);
        this.noiseGen1 = ctx.getLPerlin1();
        this.noiseGen2 = ctx.getLPerlin2();
        this.noiseGen3 = ctx.getPerlin();
        this.noiseGen4 = ctx.getDepth();
        this.noiseGen5 = ctx.getScale();
        this.islandNoise = ctx.getIsland();
    }

    private double[] initializeNoiseField(double[] densities, int chunkX2, int chunkY2, int chunkZ2, int sizeX, int sizeY, int sizeZ) {
        ChunkGeneratorEvent.InitNoiseField event = new ChunkGeneratorEvent.InitNoiseField((IChunkGenerator)this.provider, densities, chunkX2, chunkY2, chunkZ2, sizeX, sizeY, sizeZ);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DENY) {
            return event.getNoisefield();
        }
        if (densities == null) {
            densities = new double[sizeX * sizeY * sizeZ];
        }
        boolean shallowOcean = false;
        double d0 = 684.412;
        double d1 = 684.412;
        this.noiseData4 = this.noiseGen4.func_76305_a(this.noiseData4, chunkX2, chunkZ2, sizeX, sizeZ, 1.121, 1.121, 0.5);
        this.noiseData5 = this.noiseGen5.func_76305_a(this.noiseData5, chunkX2, chunkZ2, sizeX, sizeZ, 200.0, 200.0, 0.5);
        this.noiseData1 = this.noiseGen3.func_76304_a(this.noiseData1, chunkX2, chunkY2, chunkZ2, sizeX, sizeY, sizeZ, (d0 *= 2.0) / 80.0, d1 / 160.0, d0 / 80.0);
        this.noiseData2 = this.noiseGen1.func_76304_a(this.noiseData2, chunkX2, chunkY2, chunkZ2, sizeX, sizeY, sizeZ, d0, d1, d0);
        this.noiseData3 = this.noiseGen2.func_76304_a(this.noiseData3, chunkX2, chunkY2, chunkZ2, sizeX, sizeY, sizeZ, d0, d1, d0);
        int k1 = 0;
        Random random = new Random(chunkX2 * 13 + chunkY2 * 157 + chunkZ2 * 13883);
        random.nextFloat();
        for (int x = 0; x < sizeX; ++x) {
            for (int z = 0; z < sizeZ; ++z) {
                float f2 = 0.0f;
                switch (this.type) {
                    case 0: {
                        float xx = (float)(x + chunkX2) / 1.0f;
                        float zz = (float)(z + chunkZ2) / 1.0f;
                        f2 = 100.0f - (float)Math.sqrt(xx * xx + zz * zz) * 8.0f;
                        if (f2 > 80.0f) {
                            f2 = 80.0f;
                            break;
                        }
                        if (!(f2 < -100.0f)) break;
                        f2 = -100.0f;
                        break;
                    }
                    case 1: {
                        f2 = 0.0f;
                        break;
                    }
                    case 3: {
                        f2 = -5.0f;
                        break;
                    }
                    case 4: {
                        f2 = -20.0f;
                    }
                }
                for (int y = 0; y < sizeY; ++y) {
                    double d10;
                    double d5 = 0.0;
                    double d7 = this.noiseData2[k1] / 512.0;
                    double d8 = this.noiseData3[k1] / 512.0;
                    double d9 = (this.noiseData1[k1] / 10.0 + 1.0) / 2.0;
                    d5 = d9 < 0.0 ? d7 : (d9 > 1.0 ? d8 : d7 + (d8 - d7) * d9);
                    d5 -= 8.0;
                    d5 += (double)f2;
                    int b0 = 2;
                    if (y > sizeY / 2 - b0) {
                        d10 = (float)(y - (sizeY / 2 - b0)) / 64.0f;
                        if (d10 < 0.0) {
                            d10 = 0.0;
                        } else if (d10 > 1.0) {
                            d10 = 1.0;
                        }
                        d5 = d5 * (1.0 - d10) + this.topFactor * d10;
                    }
                    if (y < (b0 = this.bottomOffset)) {
                        d10 = (float)(b0 - y) / ((float)b0 - 1.0f);
                        d5 = d5 * (1.0 - d10) + this.botFactor * d10;
                    }
                    densities[k1] = shallowOcean && y == 0 ? 100.0 : (shallowOcean && y == 1 ? (double)(50.0f + random.nextFloat() * 200.0f) : d5);
                    ++k1;
                }
            }
        }
        return densities;
    }

    public void generate(int chunkX, int chunkZ, ChunkPrimer primer) {
        char baseBlock = LostCitiesTerrainGenerator.baseChar;
        char air = LostCitiesTerrainGenerator.airChar;
        int b0 = 2;
        int k = b0 + 1;
        int b1 = 33;
        int l = b0 + 1;
        this.densities = this.initializeNoiseField(this.densities, chunkX * b0, 0, chunkZ * b0, k, b1, l);
        for (int x2 = 0; x2 < b0; ++x2) {
            for (int z2 = 0; z2 < b0; ++z2) {
                for (int height32 = 0; height32 < 32; ++height32) {
                    double d0 = 0.25;
                    double d1 = this.densities[((x2 + 0) * l + z2 + 0) * b1 + height32 + 0];
                    double d2 = this.densities[((x2 + 0) * l + z2 + 1) * b1 + height32 + 0];
                    double d3 = this.densities[((x2 + 1) * l + z2 + 0) * b1 + height32 + 0];
                    double d4 = this.densities[((x2 + 1) * l + z2 + 1) * b1 + height32 + 0];
                    double d5 = (this.densities[((x2 + 0) * l + z2 + 0) * b1 + height32 + 1] - d1) * d0;
                    double d6 = (this.densities[((x2 + 0) * l + z2 + 1) * b1 + height32 + 1] - d2) * d0;
                    double d7 = (this.densities[((x2 + 1) * l + z2 + 0) * b1 + height32 + 1] - d3) * d0;
                    double d8 = (this.densities[((x2 + 1) * l + z2 + 1) * b1 + height32 + 1] - d4) * d0;
                    for (int h = 0; h < 8; ++h) {
                        double d9 = 0.125;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        int height = height32 * 4 + h;
                        for (int x = 0; x < 8; ++x) {
                            int index = x + x2 * 8 << 12 | 0 + z2 * 8 << 8 | height;
                            int maxheight = 256;
                            double d14 = 0.125;
                            double d15 = d10;
                            double d16 = (d11 - d10) * d14;
                            for (int z = 0; z < 8; ++z) {
                                primer.field_177860_a[index] = d15 > 0.0 ? baseBlock : air;
                                index += maxheight;
                                d15 += d16;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    public void replaceBlocksForBiome(int chunkX, int chunkZ, ChunkPrimer primer, Biome[] Biomes2) {
        double d0 = 0.03125;
        this.stoneNoise = this.surfaceNoise.func_151599_a(this.stoneNoise, (double)(chunkX * 16), (double)(chunkZ * 16), 16, 16, 0.0625, 0.0625, 1.0);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                Biome Biome2 = Biomes2[z + x * 16];
                this.genBiomeTerrain(Biome2, primer, chunkX * 16 + x, chunkZ * 16 + z, this.stoneNoise[z + x * 16]);
            }
        }
    }

    public final void genBiomeTerrain(Biome biome, ChunkPrimer primer, int x, int z, double noise) {
        char topBlock;
        char air = LostCitiesTerrainGenerator.airChar;
        char baseBlock = LostCitiesTerrainGenerator.baseChar;
        char baseLiquid = air;
        int topLevel = this.provider.getProfile().GROUNDLEVEL;
        char fillerBlock = (char)Block.field_176229_d.func_148747_b((Object)biome.field_76753_B);
        char block = topBlock = (char)Block.field_176229_d.func_148747_b((Object)biome.field_76752_A);
        char block1 = fillerBlock;
        int k = -1;
        int l = (int)(noise / 3.0 + 3.0 + this.provider.rand.nextDouble() * 0.25);
        int cx = x & 0xF;
        int cz = z & 0xF;
        int bottomIndex = (cz * 16 + cx) * 256;
        for (int height = 255; height >= 0; --height) {
            int index = bottomIndex + height;
            if (height <= 2) {
                primer.field_177860_a[index] = air;
                continue;
            }
            char currentBlock = primer.field_177860_a[index];
            if (currentBlock == LostCitiesTerrainGenerator.bedrockChar && height <= 12) {
                primer.field_177860_a[index] = air;
                k = -1;
                continue;
            }
            if (currentBlock != air) {
                if (currentBlock != baseBlock) continue;
                if (k == -1) {
                    if (l <= 0) {
                        block = air;
                        block1 = baseBlock;
                    } else if (height >= topLevel - 4 && height <= topLevel + 1) {
                        block = topBlock;
                        block1 = fillerBlock;
                    }
                    if (height < topLevel && block == air) {
                        block = biome.func_180626_a(new BlockPos(x, height, z)) < 0.15f ? (char)Block.field_176229_d.func_148747_b((Object)Blocks.field_150432_aD.func_176223_P()) : baseBlock;
                    }
                    k = l;
                    if (height >= topLevel - 1) {
                        primer.field_177860_a[index] = block;
                        continue;
                    }
                    if (height < topLevel - 6 - l) {
                        block = air;
                        block1 = baseBlock;
                        primer.field_177860_a[index] = fillerBlock;
                        continue;
                    }
                    primer.field_177860_a[index] = block1;
                    continue;
                }
                if (k <= 0) continue;
                primer.field_177860_a[index] = block1;
                if (--k != 0 || block1 != Block.field_176229_d.func_148747_b((Object)Blocks.field_150354_m.func_176223_P())) continue;
                k = this.provider.rand.nextInt(4) + Math.max(0, height - topLevel);
                block1 = (char)Block.field_176229_d.func_148747_b((Object)Blocks.field_150322_A.func_176223_P());
                continue;
            }
            k = -1;
        }
    }
}

