/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.dimensions.world;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import mcjty.lostcities.config.LostCityConfiguration;
import mcjty.lostcities.config.LostCityProfile;
import mcjty.lostcities.dimensions.ModDimensions;
import mcjty.lostcities.dimensions.world.LostCityChunkGenerator;
import mcjty.lostcities.dimensions.world.LostWorldType;
import mcjty.lostcities.dimensions.world.LostWorldTypeBOP;
import mcjty.lostcities.network.PacketHandler;
import mcjty.lostcities.network.PacketRequestProfile;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class WorldTypeTools {
    private static Map<Integer, LostCityProfile> profileMap = new HashMap<Integer, LostCityProfile>();
    private static Map<Integer, WeakReference<LostCityChunkGenerator>> chunkGeneratorMap = new HashMap<Integer, WeakReference<LostCityChunkGenerator>>();
    private static long clientTimeout = -1L;

    public static void cleanCache() {
        profileMap.clear();
        clientTimeout = -1L;
    }

    public static void cleanChunkGeneratorMap() {
        chunkGeneratorMap.clear();
    }

    public static void registerChunkGenerator(Integer dimension, LostCityChunkGenerator chunkGenerator) {
        chunkGeneratorMap.put(dimension, new WeakReference<LostCityChunkGenerator>(chunkGenerator));
    }

    @Nullable
    public static LostCityChunkGenerator getChunkGenerator(int dimension) {
        if (chunkGeneratorMap.containsKey(dimension)) {
            WeakReference<LostCityChunkGenerator> reference = chunkGeneratorMap.get(dimension);
            return (LostCityChunkGenerator)reference.get();
        }
        return null;
    }

    public static LostCityProfile getProfile(World world) {
        if (profileMap.containsKey(world.field_73011_w.getDimension())) {
            return profileMap.get(world.field_73011_w.getDimension());
        }
        if (world instanceof WorldServer) {
            LostCityProfile profile = WorldTypeTools.getProfileOnServer(world);
            profileMap.put(world.field_73011_w.getDimension(), profile);
            return profile;
        }
        long time = System.currentTimeMillis();
        if (clientTimeout == -1L || clientTimeout + 2000L > time) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketRequestProfile(world.field_73011_w.getDimension()));
            clientTimeout = time;
        }
        if (ModDimensions.dimensionProfileMap.keySet().contains(world.field_73011_w.getDimension())) {
            System.out.println("YES: world.provider.getDimension() = " + world.field_73011_w.getDimension());
            return LostCityConfiguration.profiles.get(ModDimensions.dimensionProfileMap.get(world.field_73011_w.getDimension()));
        }
        System.out.println("NO: world.provider.getDimension() = " + world.field_73011_w.getDimension());
        return LostCityConfiguration.profiles.get(LostCityConfiguration.DEFAULT_PROFILE);
    }

    public static void setProfileFromServer(int dimension, String profileName) {
        System.out.println("FROM SERVER: profile = " + profileName + " for " + dimension);
        LostCityProfile profile = LostCityConfiguration.profiles.get(profileName);
        if (profile == null) {
            throw new RuntimeException("Cannot find profile '" + profileName + "' that the server is using! Please make client configs for Lost Cities compatible");
        }
        profileMap.put(dimension, profile);
    }

    @Nullable
    public static LostCityChunkGenerator getLostCityChunkGenerator(World world) {
        return WorldTypeTools.getChunkGenerator(world.field_73011_w.getDimension());
    }

    public static boolean isLostCities(World world) {
        if (ModDimensions.dimensionProfileMap.containsKey(world.field_73011_w.getDimension())) {
            return true;
        }
        if (world.field_73011_w.getDimension() != 0) {
            return false;
        }
        return world.func_175624_G() instanceof LostWorldType || world.func_175624_G() instanceof LostWorldTypeBOP;
    }

    private static LostCityProfile getProfileOnServer(World world) {
        LostCityProfile p;
        LostCityProfile profile;
        if (ModDimensions.dimensionProfileMap.containsKey(world.field_73011_w.getDimension()) && (profile = LostCityConfiguration.profiles.get(ModDimensions.dimensionProfileMap.get(world.field_73011_w.getDimension()))) != null) {
            return profile;
        }
        String generatorOptions = world.func_72912_H().func_82571_y();
        if (generatorOptions == null || generatorOptions.trim().isEmpty()) {
            p = LostCityConfiguration.profiles.get(LostCityConfiguration.DEFAULT_PROFILE);
            if (p == null) {
                throw new RuntimeException("Something went wrong! Profile '" + LostCityConfiguration.DEFAULT_PROFILE + "' is missing!");
            }
        } else {
            JsonParser parser = new JsonParser();
            JsonElement parsed = parser.parse(generatorOptions);
            String profileName = parsed.getAsJsonObject().has("profile") ? parsed.getAsJsonObject().get("profile").getAsString() : LostCityConfiguration.DEFAULT_PROFILE;
            p = LostCityConfiguration.profiles.get(profileName);
            if (p == null) {
                throw new RuntimeException("Something went wrong! Profile '" + profileName + "' is missing!");
            }
        }
        return p;
    }
}

