/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.dimensions.world;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import mcjty.lostcities.LostCities;
import mcjty.lostcities.config.BiomeSelectionStrategy;
import mcjty.lostcities.config.LostCityConfiguration;
import net.minecraft.init.Biomes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class BiomeTranslator {
    private final String[] allowedBiomeFactors;
    private final String[] manualBiomeMappings;
    private final BiomeSelectionStrategy strategy;
    private final Map<String, Biome> translationMap = new HashMap<String, Biome>();

    public BiomeTranslator(String[] allowedBiomeFactors, String[] manualBiomeMappings, BiomeSelectionStrategy strategy) {
        this.allowedBiomeFactors = allowedBiomeFactors;
        this.manualBiomeMappings = manualBiomeMappings;
        this.strategy = strategy;
    }

    private static List<Pair<String, Biome>> parseManualBiomes(String[] manualBiomeMappings) {
        ArrayList<Pair<String, Biome>> mapping = new ArrayList<Pair<String, Biome>>();
        for (String s : manualBiomeMappings) {
            String[] split = StringUtils.split((String)s, (char)'=');
            String biomeId = split[0];
            String destBiomeId = split[1];
            Biome biome = BiomeTranslator.findBiome(biomeId);
            Biome destBiome = BiomeTranslator.findBiome(destBiomeId);
            if (biome != null && destBiome != null) {
                mapping.add((Pair<String, Biome>)Pair.of((Object)biome.field_76791_y, (Object)destBiome));
                continue;
            }
            if (biome == null) {
                LostCities.logger.warn("Could not find biome '" + biomeId + "'!");
                continue;
            }
            if (destBiome != null) continue;
            LostCities.logger.warn("Could not find biome '" + destBiomeId + "'!");
        }
        return mapping;
    }

    public static List<Pair<Float, Biome>> parseBiomes(String[] allowedBiomeFactors) {
        ArrayList<Pair<Float, Biome>> biomes = new ArrayList<Pair<Float, Biome>>();
        for (String s : allowedBiomeFactors) {
            String[] split = StringUtils.split((String)s, (char)'=');
            float f = Float.parseFloat(split[1]);
            String biomeId = split[0];
            Biome biome = BiomeTranslator.findBiome(biomeId);
            if (biome != null) {
                biomes.add((Pair<Float, Biome>)Pair.of((Object)Float.valueOf(f), (Object)biome));
                continue;
            }
            LostCities.logger.warn("Could not find biome '" + biomeId + "'!");
        }
        return biomes;
    }

    private static Biome findBiome(String biomeId) {
        Biome biome = (Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation(biomeId));
        if (biome == null) {
            for (Biome b : Biome.field_185377_q) {
                ResourceLocation registryName = b.getRegistryName();
                if (registryName == null || !biomeId.equals(registryName.func_110623_a())) continue;
                biome = b;
                break;
            }
        }
        return biome;
    }

    private void dumpTranslationMap() {
        LostCities.logger.info("Dumping biome mapping");
        for (Map.Entry<String, Biome> entry : this.translationMap.entrySet()) {
            ResourceLocation biomeKey = ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)entry.getValue());
            LostCities.logger.info("biome: " + entry.getKey() + " -> " + entry.getValue().field_76791_y + " (" + biomeKey.toString() + ")");
        }
    }

    private void generateTranslationMapOriginal(List<Pair<Float, Biome>> biomes) {
        for (Biome biome : ForgeRegistries.BIOMES) {
            Biome bestFit = null;
            double bestDist = 1.0E9;
            for (Pair<Float, Biome> pair : biomes) {
                Biome b = (Biome)pair.getRight();
                double distance = BiomeTranslator.calculateBiomeDistance(biome, b) * (double)((Float)pair.getLeft()).floatValue();
                if (!(distance < bestDist)) continue;
                bestDist = distance;
                bestFit = b;
            }
            if (bestFit == null) {
                bestFit = Biomes.field_76772_c;
            }
            this.translationMap.put(biome.field_76791_y, bestFit);
        }
    }

    private void generateTranslationMapNG(List<Pair<Float, Biome>> biomes, float samenessFactor) {
        for (Biome biome : ForgeRegistries.BIOMES) {
            ArrayList<Biome> bestFit = new ArrayList<Biome>();
            double bestDist = 1.0E9;
            for (Pair<Float, Biome> pair : biomes) {
                Biome b = (Biome)pair.getRight();
                double distance = BiomeTranslator.calculateBiomeDistance(biome, b) * (double)((Float)pair.getLeft()).floatValue();
                if (Math.abs(distance - bestDist) < (double)samenessFactor) {
                    bestFit.add(b);
                    continue;
                }
                if (!(distance < bestDist)) continue;
                bestDist = distance;
                bestFit.clear();
                bestFit.add(b);
            }
            if (bestFit.isEmpty()) {
                bestFit.add(Biomes.field_76772_c);
            }
            if (bestFit.size() == 1) {
                this.translationMap.put(biome.field_76791_y, (Biome)bestFit.get(0));
                continue;
            }
            long seed = biome.field_76791_y.hashCode();
            Random random = new Random(seed);
            random.nextFloat();
            random.nextFloat();
            this.translationMap.put(biome.field_76791_y, (Biome)bestFit.get(random.nextInt(bestFit.size())));
        }
    }

    public Biome translate(Biome biome) {
        if (this.translationMap.isEmpty()) {
            List<Pair<Float, Biome>> biomes = BiomeTranslator.parseBiomes(this.allowedBiomeFactors);
            switch (this.strategy) {
                case ORIGINAL: {
                    this.generateTranslationMapOriginal(biomes);
                    break;
                }
                case RANDOMIZED: {
                    this.generateTranslationMapNG(biomes, 0.2f);
                    break;
                }
                case VARIED: {
                    this.generateTranslationMapNG(biomes, 1.0f);
                }
            }
            List<Pair<String, Biome>> manualMappings = BiomeTranslator.parseManualBiomes(this.manualBiomeMappings);
            for (Pair<String, Biome> pair : manualMappings) {
                this.translationMap.put((String)pair.getKey(), (Biome)pair.getValue());
            }
            if (LostCityConfiguration.DEBUG) {
                this.dumpTranslationMap();
            }
        }
        return this.translationMap.get(biome.field_76791_y);
    }

    private static double calculateBiomeDistance(Biome a, Biome b) {
        if (a == b) {
            return -1000.0;
        }
        float dr = a.func_76727_i() - b.func_76727_i();
        float dt = a.func_185353_n() - b.func_185353_n();
        float dv = a.func_185360_m() - b.func_185360_m();
        float dh = a.func_185355_j() - b.func_185355_j();
        return Math.sqrt(dr * dr + dt * dt + dv * dv + dh * dh);
    }
}

