/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.recipe;

import java.util.Collections;
import java.util.Comparator;
import java.util.Random;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.everlastingabilities.ability.AbilityHelpers;
import org.cyclops.everlastingabilities.item.ItemAbilityTotem;
import org.cyclops.everlastingabilities.item.ItemAbilityTotemConfig;

public class TotemRecycleRecipe
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    private final Random rand = new Random();
    private long seed = this.rand.nextLong();

    public boolean func_77569_a(InventoryCrafting invCrafting, World world) {
        int inputCount = 0;
        for (int i = 0; i < invCrafting.func_70302_i_(); ++i) {
            ItemStack slot = invCrafting.func_70301_a(i);
            if (slot.func_190926_b()) continue;
            if (slot.func_77973_b() instanceof ItemAbilityTotem) {
                ++inputCount;
                continue;
            }
            return false;
        }
        return inputCount == ItemAbilityTotemConfig.totemCraftingCount;
    }

    public ItemStack func_77572_b(InventoryCrafting invCrafting) {
        this.rand.setSeed(this.seed);
        int inputTargetIndex = this.rand.nextInt(ItemAbilityTotemConfig.totemCraftingCount);
        NonNullList sortedStacks = NonNullList.func_191196_a();
        for (int i = 0; i < invCrafting.func_70302_i_(); ++i) {
            ItemStack slot = invCrafting.func_70301_a(i);
            if (slot.func_190926_b()) continue;
            if (slot.func_77973_b() instanceof ItemAbilityTotem) {
                sortedStacks.add((Object)invCrafting.func_70301_a(i));
                continue;
            }
            return ItemStack.field_190927_a;
        }
        Collections.sort(sortedStacks, Comparator.comparingInt(ItemStackHelpers::getItemStackHashCode));
        if (inputTargetIndex >= sortedStacks.size()) {
            return ItemStack.field_190927_a;
        }
        EnumRarity rarity = ItemAbilityTotem.getInstance().func_77613_e((ItemStack)sortedStacks.get(inputTargetIndex));
        if (this.rand.nextInt(100) < ItemAbilityTotemConfig.totemCraftingRarityIncreasePercent) {
            EnumRarity newRarity = rarity;
            while (!AbilityHelpers.hasRarityAbilities(newRarity = newRarity.ordinal() < EnumRarity.EPIC.ordinal() ? EnumRarity.values()[newRarity.ordinal() + 1] : rarity)) {
            }
            rarity = newRarity;
        }
        this.rand.setSeed(sortedStacks.stream().mapToInt(ItemStackHelpers::getItemStackHashCode).sum());
        return AbilityHelpers.getRandomTotem(rarity, this.rand).get();
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= ItemAbilityTotemConfig.totemCraftingCount;
    }

    public ItemStack func_77571_b() {
        return new ItemStack((Item)ItemAbilityTotem.getInstance());
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        ++this.seed;
        return ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)inv);
    }
}

