/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.network.packet;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.everlastingabilities.ability.AbilityTypes;
import org.cyclops.everlastingabilities.api.Ability;
import org.cyclops.everlastingabilities.api.IAbilityType;
import org.cyclops.everlastingabilities.inventory.container.ContainerAbilityContainer;

public class MoveAbilityPacket
extends PacketCodec {
    @CodecField
    private String abilityName;
    @CodecField
    private int abilityLevel;
    @CodecField
    private int movement;

    public MoveAbilityPacket() {
    }

    public MoveAbilityPacket(Ability ability, Movement movement) {
        this.abilityName = ability.getAbilityType().getUnlocalizedName();
        this.abilityLevel = ability.getLevel();
        this.movement = movement.ordinal();
    }

    public boolean isAsync() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void actionClient(World world, EntityPlayer player) {
    }

    public void actionServer(World world, EntityPlayerMP player) {
        if (player.field_71070_bA instanceof ContainerAbilityContainer) {
            ContainerAbilityContainer container = (ContainerAbilityContainer)player.field_71070_bA;
            IAbilityType abilityType = AbilityTypes.REGISTRY.getAbilityType(this.abilityName);
            if (abilityType != null) {
                Ability ability = new Ability(abilityType, this.abilityLevel);
                if (this.movement == Movement.FROM_PLAYER.ordinal()) {
                    container.moveFromPlayer(ability);
                } else {
                    container.moveToPlayer(ability);
                }
            }
        }
    }

    public static enum Movement {
        TO_PLAYER,
        FROM_PLAYER;

    }
}

