/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.ability;

import com.google.common.base.Predicate;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import org.cyclops.everlastingabilities.GeneralConfig;
import org.cyclops.everlastingabilities.ability.AbilityTypeDefault;

public class AbilityTypeMagnetize
extends AbilityTypeDefault {
    private static final int TICK_MODULUS = 1;

    public AbilityTypeMagnetize(String id, int rarity, int maxLevel, int baseXpPerLevel) {
        super(id, rarity, maxLevel, baseXpPerLevel);
    }

    @Override
    public void onTick(EntityPlayer player, int level) {
        World world = player.field_70170_p;
        if (!world.field_72995_K && !player.func_70093_af() && player.field_70170_p.func_72820_D() % 1L == 0L) {
            double x = player.field_70165_t;
            double y = player.field_70163_u;
            double z = player.field_70161_v;
            int area = level * 2;
            AxisAlignedBB box = new AxisAlignedBB(x, y, z, x, y, z).func_72314_b((double)area, (double)area, (double)area);
            List entities = world.func_175674_a((Entity)player, box, (Predicate)new Predicate<Entity>(){

                public boolean apply(Entity entity) {
                    return entity instanceof EntityItem || GeneralConfig.magnetizeMoveXp && entity instanceof EntityXPOrb;
                }
            });
            for (Entity moveEntity : entities) {
                if ((!(moveEntity instanceof EntityItem) || ((EntityItem)moveEntity).func_174874_s() || !this.canKineticateItem(((EntityItem)moveEntity).func_92059_d())) && !(moveEntity instanceof EntityXPOrb)) continue;
                double dx = moveEntity.field_70165_t - x;
                double dy = moveEntity.field_70163_u - y + 1.0;
                double dz = moveEntity.field_70161_v - z;
                double strength = -1.0;
                double d = MathHelper.func_76133_a((double)(dx * dx + dy * dy + dz * dz));
                if (!(d > 0.5)) continue;
                double m = 1.0 / (2.0 * Math.max(1.0, d));
                dx *= m;
                dy *= m;
                dz *= m;
                if (moveEntity instanceof EntityItem && d < 5.0) {
                    ((EntityItem)moveEntity).func_174867_a(0);
                }
                moveEntity.field_70159_w = dx * strength;
                moveEntity.field_70181_x = dy * strength;
                moveEntity.field_70179_y = dz * strength;
                if (!moveEntity.field_70123_F) continue;
                moveEntity.field_70181_x = 0.3;
            }
        }
    }

    protected boolean canKineticateItem(ItemStack entityItem) {
        return true;
    }
}

