/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.command.CommandMod;
import org.cyclops.cyclopscore.config.ConfigHandler;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfigReference;
import org.cyclops.cyclopscore.helper.CraftingHelpers;
import org.cyclops.cyclopscore.helper.EntityHelpers;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.obfuscation.ObfuscationHelpers;
import org.cyclops.cyclopscore.init.IObjectReference;
import org.cyclops.cyclopscore.init.IRegistry;
import org.cyclops.cyclopscore.init.ItemCreativeTab;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.init.ModBaseVersionable;
import org.cyclops.cyclopscore.init.RecipeHandler;
import org.cyclops.cyclopscore.modcompat.capabilities.ICapabilityConstructor;
import org.cyclops.cyclopscore.modcompat.capabilities.SerializableCapabilityProvider;
import org.cyclops.cyclopscore.modcompat.capabilities.SimpleCapabilityConstructor;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.cyclopscore.network.packet.SendPlayerCapabilitiesPacket;
import org.cyclops.cyclopscore.proxy.ICommonProxy;
import org.cyclops.everlastingabilities.GeneralConfig;
import org.cyclops.everlastingabilities.ability.AbilityHelpers;
import org.cyclops.everlastingabilities.ability.AbilityTypeRegistry;
import org.cyclops.everlastingabilities.ability.AbilityTypes;
import org.cyclops.everlastingabilities.ability.config.AbilityAbsorbtionConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityBlindnessConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityBonemealerConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityFertilityConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityFireResistanceConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityFlightConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityGlowingConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityHasteConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityHungerConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityInvisibilityConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityJumpBoostConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityLevitationConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityLuckConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityMagnetizeConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityMiningFatigueConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityNauseaConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityNightVisionConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityPoisonConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityPowerStareConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityRegenerationConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityResistanceConfig;
import org.cyclops.everlastingabilities.ability.config.AbilitySaturationConfig;
import org.cyclops.everlastingabilities.ability.config.AbilitySlownessConfig;
import org.cyclops.everlastingabilities.ability.config.AbilitySpeedConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityStepAssistConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityStrengthConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityUnluckConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityWaterBreathingConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityWeaknessConfig;
import org.cyclops.everlastingabilities.ability.config.AbilityWitherConfig;
import org.cyclops.everlastingabilities.api.Ability;
import org.cyclops.everlastingabilities.api.IAbilityType;
import org.cyclops.everlastingabilities.api.IAbilityTypeRegistry;
import org.cyclops.everlastingabilities.api.capability.DefaultMutableAbilityStore;
import org.cyclops.everlastingabilities.api.capability.IMutableAbilityStore;
import org.cyclops.everlastingabilities.capability.AbilityStoreConfig;
import org.cyclops.everlastingabilities.capability.MutableAbilityStoreConfig;
import org.cyclops.everlastingabilities.command.CommandModifyAbilities;
import org.cyclops.everlastingabilities.item.ItemAbilityBottle;
import org.cyclops.everlastingabilities.item.ItemAbilityBottleConfig;
import org.cyclops.everlastingabilities.item.ItemAbilityTotem;
import org.cyclops.everlastingabilities.item.ItemAbilityTotemConfig;
import org.cyclops.everlastingabilities.network.packet.RequestAbilityStorePacket;
import org.cyclops.everlastingabilities.recipe.TotemRecycleRecipe;

@Mod(modid="everlastingabilities", name="EverlastingAbilities", useMetadata=true, version="1.3.16", dependencies="required-after:forge@[14.23.1.2555,);required-after:cyclopscore@[0.10.22,);", guiFactory="org.cyclops.everlastingabilities.GuiConfigOverview$ExtendedConfigGuiFactory", certificateFingerprint="bd0353b3e8a2810d60dd584e256e364bc3bedd44", acceptedMinecraftVersions="[1.12.2]")
public class EverlastingAbilities
extends ModBaseVersionable {
    @SidedProxy(clientSide="org.cyclops.everlastingabilities.proxy.ClientProxy", serverSide="org.cyclops.everlastingabilities.proxy.CommonProxy")
    public static ICommonProxy proxy;
    @Mod.Instance(value="everlastingabilities")
    public static EverlastingAbilities _instance;
    private static final String NBT_TOTEM_SPAWNED = "everlastingabilities:totemSpawned";

    public EverlastingAbilities() {
        super("everlastingabilities", "EverlastingAbilities", "1.3.16");
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    protected RecipeHandler constructRecipeHandler() {
        return new RecipeHandler((ModBase)this, new String[]{"shaped.xml"}){

            protected void loadPredefineds(Map<String, ItemStack> predefinedItems, Set<String> predefinedValues) {
                super.loadPredefineds(predefinedItems, predefinedValues);
                if (ConfigHandler.isEnabled(ItemAbilityBottleConfig.class)) {
                    for (IAbilityType abilityType : AbilityTypes.REGISTRY.getAbilityTypes()) {
                        int maxLevel = abilityType.getMaxLevel() == -1 ? 5 : abilityType.getMaxLevel();
                        for (int level = 1; level <= maxLevel; ++level) {
                            Ability ability = new Ability(abilityType, level);
                            String name = abilityType.getUnlocalizedName();
                            String[] split = name.split("\\.");
                            name = split[split.length - 2];
                            String id = "everlastingabilities:abilityTotem_" + name + "_" + level;
                            predefinedItems.put(id, ItemAbilityTotem.getInstance().getTotem(ability));
                        }
                    }
                }
            }
        };
    }

    protected ICommand constructBaseCommand() {
        HashMap commands = Maps.newHashMap();
        commands.put("abilities", new CommandModifyAbilities((ModBase)this));
        CommandMod command = new CommandMod((ModBase)this, (Map)commands);
        command.addAlias("ea");
        return command;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.getRegistryManager().addRegistry(IAbilityTypeRegistry.class, (IRegistry)AbilityTypeRegistry.getInstance());
        super.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        super.init(event);
        this.getCapabilityConstructorRegistry().registerInheritableEntity(EntityPlayer.class, (ICapabilityConstructor)new SimpleCapabilityConstructor<IMutableAbilityStore, EntityPlayer>(){

            @Nullable
            public ICapabilityProvider createProvider(EntityPlayer host) {
                return new SerializableCapabilityProvider(this.getCapability(), (Object)new DefaultMutableAbilityStore());
            }

            public Capability<IMutableAbilityStore> getCapability() {
                return MutableAbilityStoreConfig.CAPABILITY;
            }
        });
        this.getCapabilityConstructorRegistry().registerInheritableEntity(IAnimals.class, (ICapabilityConstructor)new SimpleCapabilityConstructor<IMutableAbilityStore, IAnimals>(){

            @Nullable
            public ICapabilityProvider createProvider(IAnimals host) {
                if (host instanceof Entity) {
                    Entity entity = (Entity)host;
                    DefaultMutableAbilityStore store = new DefaultMutableAbilityStore();
                    if (!MinecraftHelpers.isClientSide() && host instanceof EntityLivingBase && GeneralConfig.mobAbilityChance > 0 && entity.func_145782_y() % GeneralConfig.mobAbilityChance == 0) {
                        Random rand = new Random();
                        rand.setSeed(entity.func_145782_y());
                        EnumRarity rarity = AbilityHelpers.getRandomRarity(rand);
                        AbilityHelpers.getRandomAbility(rand, rarity).ifPresent(abilityType -> store.addAbility(new Ability((IAbilityType)abilityType, 1), true));
                    }
                    return new SerializableCapabilityProvider(this.getCapability(), (Object)store);
                }
                return null;
            }

            public Capability<IMutableAbilityStore> getCapability() {
                return MutableAbilityStoreConfig.CAPABILITY;
            }
        });
        if (ItemAbilityTotemConfig.totemCraftingCount > 0) {
            ResourceLocation id = CraftingHelpers.newRecipeIdentifier((ItemStack)new ItemStack((Item)ItemAbilityTotem.getInstance()));
            CraftingHelpers.registerRecipe((ResourceLocation)id, (IRecipe)new TotemRecycleRecipe());
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        super.onServerStarting(event);
    }

    @Mod.EventHandler
    public void onServerStarted(FMLServerStartedEvent event) {
        super.onServerStarted(event);
    }

    @Mod.EventHandler
    public void onServerStopping(FMLServerStoppingEvent event) {
        super.onServerStopping(event);
    }

    public CreativeTabs constructDefaultCreativeTab() {
        return new ItemCreativeTab((ModBase)this, (IObjectReference)new ItemConfigReference(ItemAbilityTotemConfig.class));
    }

    public void onGeneralConfigsRegister(ConfigHandler configHandler) {
        configHandler.add((ExtendedConfig)new GeneralConfig());
    }

    public void onMainConfigsRegister(ConfigHandler configHandler) {
        super.onMainConfigsRegister(configHandler);
        configHandler.add((ExtendedConfig)new AbilityStoreConfig());
        configHandler.add((ExtendedConfig)new MutableAbilityStoreConfig());
        configHandler.add((ExtendedConfig)new ItemAbilityTotemConfig());
        configHandler.add((ExtendedConfig)new ItemAbilityBottleConfig());
        configHandler.add((ExtendedConfig)new AbilitySpeedConfig());
        configHandler.add((ExtendedConfig)new AbilityHasteConfig());
        configHandler.add((ExtendedConfig)new AbilityStrengthConfig());
        configHandler.add((ExtendedConfig)new AbilityJumpBoostConfig());
        configHandler.add((ExtendedConfig)new AbilityRegenerationConfig());
        configHandler.add((ExtendedConfig)new AbilityResistanceConfig());
        configHandler.add((ExtendedConfig)new AbilityFireResistanceConfig());
        configHandler.add((ExtendedConfig)new AbilityWaterBreathingConfig());
        configHandler.add((ExtendedConfig)new AbilityInvisibilityConfig());
        configHandler.add((ExtendedConfig)new AbilityNightVisionConfig());
        configHandler.add((ExtendedConfig)new AbilityAbsorbtionConfig());
        configHandler.add((ExtendedConfig)new AbilitySaturationConfig());
        configHandler.add((ExtendedConfig)new AbilityLuckConfig());
        configHandler.add((ExtendedConfig)new AbilitySlownessConfig());
        configHandler.add((ExtendedConfig)new AbilityMiningFatigueConfig());
        configHandler.add((ExtendedConfig)new AbilityNauseaConfig());
        configHandler.add((ExtendedConfig)new AbilityBlindnessConfig());
        configHandler.add((ExtendedConfig)new AbilityHungerConfig());
        configHandler.add((ExtendedConfig)new AbilityWeaknessConfig());
        configHandler.add((ExtendedConfig)new AbilityPoisonConfig());
        configHandler.add((ExtendedConfig)new AbilityWitherConfig());
        configHandler.add((ExtendedConfig)new AbilityGlowingConfig());
        configHandler.add((ExtendedConfig)new AbilityLevitationConfig());
        configHandler.add((ExtendedConfig)new AbilityUnluckConfig());
        configHandler.add((ExtendedConfig)new AbilityFlightConfig());
        configHandler.add((ExtendedConfig)new AbilityStepAssistConfig());
        configHandler.add((ExtendedConfig)new AbilityFertilityConfig());
        configHandler.add((ExtendedConfig)new AbilityBonemealerConfig());
        configHandler.add((ExtendedConfig)new AbilityPowerStareConfig());
        configHandler.add((ExtendedConfig)new AbilityMagnetizeConfig());
    }

    public ICommonProxy getProxy() {
        return proxy;
    }

    public static void clog(String message) {
        EverlastingAbilities.clog(Level.INFO, message);
    }

    public static void clog(Level level, String message) {
        _instance.getLoggerHelper().log(level, message);
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.getEntity();
            this.getPacketHandler().sendToPlayer((PacketBase)new SendPlayerCapabilitiesPacket(ObfuscationHelpers.getEntityCapabilities((Entity)player)), player);
        } else if (MinecraftHelpers.isClientSide() && event.getEntity().hasCapability(MutableAbilityStoreConfig.CAPABILITY, null)) {
            this.getPacketHandler().sendToServer((PacketBase)new RequestAbilityStorePacket(event.getEntity().func_110124_au().toString()));
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (GeneralConfig.totemMaximumSpawnRarity >= 0 && ConfigHandler.isEnabled(ItemAbilityBottleConfig.class)) {
            NBTTagCompound playerTag;
            NBTTagCompound tag = event.player.getEntityData();
            if (!tag.func_74764_b("PlayerPersisted")) {
                tag.func_74782_a("PlayerPersisted", (NBTBase)new NBTTagCompound());
            }
            if (!(playerTag = tag.func_74775_l("PlayerPersisted")).func_74764_b(NBT_TOTEM_SPAWNED)) {
                playerTag.func_74757_a(NBT_TOTEM_SPAWNED, true);
                World world = event.player.field_70170_p;
                EntityPlayer player = event.player;
                EnumRarity rarity = EnumRarity.values()[GeneralConfig.totemMaximumSpawnRarity];
                AbilityHelpers.getRandomAbilityUntil(world.field_73012_v, rarity, true).ifPresent(abilityType -> {
                    ItemStack itemStack = new ItemStack((Item)ItemAbilityBottle.getInstance());
                    IMutableAbilityStore mutableAbilityStore = (IMutableAbilityStore)itemStack.getCapability(MutableAbilityStoreConfig.CAPABILITY, null);
                    mutableAbilityStore.addAbility(new Ability((IAbilityType)abilityType, 1), true);
                    ItemStackHelpers.spawnItemStackToPlayer((World)world, (BlockPos)player.func_180425_c(), (ItemStack)itemStack, (EntityPlayer)player);
                    EntityHelpers.spawnXpAtPlayer((World)world, (EntityPlayer)player, (int)abilityType.getBaseXpPerLevel());
                });
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K && event.getEntityLiving().hasCapability(MutableAbilityStoreConfig.CAPABILITY, null) && (event.getEntityLiving() instanceof EntityPlayer ? GeneralConfig.dropAbilitiesOnPlayerDeath > 0 && (GeneralConfig.alwaysDropAbilities || event.getSource() instanceof EntityDamageSource && event.getSource().func_76346_g() instanceof EntityPlayer) : event.getSource() instanceof EntityDamageSource && event.getSource().func_76346_g() instanceof EntityPlayer)) {
            int toDrop = 1;
            if (event.getEntityLiving() instanceof EntityPlayer && (GeneralConfig.alwaysDropAbilities || event.getSource() instanceof EntityDamageSource && event.getSource().func_76346_g() instanceof EntityPlayer)) {
                toDrop = GeneralConfig.dropAbilitiesOnPlayerDeath;
            }
            EntityLivingBase entity = event.getEntityLiving();
            IMutableAbilityStore mutableAbilityStore = (IMutableAbilityStore)entity.getCapability(MutableAbilityStoreConfig.CAPABILITY, null);
            ItemStack itemStack = null;
            IMutableAbilityStore itemStackStore = null;
            if (ConfigHandler.isEnabled(ItemAbilityTotemConfig.class)) {
                itemStack = new ItemStack((Item)ItemAbilityTotem.getInstance());
                itemStackStore = (IMutableAbilityStore)itemStack.getCapability(MutableAbilityStoreConfig.CAPABILITY, null);
            }
            ArrayList abilities = Lists.newArrayList(mutableAbilityStore.getAbilities());
            for (Ability ability : abilities) {
                Ability toRemove;
                Ability removed;
                if (toDrop <= 0 || (removed = mutableAbilityStore.removeAbility(toRemove = new Ability(ability.getAbilityType(), toDrop), true)) == null) continue;
                toDrop -= removed.getLevel();
                if (itemStackStore != null) {
                    itemStackStore.addAbility(removed, true);
                }
                entity.func_145747_a((ITextComponent)new TextComponentTranslation(L10NHelpers.localize((String)"chat.everlastingabilities.playerLostAbility", (Object[])new Object[]{entity.func_70005_c_(), removed.getAbilityType().getRarity().field_77937_e.toString() + TextFormatting.BOLD + L10NHelpers.localize((String)removed.getAbilityType().getUnlocalizedName(), (Object[])new Object[0]) + TextFormatting.RESET, removed.getLevel()}), new Object[0]));
            }
            if (itemStack != null && !itemStackStore.getAbilities().isEmpty()) {
                ItemStackHelpers.spawnItemStack((World)entity.field_70170_p, (BlockPos)entity.func_180425_c(), (ItemStack)itemStack);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        IMutableAbilityStore oldStore = (IMutableAbilityStore)event.getOriginal().getCapability(MutableAbilityStoreConfig.CAPABILITY, null);
        IMutableAbilityStore newStore = (IMutableAbilityStore)event.getEntityPlayer().getCapability(MutableAbilityStoreConfig.CAPABILITY, null);
        newStore.setAbilities(Maps.newHashMap(oldStore.getAbilitiesRaw()));
    }
}

