/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.utils;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ColorUtils {
    public static int getColorFrom(ResourceLocation location) {
        TextureMap textureMap = Minecraft.func_71410_x().func_147117_R();
        TextureAtlasSprite sprite = textureMap.getTextureExtry(location.toString());
        if (sprite == null) {
            return -1;
        }
        if (sprite.func_110970_k() == 0) {
            return -1;
        }
        int[][] pixelMatrix = sprite.func_147965_a(0);
        int total = 0;
        int red = 0;
        int blue = 0;
        int green = 0;
        int[][] nArray = pixelMatrix;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int[] pixelArray;
            for (int pixel : pixelArray = nArray[i]) {
                Color color = new Color(pixel);
                if (color.getAlpha() < 255) continue;
                ++total;
                red += color.getRed();
                green += color.getGreen();
                blue += color.getBlue();
            }
        }
        if (total > 0) {
            return new Color(red / total, green / total, blue / total, 255).getRGB();
        }
        return -1;
    }
}

