/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.world;

import com.buuz135.industrial.proxy.client.infopiece.MaterialStoneWorkInfoPiece;
import com.buuz135.industrial.tile.CustomColoredItemHandler;
import com.buuz135.industrial.tile.CustomElectricMachine;
import com.buuz135.industrial.utils.CraftingUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableListIterator;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.ndrei.teslacorelib.TeslaCoreLib;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.netsync.SimpleNBTMessage;

public class MaterialStoneWorkFactoryTile
extends CustomElectricMachine {
    private static final String NBT_MODE = "Mode";
    private LinkedHashMap<ItemStackHandler, Mode> modeList;

    public MaterialStoneWorkFactoryTile() {
        super(MaterialStoneWorkFactoryTile.class.getName().hashCode());
    }

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
        this.modeList = new LinkedHashMap();
        EnumDyeColor[] colors = new EnumDyeColor[]{EnumDyeColor.YELLOW, EnumDyeColor.BLUE, EnumDyeColor.GREEN, EnumDyeColor.ORANGE, EnumDyeColor.PURPLE};
        for (int i = 0; i < 5; ++i) {
            ItemStackHandler item = new ItemStackHandler(2);
            this.addInventory((IItemHandler)new CustomColoredItemHandler((IItemHandler)item, colors[i], "Material process", 50 + 24 * i, 25, 1, 2){

                public boolean canInsertItem(int slot, ItemStack stack) {
                    return false;
                }
            });
            this.addInventoryToStorage(item, "item" + i);
            this.modeList.put(item, Mode.NONE);
        }
    }

    @Override
    public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer<?> container) {
        List<IGuiContainerPiece> pieces = super.getGuiContainerPieces(container);
        for (int i = 0; i < this.modeList.size() - 1; ++i) {
            pieces.add((IGuiContainerPiece)new MaterialStoneWorkInfoPiece(this, 62 + 24 * i, 64, i));
        }
        return pieces;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound compound1 = super.func_189515_b(compound);
        NBTTagCompound m = new NBTTagCompound();
        this.modeList.forEach((handler, mode) -> m.func_74778_a(String.valueOf(Iterators.indexOf(this.modeList.entrySet().iterator(), input -> ((ItemStackHandler)input.getKey()).equals(handler))), mode.toString()));
        compound1.func_74782_a(NBT_MODE, (NBTBase)m);
        return compound1;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b(NBT_MODE)) {
            compound.func_74775_l(NBT_MODE).func_150296_c().forEach(s -> {
                Map.Entry it = (Map.Entry)Iterators.get(this.modeList.entrySet().iterator(), (int)Integer.parseInt(s));
                this.modeList.replace((ItemStackHandler)it.getKey(), Mode.valueOf(compound.func_74775_l(NBT_MODE).func_74779_i(s)));
            });
        }
    }

    protected float performWork() {
        boolean i = false;
        UnmodifiableListIterator it = ImmutableList.copyOf(this.modeList.entrySet()).reverse().listIterator();
        int work = (int)Math.pow(2.0, this.speedUpgradeLevel());
        Map.Entry nextEntry = null;
        while (it.hasNext()) {
            Map.Entry currentEntry = (Map.Entry)it.next();
            ItemStack cobble = new ItemStack(Blocks.field_150347_e, work);
            if (nextEntry != null) {
                ItemStack result;
                int slot;
                if (currentEntry.getValue() == Mode.FURNACE) {
                    for (slot = 0; slot < ((ItemStackHandler)currentEntry.getKey()).getSlots(); ++slot) {
                        if (((ItemStackHandler)currentEntry.getKey()).getStackInSlot(slot).func_190926_b()) continue;
                        ItemStack stack = ((ItemStackHandler)currentEntry.getKey()).getStackInSlot(slot).func_77946_l();
                        stack.func_190920_e(1);
                        result = FurnaceRecipes.func_77602_a().func_151395_a(stack).func_77946_l();
                        result.func_190920_e(work);
                        if (result.func_190926_b() || !ItemHandlerHelper.insertItem((IItemHandler)((IItemHandler)nextEntry.getKey()), (ItemStack)result, (boolean)true).func_190926_b()) continue;
                        ItemHandlerHelper.insertItem((IItemHandler)((IItemHandler)nextEntry.getKey()), (ItemStack)result, (boolean)false);
                        ((ItemStackHandler)currentEntry.getKey()).getStackInSlot(slot).func_190918_g(work);
                        return 1.0f;
                    }
                }
                if (currentEntry.getValue() == Mode.CRAFT_BIG || currentEntry.getValue() == Mode.CRAFT_SMALL) {
                    int size = currentEntry.getValue() == Mode.CRAFT_BIG ? 3 : 2;
                    for (int slot2 = 0; slot2 < ((ItemStackHandler)currentEntry.getKey()).getSlots(); ++slot2) {
                        if (((ItemStackHandler)currentEntry.getKey()).getStackInSlot(slot2).func_190916_E() < size * size || (result = CraftingUtils.findOutput(size, ((ItemStackHandler)currentEntry.getKey()).getStackInSlot(slot2), this.field_145850_b)).func_190926_b() || !ItemHandlerHelper.insertItem((IItemHandler)((IItemHandler)nextEntry.getKey()), (ItemStack)result, (boolean)true).func_190926_b()) continue;
                        ItemHandlerHelper.insertItem((IItemHandler)((IItemHandler)nextEntry.getKey()), (ItemStack)result, (boolean)false);
                        ((ItemStackHandler)currentEntry.getKey()).getStackInSlot(slot2).func_190918_g(size * size);
                        return 1.0f;
                    }
                }
                if (currentEntry.getValue() == Mode.GRIND) {
                    for (slot = 0; slot < ((ItemStackHandler)currentEntry.getKey()).getSlots(); ++slot) {
                        ItemStack result2 = CraftingUtils.getCrushOutput(new ItemStack(((ItemStackHandler)currentEntry.getKey()).getStackInSlot(slot).func_77973_b(), 1)).func_77946_l();
                        result2.func_190920_e(work);
                        if (result2.func_190926_b() || !ItemHandlerHelper.insertItem((IItemHandler)((IItemHandler)nextEntry.getKey()), (ItemStack)result2, (boolean)true).func_190926_b()) continue;
                        ItemHandlerHelper.insertItem((IItemHandler)((IItemHandler)nextEntry.getKey()), (ItemStack)result2, (boolean)false);
                        ((ItemStackHandler)currentEntry.getKey()).getStackInSlot(slot).func_190918_g(work);
                        return 1.0f;
                    }
                }
                if (!it.hasNext() && !cobble.equals(ItemHandlerHelper.insertItem((IItemHandler)((IItemHandler)currentEntry.getKey()), (ItemStack)cobble, (boolean)true))) {
                    ItemHandlerHelper.insertItem((IItemHandler)((IItemHandler)currentEntry.getKey()), (ItemStack)cobble, (boolean)false);
                    return 1.0f;
                }
            }
            nextEntry = currentEntry;
        }
        return (float)i;
    }

    protected boolean shouldAddFluidItemsInventory() {
        return false;
    }

    public void nextMode(int id) {
        Map.Entry<ItemStackHandler, Mode> it = this.getEntry(id);
        this.modeList.replace(it.getKey(), Mode.values()[(Arrays.asList(Mode.values()).indexOf((Object)it.getValue()) + 1) % Mode.values().length]);
        if (TeslaCoreLib.INSTANCE.isClientSide()) {
            NBTTagCompound compound = this.setupSpecialNBTMessage("CHANGE_MODE");
            Map.Entry<ItemStackHandler, Mode> mode = this.getEntry(id);
            compound.func_74768_a("id", id);
            compound.func_74778_a("value", mode.getValue().toString());
            this.sendToServer(compound);
        }
    }

    protected SimpleNBTMessage processClientMessage(String messageType, NBTTagCompound compound) {
        super.processClientMessage(messageType, compound);
        if (messageType.equals("CHANGE_MODE")) {
            Map.Entry<ItemStackHandler, Mode> entry = this.getEntry(compound.func_74762_e("id"));
            this.modeList.replace(entry.getKey(), Mode.valueOf(compound.func_74779_i("value")));
        }
        return null;
    }

    public Map.Entry<ItemStackHandler, Mode> getEntry(int id) {
        return (Map.Entry)Iterators.get((Iterator)ImmutableList.copyOf(this.modeList.entrySet()).iterator(), (int)id);
    }

    public LinkedHashMap<ItemStackHandler, Mode> getModeList() {
        return this.modeList;
    }

    public static enum Mode {
        NONE(new ItemStack(Blocks.field_180401_cv), "text.industrialforegoing.button.stone.stopped"),
        FURNACE(new ItemStack(Blocks.field_150460_al), "text.industrialforegoing.button.stone.furnace"),
        CRAFT_SMALL(new ItemStack(Blocks.field_150344_f), "text.industrialforegoing.button.stone.two_craft"),
        GRIND(new ItemStack(Items.field_151046_w), "text.industrialforegoing.button.stone.grind"),
        CRAFT_BIG(new ItemStack(Blocks.field_150462_ai), "text.industrialforegoing.button.stone.three_craft");

        private ItemStack itemStack;
        private String name;

        private Mode(ItemStack itemStack, String name) {
            this.itemStack = itemStack;
            this.name = name;
        }

        public ItemStack getItemStack() {
            return this.itemStack;
        }

        public String getName() {
            return this.name;
        }
    }
}

