/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.world;

import com.buuz135.industrial.tile.CustomColoredItemHandler;
import com.buuz135.industrial.tile.WorkingAreaElectricMachine;
import com.buuz135.industrial.utils.BlockUtils;
import com.buuz135.industrial.utils.WorkUtils;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityShulkerBox;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.IWorldNameable;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class BlockDestroyerTile
extends WorkingAreaElectricMachine {
    private ItemStackHandler outItems;

    public BlockDestroyerTile() {
        super(BlockDestroyerTile.class.getName().hashCode());
    }

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
        this.outItems = new ItemStackHandler(18){

            protected void onContentsChanged(int slot) {
                BlockDestroyerTile.this.func_70296_d();
            }
        };
        this.addInventory((IItemHandler)new CustomColoredItemHandler((IItemHandler)this.outItems, EnumDyeColor.ORANGE, "Output items", 54, 25, 6, 3){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return false;
            }

            public boolean canExtractItem(int slot) {
                return true;
            }
        });
        this.addInventoryToStorage(this.outItems, "block_destroyer_out");
    }

    @Override
    public float work() {
        if (WorkUtils.isDisabled(this.func_145838_q())) {
            return 0.0f;
        }
        List<BlockPos> blockPosList = BlockUtils.getBlockPosInAABB(this.getWorkingArea());
        for (BlockPos pos : blockPosList) {
            if (this.field_145850_b.func_175623_d(pos) || !BlockUtils.canBlockBeBroken(this.field_145850_b, pos)) continue;
            Block block = this.field_145850_b.func_180495_p(pos).func_177230_c();
            TileEntity tile = this.field_145850_b.func_175625_s(pos);
            if (block.func_176195_g(this.field_145850_b.func_180495_p(pos), this.field_145850_b, pos) < 0.0f) continue;
            List drops = block.getDrops((IBlockAccess)this.field_145850_b, pos, this.field_145850_b.func_180495_p(pos), 0);
            boolean canInsert = true;
            for (ItemStack stack : drops) {
                if (tile instanceof IWorldNameable && ((IWorldNameable)tile).func_145818_k_()) {
                    stack.func_151001_c(((IWorldNameable)tile).func_70005_c_());
                }
                if (ItemHandlerHelper.insertItem((IItemHandler)this.outItems, (ItemStack)stack, (boolean)true).func_190926_b()) continue;
                canInsert = false;
                break;
            }
            if (!canInsert) continue;
            for (ItemStack stack : drops) {
                ItemHandlerHelper.insertItem((IItemHandler)this.outItems, (ItemStack)stack, (boolean)false);
            }
            if (tile instanceof TileEntityShulkerBox) {
                InventoryHelper.func_180175_a((World)this.field_145850_b, (BlockPos)pos, (IInventory)((IInventory)tile));
                ((TileEntityShulkerBox)tile).func_174888_l();
            }
            this.field_145850_b.func_175698_g(pos);
            return 1.0f;
        }
        return 0.0f;
    }
}

