/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.misc;

import com.buuz135.industrial.proxy.client.infopiece.BlackHoleInfoPiece;
import com.buuz135.industrial.proxy.client.infopiece.IHasDisplayStack;
import com.buuz135.industrial.tile.CustomSidedTileEntity;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.inventory.FluidTankType;
import net.ndrei.teslacorelib.items.TeslaWrench;
import org.jetbrains.annotations.NotNull;

public class BlackHoleTankTile
extends CustomSidedTileEntity
implements IHasDisplayStack {
    private IFluidTank tank;
    private boolean hadFluid;

    public BlackHoleTankTile() {
        super(BlackHoleTankTile.class.getName().hashCode());
    }

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
        this.tank = this.addSimpleFluidTank(Integer.MAX_VALUE, "Tank", EnumDyeColor.CYAN, 6, 25, FluidTankType.BOTH, fluidStack -> true, fluidStack -> true);
    }

    protected void innerUpdate() {
        if (this.hadFluid != this.tank.getFluidAmount() > 0) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
            this.hadFluid = this.tank.getFluidAmount() > 0;
        }
    }

    protected boolean supportsAddons() {
        return false;
    }

    @Override
    public ItemStack getItemStack() {
        if (this.tank.getFluid() == null || FluidUtil.getFilledBucket((FluidStack)this.tank.getFluid()).func_190926_b()) {
            return new ItemStack(Items.field_151133_ar);
        }
        return FluidUtil.getFilledBucket((FluidStack)this.tank.getFluid());
    }

    @Override
    public int getAmount() {
        return this.tank.getFluidAmount();
    }

    @Override
    public String getDisplayNameUnlocalized() {
        return this.tank.getFluid() == null ? "text.industrialforegoing.display.empty" : this.tank.getFluid().getLocalizedName();
    }

    public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer container) {
        List list = super.getGuiContainerPieces(container);
        list.add(new BlackHoleInfoPiece(this, 44, 25));
        return list;
    }

    public IFluidTank getTank() {
        return this.tank;
    }

    public boolean getAllowRedstoneControl() {
        return false;
    }

    protected boolean getShowPauseDrawerPiece() {
        return false;
    }

    @NotNull
    public EnumActionResult onWrenchUse(@NotNull TeslaWrench wrench, @NotNull EntityPlayer player, @NotNull World world, @NotNull BlockPos pos, @NotNull EnumHand hand, @NotNull EnumFacing facing, float hitX, float hitY, float hitZ) {
        return EnumActionResult.PASS;
    }
}

