/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.generator;

import com.buuz135.industrial.proxy.BlockRegistry;
import com.buuz135.industrial.proxy.client.infopiece.PetrifiedFuelInfoPiece;
import com.buuz135.industrial.tile.CustomGeneratorMachine;
import com.buuz135.industrial.utils.WorkUtils;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.ndrei.teslacorelib.containers.BasicTeslaContainer;
import net.ndrei.teslacorelib.containers.FilteredSlot;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.gui.TiledRenderedGuiPiece;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.inventory.ColoredItemHandler;

public class PetrifiedFuelGeneratorTile
extends CustomGeneratorMachine {
    private ItemStackHandler inStackHandler;
    private ItemStack current = ItemStack.field_190927_a;
    private int burnTime = 0;

    public PetrifiedFuelGeneratorTile() {
        super(PetrifiedFuelGeneratorTile.class.getName().hashCode());
    }

    public static long getEnergyProduced(int burnTime) {
        return burnTime / BlockRegistry.petrifiedFuelGeneratorBlock.getTimeModifier();
    }

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
        this.inStackHandler = new ItemStackHandler(3){

            protected void onContentsChanged(int slot) {
                PetrifiedFuelGeneratorTile.this.func_70296_d();
            }
        };
        super.addInventory((IItemHandler)new ColoredItemHandler((IItemHandler)this.inStackHandler, EnumDyeColor.GREEN, "Fuel input", new BoundingRectangle(61, 25, 18, 54)){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return PetrifiedFuelGeneratorTile.this.acceptsInputStack(slot, stack);
            }

            public boolean canExtractItem(int slot) {
                return false;
            }

            public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer container) {
                List pieces = super.getGuiContainerPieces(container);
                BoundingRectangle box = this.getBoundingBox();
                pieces.add(new TiledRenderedGuiPiece(box.getLeft(), box.getTop(), 18, 18, 1, 3, BasicTeslaGuiContainer.Companion.getMACHINE_BACKGROUND(), 108, 225, EnumDyeColor.GREEN));
                return pieces;
            }

            public List<Slot> getSlots(BasicTeslaContainer container) {
                List slots = super.getSlots(container);
                BoundingRectangle boundingRectangle = this.getBoundingBox();
                for (int y = 0; y < this.getInnerHandler().getSlots(); ++y) {
                    slots.add(new FilteredSlot(this.getItemHandlerForContainer(), y, boundingRectangle.getLeft() + 1, boundingRectangle.getTop() + 1 + y * 18));
                }
                return slots;
            }
        });
        super.addInventoryToStorage(this.inStackHandler, "pet_gen_input");
    }

    private boolean acceptsInputStack(int slot, ItemStack stack) {
        return !stack.func_190926_b() && TileEntityFurnace.func_145954_b((ItemStack)stack) && !stack.func_77973_b().equals(Items.field_151129_at) && !stack.func_77973_b().equals(ForgeModContainer.getInstance().universalBucket) && PetrifiedFuelGeneratorTile.getEnergyProduced(TileEntityFurnace.func_145952_a((ItemStack)stack)) > 0L;
    }

    public ItemStack getFirstFuel(boolean replace) {
        if (!replace) {
            return this.current;
        }
        for (int i = 0; i < this.inStackHandler.getSlots(); ++i) {
            if (this.inStackHandler.getStackInSlot(i).func_190926_b()) continue;
            this.current = new ItemStack(this.inStackHandler.getStackInSlot(i).func_77973_b(), 1);
            this.forceSync();
            return this.inStackHandler.getStackInSlot(i);
        }
        this.current = ItemStack.field_190927_a;
        return this.current;
    }

    public long consumeFuel() {
        if (WorkUtils.isDisabled(this.func_145838_q())) {
            return 0L;
        }
        ItemStack temp = this.getFirstFuel(true);
        if (temp.func_190926_b()) {
            return 0L;
        }
        this.burnTime = TileEntityFurnace.func_145952_a((ItemStack)temp);
        temp.func_190920_e(temp.func_190916_E() - 1);
        return (long)((float)(this.burnTime * 100) * BlockRegistry.petrifiedFuelGeneratorBlock.getBurnTimeMultiplier());
    }

    public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer container) {
        List<IGuiContainerPiece> list = super.getGuiContainerPieces(container);
        list.add((IGuiContainerPiece)new PetrifiedFuelInfoPiece(this, 88, 25));
        return list;
    }

    protected long getEnergyFillRate() {
        return PetrifiedFuelGeneratorTile.getEnergyProduced(this.burnTime);
    }

    public ItemStack getCurrent() {
        return this.current;
    }
}

